/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient.internal;

import com.pgssoft.httpclient.internal.UrlParams;
import com.pgssoft.httpclient.internal.UrlParamsMatcher;
import com.pgssoft.httpclient.internal.debug.Debugger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public class UrlConditions {
    private static final int EMPTY_PORT = -1;
    private UrlParamsMatcher parameterConditions = new UrlParamsMatcher();
    private Matcher<String> referenceCondition = Matchers.anyOf((Matcher)Matchers.any(String.class), (Matcher)Matchers.nullValue());
    private Matcher<String> hostCondition = Matchers.anyOf((Matcher)Matchers.any(String.class), (Matcher)Matchers.nullValue());
    private Matcher<String> pathCondition = Matchers.anyOf((Matcher)Matchers.any(String.class), (Matcher)Matchers.nullValue());
    private Matcher<Integer> portCondition = Matchers.any(Integer.class);
    private Matcher<String> schemaCondition = Matchers.anyOf((Matcher)Matchers.any(String.class), (Matcher)Matchers.nullValue());

    public static UrlConditions parse(String urlText) {
        try {
            UrlConditions conditions = new UrlConditions();
            URI uri = new URI(urlText);
            UrlParams params = UrlParams.parse(uri.getQuery());
            conditions.setSchemaCondition(UrlConditions.getStringMatcher(uri.getScheme()));
            conditions.setHostCondition(UrlConditions.getStringMatcher(uri.getHost()));
            conditions.setPortCondition((Matcher<Integer>)Matchers.equalTo((Object)uri.getPort()));
            conditions.setPathCondition(UrlConditions.getStringMatcher(uri.getPath()));
            conditions.setReferenceCondition(UrlConditions.getStringMatcher(uri.getFragment()));
            conditions.setParameterConditions(new UrlParamsMatcher(params));
            return conditions;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Matcher<String> getStringMatcher(String val) {
        if (val == null || val.isEmpty()) {
            return Matchers.isEmptyOrNullString();
        }
        return Matchers.equalTo((Object)val);
    }

    public boolean matches(URI uri) {
        return this.hostCondition.matches((Object)uri.getHost()) && this.pathCondition.matches((Object)uri.getPath()) && this.portCondition.matches((Object)uri.getPort()) && this.referenceCondition.matches((Object)uri.getFragment()) && this.schemaCondition.matches((Object)uri.getScheme()) && this.parameterConditions.matches(uri.getQuery());
    }

    public void debug(HttpRequest request, Debugger debugger) {
        URI uri = request.uri();
        debugger.message(this.schemaCondition.matches((Object)uri.getScheme()), "schema is " + this.describeMatcher(this.schemaCondition));
        debugger.message(this.hostCondition.matches((Object)uri.getHost()), "host is " + this.describeMatcher(this.hostCondition));
        debugger.message(this.portCondition.matches((Object)uri.getPort()), "port is " + this.portDebugDescription());
        debugger.message(this.pathCondition.matches((Object)uri.getPath()), "path is " + this.describeMatcher(this.pathCondition));
        debugger.message(this.parameterConditions.matches(uri.getQuery()), "all URI parameters have matching value");
        debugger.message(this.referenceCondition.matches((Object)uri.getFragment()), "URI reference has matching value");
    }

    private String portDebugDescription() {
        if (this.portCondition.matches((Object)-1)) {
            return "empty";
        }
        return this.describeMatcher(this.portCondition);
    }

    private String describeMatcher(Matcher<?> matcher) {
        return StringDescription.toString(matcher);
    }

    public UrlParamsMatcher getParameterConditions() {
        return this.parameterConditions;
    }

    public void setParameterConditions(UrlParamsMatcher parameterConditions) {
        this.parameterConditions = parameterConditions;
    }

    public Matcher<String> getReferenceCondition() {
        return this.referenceCondition;
    }

    public void setReferenceCondition(Matcher<String> referenceCondition) {
        this.referenceCondition = referenceCondition;
    }

    public Matcher<String> getHostCondition() {
        return this.hostCondition;
    }

    public void setHostCondition(Matcher<String> hostCondition) {
        this.hostCondition = hostCondition;
    }

    public Matcher<String> getPathCondition() {
        return this.pathCondition;
    }

    public void setPathCondition(Matcher<String> pathCondition) {
        this.pathCondition = pathCondition;
    }

    public Matcher<Integer> getPortCondition() {
        return this.portCondition;
    }

    public void setPortCondition(Matcher<Integer> portCondition) {
        this.portCondition = portCondition;
    }

    public Matcher<String> getSchemaCondition() {
        return this.schemaCondition;
    }

    public void setSchemaCondition(Matcher<String> schemaCondition) {
        this.schemaCondition = schemaCondition;
    }
}

