/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient.internal;

import com.pgssoft.httpclient.internal.ParameterValue;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class UrlParams {
    private final ArrayList<ParameterValue> params = new ArrayList();

    UrlParams() {
    }

    boolean contains(String name) {
        return this.params.stream().anyMatch(p -> p.getName().equals(name));
    }

    public List<ParameterValue> getParams() {
        return this.params;
    }

    static UrlParams parse(String query) {
        if (query == null) {
            return new UrlParams();
        }
        UrlParams urlParams = new UrlParams();
        UrlParams.splitQuery(query).forEach((k, v) -> urlParams.params.add(new ParameterValue((String)k, (List<String>)v)));
        return urlParams;
    }

    private static Map<String, List<String>> splitQuery(String query) {
        if (query == null || query.length() <= 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(query.split("&")).map(UrlParams::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private static AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String it) {
        int idx = it.indexOf("=");
        String key = idx > 0 ? it.substring(0, idx) : it;
        String value = idx > 0 && it.length() > idx + 1 ? it.substring(idx + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
    }

    public Set<String> getNames() {
        return this.params.stream().map(ParameterValue::getName).collect(Collectors.toSet());
    }
}

