/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient.internal;

import com.pgssoft.httpclient.internal.ParameterValue;
import com.pgssoft.httpclient.internal.UrlParams;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class UrlParamsMatcher {
    private Map<String, Matcher<Iterable<? extends String>>> matchers;

    public UrlParamsMatcher(UrlParams params) {
        this.matchers = new HashMap<String, Matcher<Iterable<? extends String>>>();
        for (ParameterValue param : params.getParams()) {
            Object[] values = param.getValues().toArray(new String[0]);
            this.matchers.put(param.getName(), (Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder((Object[])values));
        }
    }

    public UrlParamsMatcher() {
    }

    private boolean setsOfParametersAreEqual(String query) {
        Set<String> expectedParams = this.matchers.keySet();
        Set<String> actualParams = UrlParams.parse(query).getNames();
        return expectedParams.equals(actualParams);
    }

    private boolean allParamsHaveMatchingValue(String query) {
        UrlParams params = UrlParams.parse(query);
        return params.getParams().stream().allMatch(param -> this.matchers.get(param.getName()).matches(param.getValues()));
    }

    public boolean matches(String query) {
        return this.noMatchersWereDefined() || this.setsOfParametersAreEqual(query) && this.allParamsHaveMatchingValue(query);
    }

    private boolean noMatchersWereDefined() {
        return this.matchers == null;
    }

    public void addParam(String name, Matcher<Iterable<? extends String>> matcher) {
        if (this.noMatchersWereDefined()) {
            this.matchers = new HashMap<String, Matcher<Iterable<? extends String>>>();
        }
        this.matchers.put(name, matcher);
    }
}

