/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient.internal.condition;

import com.pgssoft.httpclient.Condition;
import com.pgssoft.httpclient.internal.PeekSubscriber;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.hamcrest.Matcher;

public final class BodyCondition
implements Condition {
    private final Matcher<String> matcher;

    public BodyCondition(Matcher<String> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(HttpRequest request) {
        Optional<HttpRequest.BodyPublisher> bodyPublisher = request.bodyPublisher();
        if (bodyPublisher.isEmpty()) {
            return this.matcher.matches(null);
        }
        PeekSubscriber subscriber = new PeekSubscriber();
        request.bodyPublisher().orElseThrow().subscribe(subscriber);
        ByteBuffer content = subscriber.content();
        return content != null && this.matcher.matches((Object)new String(content.array(), StandardCharsets.UTF_8));
    }

    @Override
    public String getDebugMessage() {
        return "body matches";
    }
}

