/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient.internal.condition;

import com.pgssoft.httpclient.Condition;
import java.net.http.HttpRequest;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public final class HeaderCondition
implements Condition {
    private final String header;
    private final Matcher<String> expectedValue;

    public HeaderCondition(String header, Matcher<String> expectedValue) {
        this.header = header;
        this.expectedValue = expectedValue;
    }

    @Override
    public boolean matches(HttpRequest request) {
        return request.headers().allValues(this.header).stream().filter(Objects::nonNull).anyMatch(arg_0 -> this.expectedValue.matches(arg_0));
    }

    @Override
    public String getDebugMessage() {
        return "header " + this.header + " is " + StringDescription.toString(this.expectedValue);
    }
}

