/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient.internal.rule;

import com.pgssoft.httpclient.Action;
import com.pgssoft.httpclient.Condition;
import com.pgssoft.httpclient.MockedServerResponse;
import com.pgssoft.httpclient.internal.UrlConditions;
import com.pgssoft.httpclient.internal.action.ActionBundle;
import com.pgssoft.httpclient.internal.debug.Debugger;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.util.List;
import java.util.Queue;

public final class Rule {
    private final UrlConditions urlConditions;
    private final List<Condition> conditions;
    private final Queue<ActionBundle> actionBundles;

    public Rule(UrlConditions urlConditions, List<Condition> conditions, Queue<ActionBundle> actionBundles) {
        this.urlConditions = urlConditions;
        this.conditions = conditions;
        this.actionBundles = actionBundles;
    }

    public boolean matches(HttpRequest request) {
        return this.urlConditions.matches(request.uri()) && this.conditions.stream().allMatch(c -> c.matches(request));
    }

    public MockedServerResponse produceResponse() throws IOException {
        MockedServerResponse.Builder responseBuilder = new MockedServerResponse.Builder();
        ActionBundle actionBundle = this.actionBundles.size() > 1 ? this.actionBundles.poll() : this.actionBundles.peek();
        for (Action a : actionBundle) {
            a.enrichResponse(responseBuilder);
        }
        return responseBuilder.build();
    }

    public void debug(HttpRequest request, Debugger debugger) {
        for (Condition condition : this.conditions) {
            this.debugCondition(condition, request, debugger);
        }
        this.urlConditions.debug(request, debugger);
    }

    private void debugCondition(Condition condition, HttpRequest request, Debugger debugger) {
        debugger.message(condition.matches(request), condition.getDebugMessage());
    }
}

