/*
 * Decompiled with CFR 0.152.
 */
package com.pgssoft.httpclient.internal.rule;

import com.pgssoft.httpclient.Action;
import com.pgssoft.httpclient.Condition;
import com.pgssoft.httpclient.internal.UrlConditions;
import com.pgssoft.httpclient.internal.action.ActionBundle;
import com.pgssoft.httpclient.internal.condition.MethodCondition;
import com.pgssoft.httpclient.internal.rule.Rule;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class RuleBuilder {
    private final Deque<ActionBundle> actionBundles = new LinkedList<ActionBundle>();
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final UrlConditions urlConditions;

    public RuleBuilder(String method, String host, String url) {
        url = url.startsWith("/") ? host + url : url;
        this.addCondition(new MethodCondition(method));
        this.urlConditions = UrlConditions.parse(url);
    }

    public RuleBuilder(String method) {
        this.addCondition(new MethodCondition(method));
        this.urlConditions = new UrlConditions();
    }

    public void addAction(Action action) {
        ActionBundle bundle = this.actionBundles.peekLast();
        if (bundle == null) {
            bundle = new ActionBundle();
            this.actionBundles.add(bundle);
        }
        bundle.add(action);
    }

    public void addActionBundle(Action action) {
        ActionBundle bundle = new ActionBundle();
        bundle.add(action);
        this.actionBundles.add(bundle);
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public void setParameterCondition(String name, Matcher<String> matcher) {
        this.urlConditions.getParameterConditions().addParam(name, (Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder(List.of(matcher)));
    }

    public void setReferenceCondition(Matcher<String> matcher) {
        this.urlConditions.setReferenceCondition(matcher);
    }

    public void addHostCondition(String host) {
        this.urlConditions.setHostCondition((Matcher<String>)Matchers.equalTo((Object)host));
    }

    public void setPathCondition(Matcher<String> matcher) {
        this.urlConditions.setPathCondition(matcher);
    }

    public Rule build() {
        return new Rule(this.urlConditions, this.conditions, this.actionBundles);
    }
}

