/*
 * Decompiled with CFR 0.152.
 */
package com.github.phasebash.jsdoc3.maven;

import com.github.phasebash.jsdoc3.maven.tasks.JsDocTasks;
import com.github.phasebash.jsdoc3.maven.tasks.TaskContext;
import com.github.phasebash.jsdoc3.maven.tasks.TaskException;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="jsdoc3", defaultPhase=LifecyclePhase.SITE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class JsDocMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/jsdoc3", readonly=true)
    private File workingDirectory;
    @Parameter(required=false)
    private File[] directoryRoots;
    @Parameter(required=false)
    private File[] sourceFiles;
    @Parameter(required=false)
    private boolean recursive = true;
    @Parameter(required=true, defaultValue="${project.build.directory}/site/jsdoc")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="false")
    private boolean debug;
    @Parameter(required=true, defaultValue="false")
    private boolean includePrivate;
    @Parameter(required=false)
    private File tutorialsDirectory;
    @Parameter(required=false)
    private File configFile;
    @Parameter(required=false)
    private File templateDirectory;
    @Parameter(required=false)
    private boolean lenient = false;
    @Parameter(property="maven.jsdoc.skip", defaultValue="false")
    protected boolean skip;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping jsdoc generation");
            return;
        }
        this.workingDirectory.mkdirs();
        this.outputDirectory.mkdirs();
        File jsDoc3Dir = new File(this.workingDirectory, "jsdoc");
        TaskContext.Builder builder = new TaskContext.Builder();
        builder.withLog(log);
        builder.withDebug(this.debug);
        builder.withRecursive(this.recursive);
        builder.withLeniency(this.lenient);
        builder.withIncludePrivate(this.includePrivate);
        builder.withSourceFiles(this.sourceFiles);
        builder.withDirectoryRoots(this.directoryRoots);
        builder.withOutputDirectory(this.outputDirectory);
        builder.withTempDirectory(this.workingDirectory);
        builder.withJsDocDirectory(jsDoc3Dir);
        builder.withTutorialsDirectory(this.tutorialsDirectory);
        builder.withTemplateDirectory(this.templateDirectory);
        builder.withConfigFile(this.configFile);
        try {
            TaskContext taskContext = builder.build();
            log.info((CharSequence)"Generating...");
            new JsDocTasks(taskContext).run();
            log.info((CharSequence)("jsdoc3 generation complete, please see " + this.outputDirectory + "."));
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Invalid Mojo properties given in the plugin configuration.", (Exception)e);
        }
        catch (TaskException e) {
            throw new MojoExecutionException("Unable to run all JsDoc3 Tasks.", (Exception)e);
        }
    }
}

