/*
 * Decompiled with CFR 0.152.
 */
package com.github.phasebash.jsdoc3.maven.tasks;

import com.github.phasebash.jsdoc3.maven.tasks.TaskContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JsDocArgumentBuilder {
    private static final List<String> MODULES = Collections.unmodifiableList(Arrays.asList("node_modules", "rhino", "lib", ""));

    public List<String> build(TaskContext context) {
        ArrayList<String> arguments = new ArrayList<String>();
        File basePath = context.getJsDocDir();
        arguments.add("java");
        arguments.add("-classpath");
        arguments.add(this.replace(new File(basePath, "rhino" + File.separator + "js.jar").toString()));
        arguments.add("org.mozilla.javascript.tools.shell.Main");
        for (String module : MODULES) {
            arguments.add("-modules");
            arguments.add(this.asUriString(new File(basePath, module)));
        }
        arguments.add(this.replace(new File(basePath, "jsdoc.js").toString()));
        arguments.add("--dirname=" + this.replace(basePath.toString()));
        if (context.isRecursive()) {
            arguments.add("-r");
        }
        if (context.isLenient()) {
            arguments.add("-l");
        }
        if (context.getConfigFile() != null) {
            arguments.add("-c");
            arguments.add(context.getConfigFile().toString());
        }
        if (context.isIncludePrivate()) {
            arguments.add("-p");
        }
        if (context.getTutorialsDirectory() != null) {
            arguments.add("-u");
            arguments.add(context.getTutorialsDirectory().toString());
        }
        if (context.getTemplateDirectory() != null) {
            arguments.add("-t");
            arguments.add(context.getTemplateDirectory().toString());
        }
        arguments.add("-d");
        arguments.add(context.getOutputDir().toString());
        for (File sourceFile : context.getSourceDir()) {
            arguments.add(sourceFile.toString());
        }
        return arguments;
    }

    private String asNormalizedFileString(File file) {
        return this.replace(file.getAbsolutePath());
    }

    private String asUriString(File file) {
        return (File.separator.equals("/") ? "file://" : "file:/") + this.asNormalizedFileString(file).replace(" ", "%20");
    }

    private String replace(String string) {
        return string.replace("\\", "/");
    }
}

