/*
 * Decompiled with CFR 0.152.
 */
package com.github.phasebash.jsdoc3.maven.tasks;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;

public final class TaskContext {
    private final Collection<File> sourceDir;
    private final File outputDir;
    private final File jsDocDir;
    private final File tutorialsDirectory;
    private final File tempDir;
    private final File configFile;
    private final boolean debug;
    private final boolean recursive;
    private final boolean lenient;
    private final boolean includePrivate;
    private final Log log;
    private final File templateDirectory;

    TaskContext(Collection<File> sourceDir, File outputDir, File jsDocDir, File tutorialsDirectory, File templateDirectory, File configFile, File tempDir, boolean debug, boolean recursive, boolean includePrivate, boolean lenient, Log log) {
        this.sourceDir = sourceDir;
        this.jsDocDir = jsDocDir;
        this.outputDir = outputDir;
        this.tutorialsDirectory = tutorialsDirectory;
        this.templateDirectory = templateDirectory;
        this.configFile = configFile;
        this.tempDir = tempDir;
        this.debug = debug;
        this.recursive = recursive;
        this.includePrivate = includePrivate;
        this.lenient = lenient;
        this.log = log;
    }

    public File getJsDocDir() {
        return this.jsDocDir;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public File getTutorialsDirectory() {
        return this.tutorialsDirectory;
    }

    public File getTemplateDirectory() {
        return this.templateDirectory;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public Collection<File> getSourceDir() {
        return this.sourceDir;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isIncludePrivate() {
        return this.includePrivate;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public Log getLog() {
        return this.log;
    }

    public static class Builder {
        private Set<File> sourceFiles = new LinkedHashSet<File>();
        private Set<File> directoryRoots = new LinkedHashSet<File>();
        private File outputDirectory;
        private File jsDocDirectory;
        private File configFile;
        private File tempDirectory;
        private boolean debug = false;
        private boolean recursive = false;
        private boolean includePrivate = false;
        private boolean lenient;
        private File tutorialsDirectory;
        private File templateDirectory;
        private Log log;

        public Builder() {
        }

        public Builder(Builder other) {
            this.sourceFiles.addAll(other.sourceFiles);
            this.directoryRoots.addAll(other.directoryRoots);
            this.outputDirectory = other.outputDirectory;
            this.jsDocDirectory = other.jsDocDirectory;
            this.tempDirectory = other.tempDirectory;
            this.debug = other.debug;
            this.recursive = other.recursive;
            this.includePrivate = other.includePrivate;
            this.tutorialsDirectory = other.tutorialsDirectory;
            this.log = other.log;
        }

        public Builder withSourceFiles(File[] sourceFiles) {
            if (sourceFiles != null) {
                this.sourceFiles.addAll(Arrays.asList(sourceFiles));
            }
            return this;
        }

        public Builder withOutputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public Builder withJsDocDirectory(File jsDocDirectory) {
            this.jsDocDirectory = jsDocDirectory;
            return this;
        }

        public Builder withConfigFile(File configFile) {
            this.configFile = configFile;
            return this;
        }

        public Builder withTempDirectory(File tempDirectory) {
            this.tempDirectory = tempDirectory;
            return this;
        }

        public Builder withRecursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder withDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder withIncludePrivate(boolean includePrivate) {
            this.includePrivate = includePrivate;
            return this;
        }

        public Builder withLeniency(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public Builder withDirectoryRoots(File[] directoryRoots) {
            if (directoryRoots != null) {
                this.directoryRoots.addAll(Arrays.asList(directoryRoots));
            }
            return this;
        }

        public Builder withTutorialsDirectory(File tutorialsDirectory) {
            if (tutorialsDirectory != null && tutorialsDirectory.exists() && tutorialsDirectory.isDirectory()) {
                this.tutorialsDirectory = tutorialsDirectory;
            }
            return this;
        }

        public Builder withLog(Log log) {
            this.log = log;
            return this;
        }

        public Builder withTemplateDirectory(File templateDirectory) {
            this.templateDirectory = templateDirectory;
            return this;
        }

        public TaskContext build() {
            if (this.sourceFiles.size() == 0 && this.directoryRoots.size() == 0) {
                throw new IllegalArgumentException("sourceFiles and/or directoryRoots are required.");
            }
            LinkedHashSet<File> sourceRoots = new LinkedHashSet<File>();
            sourceRoots.addAll(this.sourceFiles);
            sourceRoots.addAll(this.directoryRoots);
            if (this.outputDirectory == null || !this.outputDirectory.exists()) {
                throw new IllegalStateException("Output directory must exist.");
            }
            if (this.jsDocDirectory == null) {
                throw new IllegalStateException("jsdoc directory must not be null.");
            }
            if (this.tempDirectory == null) {
                throw new IllegalStateException("Temp directory must not be null.");
            }
            return new TaskContext(sourceRoots, this.outputDirectory, this.jsDocDirectory, this.tutorialsDirectory, this.templateDirectory, this.configFile, this.tempDirectory, this.debug, this.recursive, this.includePrivate, this.lenient, this.log);
        }
    }
}

