/*
 * Decompiled with CFR 0.152.
 */
package com.github.phasebash.jsdoc3.maven;

import com.github.phasebash.jsdoc3.maven.tasks.JsDocTasks;
import com.github.phasebash.jsdoc3.maven.tasks.TaskContext;
import com.github.phasebash.jsdoc3.maven.tasks.TaskException;
import java.io.File;
import java.util.Locale;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="report", defaultPhase=LifecyclePhase.SITE)
public class JsDocMavenReport
extends AbstractMavenReport {
    private Renderer siteRenderer;
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/jsdoc3", readonly=true)
    private File workingDirectory;
    @Parameter(required=false)
    private File[] directoryRoots;
    @Parameter(required=false)
    private File[] sourceFiles;
    @Parameter(required=true, defaultValue="${project.build.directory}/site/jsdoc")
    private File outputDirectory;
    @Parameter(required=false)
    private File tutorialsDirectory;
    @Parameter(required=false)
    private File configFile;
    @Parameter(required=false)
    private File templateDirectory;
    @Parameter(required=false)
    private boolean recursive = true;
    @Parameter(required=false)
    private boolean lenient = false;
    @Parameter(required=true, defaultValue="false")
    private boolean debug;
    @Parameter(required=true, defaultValue="false")
    private boolean includePrivate;
    @Parameter(property="maven.jsdoc.skip", defaultValue="false")
    protected boolean skip;

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return "jsdoc/index";
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping jsdoc generation");
            return;
        }
        this.workingDirectory.mkdirs();
        this.outputDirectory.mkdirs();
        File jsDoc3Dir = new File(this.workingDirectory, "jsdoc");
        TaskContext.Builder builder = new TaskContext.Builder();
        builder.withLog(log);
        builder.withDebug(this.debug);
        builder.withRecursive(this.recursive);
        builder.withLeniency(this.lenient);
        builder.withIncludePrivate(this.includePrivate);
        builder.withSourceFiles(this.sourceFiles);
        builder.withDirectoryRoots(this.directoryRoots);
        builder.withOutputDirectory(this.outputDirectory);
        builder.withTempDirectory(this.workingDirectory);
        builder.withJsDocDirectory(jsDoc3Dir);
        builder.withTutorialsDirectory(this.tutorialsDirectory);
        builder.withTemplateDirectory(this.templateDirectory);
        builder.withConfigFile(this.configFile);
        try {
            TaskContext taskContext = builder.build();
            log.info((CharSequence)"Generating...");
            new JsDocTasks(taskContext).run();
            log.info((CharSequence)("jsdoc3 generation complete, please see " + this.outputDirectory + "."));
        }
        catch (IllegalArgumentException e) {
            throw new MavenReportException("Invalid Mojo properties given in the plugin configuration.", (Exception)e);
        }
        catch (TaskException e) {
            throw new MavenReportException("Unable to run all JsDoc3 Tasks.", (Exception)e);
        }
    }

    public String getOutputName() {
        return "jsdoc/index";
    }

    public String getName(Locale locale) {
        return "JsDocs";
    }

    public String getDescription(Locale locale) {
        return "JsDoc API Documentation.";
    }

    public boolean isExternalReport() {
        return true;
    }
}

