/*
 * Decompiled with CFR 0.152.
 */
package com.github.phasebash.jsdoc3.maven.tasks;

import com.github.phasebash.jsdoc3.maven.tasks.Task;
import com.github.phasebash.jsdoc3.maven.tasks.TaskContext;
import com.github.phasebash.jsdoc3.maven.tasks.TaskException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.codehaus.plexus.util.IOUtil;

final class CopyTask
implements Task {
    private static final String JSDOC_ARCHIVE_PATH = "com/github/jsdoc3/jsdoc.zip";

    CopyTask() {
    }

    @Override
    public void execute(TaskContext context) throws TaskException {
        try {
            URL resource = this.findJsDocArchive();
            this.copyTo(resource, context.getTempDir(), "jsdoc.zip");
        }
        catch (IOException e) {
            throw new TaskException("Unable to copy jsdoc zip to temp dir.", e);
        }
    }

    private URL findJsDocArchive() throws IOException {
        URL resource = this.getClass().getClassLoader().getResource(JSDOC_ARCHIVE_PATH);
        if (resource == null) {
            throw new IOException("com/github/jsdoc3/jsdoc.zip not found.");
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTo(URL source, File destinationDir, String fileName) throws IOException {
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        File file = new File(destinationDir, fileName);
        FileOutputStream fos = null;
        try {
            file.createNewFile();
            fos = new FileOutputStream(file);
            IOUtil.copy((InputStream)source.openStream(), (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

