/*
 * Decompiled with CFR 0.152.
 */
package com.github.phasebash.jsdoc3.maven.tasks;

import com.github.phasebash.jsdoc3.maven.tasks.TaskException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

class StreamLogger
implements Runnable {
    private final BufferedReader bufferedReader;
    private final InputStreamReader inputStreamReader;
    private final Log log;

    public StreamLogger(InputStream in, Log log) {
        this.inputStreamReader = new InputStreamReader(in);
        this.bufferedReader = new BufferedReader(this.inputStreamReader);
        this.log = log;
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.bufferedReader.readLine()) != null) {
                this.log.info((CharSequence)line);
            }
        }
        catch (IOException e) {
            throw new TaskException("Exception while intercepting stream.", e);
        }
        IOUtils.closeQuietly((Reader)this.bufferedReader);
        IOUtils.closeQuietly((Reader)this.inputStreamReader);
    }
}

