/*
 * Decompiled with CFR 0.152.
 */
package org.jsdoc;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jsdoc.SourceReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;
import org.mozilla.javascript.json.JsonParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsDocModuleProvider
extends UrlModuleSourceProvider {
    private static final long serialVersionUID = -5866044743536013761L;
    private static final String JS_EXTENSION = ".js";
    private static final String JSON_EXTENSION = ".json";
    private static final String PATH_SEPARATOR = "/";
    private static final String PACKAGE_FILE = "package.json";
    private static final String MODULE_INDEX = "index.js";
    private static final String SUBMODULE_DIRECTORY = "node_modules";

    public JsDocModuleProvider(Iterable<URI> privilegedUris, Iterable<URI> fallbackUris) {
        super(privilegedUris, fallbackUris);
    }

    @Override
    protected ModuleSource loadFromPathList(String moduleId, Object validator, Iterable<URI> paths) throws IOException, URISyntaxException {
        if (paths == null) {
            return null;
        }
        for (URI path : paths) {
            ModuleSource moduleSource;
            URI moduleUri;
            try {
                moduleUri = path.resolve(moduleId);
            }
            catch (IllegalArgumentException e) {
                File modulePathJs;
                File modulePath = new File(moduleId);
                File file = modulePathJs = moduleId.endsWith(JS_EXTENSION) ? modulePath : new File(moduleId + JS_EXTENSION);
                if (modulePath.isDirectory() && modulePathJs.isFile()) {
                    modulePath = modulePathJs;
                }
                moduleUri = modulePath.isAbsolute() ? modulePath.toURI() : new File(new File(path).getAbsolutePath(), moduleId).toURI();
            }
            if ((moduleSource = this.loadFromUri(moduleUri, path, validator)) == null) continue;
            return moduleSource;
        }
        return null;
    }

    @Override
    protected ModuleSource loadFromUri(URI uri, URI base, Object validator) throws IOException, URISyntaxException {
        try {
            URI moduleUri = this.getModuleUri(uri, base);
            ModuleSource source = this.loadFromActualUri(moduleUri, base, validator);
            return source != null ? source : this.loadFromActualUri(uri, base, validator);
        }
        catch (Exception e) {
            return null;
        }
    }

    private URI getCurrentModuleUri() throws URISyntaxException {
        return new File(System.getProperty("user.dir")).toURI();
    }

    private URI getModuleUri(URI uri, URI base) throws SecurityException, IOException, JsonParser.ParseException, URISyntaxException {
        return this.getModuleUri(uri, base, true);
    }

    private URI getModuleUri(URI uri, URI base, boolean checkForSubmodules) throws SecurityException, IOException, JsonParser.ParseException, URISyntaxException {
        URI moduleUri = null;
        String uriString = uri.toString();
        URI jsUri = this.ensureJsExtension(uri);
        URI packageUri = new URI(uriString + PATH_SEPARATOR + PACKAGE_FILE);
        URI indexUri = new URI(uriString + PATH_SEPARATOR + MODULE_INDEX);
        if (new File(jsUri).isFile()) {
            moduleUri = jsUri;
        }
        if (moduleUri == null && new File(packageUri).isFile()) {
            moduleUri = this.getPackageMain(packageUri);
        }
        if (moduleUri == null && new File(indexUri).isFile()) {
            moduleUri = indexUri;
        }
        if (moduleUri == null && checkForSubmodules) {
            moduleUri = this.getSubmoduleUri(uri, base);
        }
        return moduleUri;
    }

    private URI getSubmoduleUri(URI uri, URI base) throws SecurityException, IOException, JsonParser.ParseException, URISyntaxException {
        int parentIndex;
        int submoduleParentIndex;
        URI submoduleUri = null;
        String currentModule = this.getCurrentModuleUri().toString();
        URI childSubmoduleUri = new URI(currentModule + SUBMODULE_DIRECTORY);
        File childSubmoduleDir = new File(childSubmoduleUri);
        if (childSubmoduleDir.isDirectory()) {
            submoduleUri = this.getModuleUri(new URI(childSubmoduleUri.toString() + PATH_SEPARATOR + base.relativize(uri).toString()), childSubmoduleUri, false);
        }
        if (submoduleUri == null && (submoduleParentIndex = currentModule.lastIndexOf("node_modules/")) != -1 && (parentIndex = currentModule.indexOf(PATH_SEPARATOR, submoduleParentIndex + SUBMODULE_DIRECTORY.length() + 1)) != -1) {
            String parentModule = currentModule.substring(0, parentIndex);
            String submoduleDir = parentModule + PATH_SEPARATOR + SUBMODULE_DIRECTORY;
            URI submoduleSearchUri = new URI(submoduleDir + PATH_SEPARATOR + base.relativize(uri).toString());
            submoduleUri = this.getModuleUri(submoduleSearchUri, base, false);
        }
        return submoduleUri;
    }

    private URI getPackageMain(URI packageUri) throws IOException, JsonParser.ParseException {
        return this.getPackageMain(new File(packageUri));
    }

    private URI getPackageMain(File packageFile) throws IOException, JsonParser.ParseException {
        NativeObject packageJson = this.parsePackageFile(packageFile);
        String mainFile = (String)packageJson.get("main");
        if (mainFile != null) {
            mainFile = this.ensureJsExtension(mainFile);
            return packageFile.toURI().resolve(mainFile);
        }
        return null;
    }

    private URI ensureJsExtension(URI uri) throws URISyntaxException {
        String str = uri.toString();
        return new URI(this.ensureJsExtension(str));
    }

    private String ensureJsExtension(String str) {
        if (!str.endsWith(JS_EXTENSION) && !str.endsWith(JSON_EXTENSION)) {
            str = str + JS_EXTENSION;
        }
        return str;
    }

    private NativeObject parsePackageFile(File packageFile) throws IOException, JsonParser.ParseException {
        String packageJson = SourceReader.readFileOrUrl(packageFile.toString(), true, "UTF-8").toString();
        Context cx = Context.enter();
        JsonParser parser = new JsonParser(cx, cx.initStandardObjects());
        NativeObject json = (NativeObject)parser.parseValue(packageJson);
        return json;
    }
}

