/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.charset.CCharset;
import com.phloc.commons.codec.AbstractRFC1522Codec;
import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.EncoderException;
import com.phloc.commons.codec.QuotedPrintableCodec;
import java.nio.charset.Charset;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RFC1522QCodec
extends AbstractRFC1522Codec {
    public static final boolean DEFAULT_ENCODE_BLANKS = false;
    private static final BitSet PRINTABLE_CHARS;
    private static final byte BLANK = 32;
    private static final byte UNDERSCORE = 95;
    private final Charset m_aCharset;
    private boolean m_bEncodeBlanks = false;

    public RFC1522QCodec() {
        this(CCharset.CHARSET_UTF_8_OBJ);
    }

    public RFC1522QCodec(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    @Override
    protected String getRFC1522Encoding() {
        return "Q";
    }

    @Override
    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    public boolean isEncodeBlanks() {
        return this.m_bEncodeBlanks;
    }

    public void setEncodeBlanks(boolean bl) {
        this.m_bEncodeBlanks = bl;
    }

    @Override
    @Nullable
    public byte[] encode(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, byArray);
        if (this.m_bEncodeBlanks) {
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] != 32) continue;
                byArray2[i] = 95;
            }
        }
        return byArray2;
    }

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] byArray) throws DecoderException {
        if (byArray == null) {
            return null;
        }
        boolean bl = false;
        for (byte by : byArray) {
            if (by != 95) continue;
            bl = true;
            break;
        }
        if (bl) {
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i];
                byArray2[i] = n != 95 ? n : 32;
            }
            return QuotedPrintableCodec.decodeQuotedPrintable(byArray2);
        }
        return QuotedPrintableCodec.decodeQuotedPrintable(byArray);
    }

    @Override
    @Nullable
    public String encodeText(@Nullable String string) throws EncoderException {
        return super.encodeText(string, this.getCharset());
    }

    @Override
    @Nullable
    public String decodeText(@Nullable String string) throws DecoderException {
        return super.decodeText(string);
    }

    static {
        int n;
        PRINTABLE_CHARS = new BitSet(256);
        PRINTABLE_CHARS.set(32);
        PRINTABLE_CHARS.set(33);
        PRINTABLE_CHARS.set(34);
        PRINTABLE_CHARS.set(35);
        PRINTABLE_CHARS.set(36);
        PRINTABLE_CHARS.set(37);
        PRINTABLE_CHARS.set(38);
        PRINTABLE_CHARS.set(39);
        PRINTABLE_CHARS.set(40);
        PRINTABLE_CHARS.set(41);
        PRINTABLE_CHARS.set(42);
        PRINTABLE_CHARS.set(43);
        PRINTABLE_CHARS.set(44);
        PRINTABLE_CHARS.set(45);
        PRINTABLE_CHARS.set(46);
        PRINTABLE_CHARS.set(47);
        for (n = 48; n <= 57; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(58);
        PRINTABLE_CHARS.set(59);
        PRINTABLE_CHARS.set(60);
        PRINTABLE_CHARS.set(62);
        PRINTABLE_CHARS.set(64);
        for (n = 65; n <= 90; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(91);
        PRINTABLE_CHARS.set(92);
        PRINTABLE_CHARS.set(93);
        PRINTABLE_CHARS.set(94);
        PRINTABLE_CHARS.set(96);
        for (n = 97; n <= 122; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(123);
        PRINTABLE_CHARS.set(124);
        PRINTABLE_CHARS.set(125);
        PRINTABLE_CHARS.set(126);
    }
}

