/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IterableIteratorFromEnumeration<ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final Enumeration<? extends ELEMENTTYPE> m_aEnum;

    public IterableIteratorFromEnumeration(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        this.m_aEnum = enumeration;
    }

    @Override
    public boolean hasNext() {
        return this.m_aEnum != null && this.m_aEnum.hasMoreElements();
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aEnum.nextElement();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this;
    }

    public String toString() {
        return new ToStringGenerator(this).append("enum", this.m_aEnum).toString();
    }
}

