/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.system;

import com.phloc.commons.SystemProperties;
import com.phloc.commons.string.StringParser;
import javax.annotation.Nonnull;

public enum EProcessorArchitecture {
    UNKNOWN(-1),
    ARCH_32(32),
    ARCH_64(64);

    private static final String SUN_SYSTEM_PROPERTY = "sun.arch.data.model";
    private static volatile EProcessorArchitecture s_aInstance;
    private final int m_nBits;

    private EProcessorArchitecture(int n2) {
        if (n2 > 0 && n2 % 8 != 0) {
            throw new IllegalArgumentException("Passed bit count is illegal: " + n2);
        }
        this.m_nBits = n2;
    }

    public int getBits() {
        return this.m_nBits;
    }

    public int getBytes() {
        return this.m_nBits == -1 ? this.m_nBits : this.m_nBits / 8;
    }

    public static int getCurrentArchitectureBits() {
        return StringParser.parseInt(SystemProperties.getPropertyValue(SUN_SYSTEM_PROPERTY), -1);
    }

    @Nonnull
    public static EProcessorArchitecture forBits(int n) {
        for (EProcessorArchitecture eProcessorArchitecture : EProcessorArchitecture.values()) {
            if (n != eProcessorArchitecture.getBits()) continue;
            return eProcessorArchitecture;
        }
        return UNKNOWN;
    }

    @Nonnull
    static EProcessorArchitecture getCurrentArchitecture() {
        EProcessorArchitecture eProcessorArchitecture = s_aInstance;
        if (eProcessorArchitecture == null) {
            s_aInstance = eProcessorArchitecture = EProcessorArchitecture.forBits(EProcessorArchitecture.getCurrentArchitectureBits());
        }
        return eProcessorArchitecture;
    }

    static {
        s_aInstance = null;
    }
}

