/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.sax;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.io.streams.ByteBufferInputStream;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.url.URLUtils;
import com.phloc.commons.xml.sax.ReadableResourceSAXInputSource;
import com.phloc.commons.xml.sax.StringSAXInputSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.xml.sax.InputSource;

@Immutable
public final class InputSourceFactory {
    private static final InputSourceFactory s_aInstance = new InputSourceFactory();

    private InputSourceFactory() {
    }

    @Nullable
    public static InputSource create(@Nonnull File file) {
        return InputSourceFactory.create(new FileSystemResource(file));
    }

    @Nonnull
    public static InputSource create(@Nonnull URI uRI) {
        return InputSourceFactory.create(URLUtils.getAsURL(uRI));
    }

    @Nonnull
    public static InputSource create(@Nonnull URL uRL) {
        return InputSourceFactory.create(new URLResource(uRL));
    }

    @Nullable
    public static InputSource create(@Nonnull IInputStreamProvider iInputStreamProvider) {
        if (iInputStreamProvider instanceof IReadableResource) {
            return InputSourceFactory.create((IReadableResource)iInputStreamProvider);
        }
        return InputSourceFactory.create(iInputStreamProvider.getInputStream());
    }

    @Nullable
    public static InputSource create(@Nonnull IReadableResource iReadableResource) {
        File file;
        if (iReadableResource instanceof FileSystemResource && (file = iReadableResource.getAsFile()) != null) {
            return InputSourceFactory.create(FileUtils.getInputStream(file));
        }
        return new ReadableResourceSAXInputSource(iReadableResource);
    }

    @Nonnull
    public static InputSource create(@Nonnull CharSequence charSequence) {
        return new StringSAXInputSource(charSequence);
    }

    @Nonnull
    public static InputSource create(@Nonnull String string) {
        return new StringSAXInputSource(string);
    }

    @Nonnull
    public static InputSource create(@Nonnull char[] cArray) {
        return new StringSAXInputSource(cArray);
    }

    @Nonnull
    public static InputSource create(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return new StringSAXInputSource(cArray, n, n2);
    }

    @Nonnull
    public static InputSource create(@Nonnull byte[] byArray) {
        return InputSourceFactory.create(new NonBlockingByteArrayInputStream(byArray));
    }

    @Nonnull
    public static InputSource create(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return InputSourceFactory.create(new NonBlockingByteArrayInputStream(byArray, n, n2));
    }

    @Nonnull
    public static InputSource create(@Nonnull ByteBuffer byteBuffer) {
        return InputSourceFactory.create(new ByteBufferInputStream(byteBuffer));
    }

    @Nullable
    public static InputSource create(@Nullable InputStream inputStream) {
        return inputStream == null ? null : new InputSource(inputStream);
    }

    @Nullable
    public static InputSource create(@Nullable Reader reader) {
        return reader == null ? null : new InputSource(reader);
    }
}

