/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.priviledged.PrivilegedActionSystemGetProperty;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.annotation.Nonnull;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XMLReaderFactoryPhloc {
    private static final String property = "org.xml.sax.driver";
    private static SecuritySupport ss = new SecuritySupport();
    private static boolean _jarread = false;
    private static String _jarreadClassname;

    private XMLReaderFactoryPhloc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static XMLReader createXMLReader() throws SAXException {
        ClassLoader classLoader;
        String string;
        block17: {
            string = null;
            classLoader = ss.getContextClassLoader();
            try {
                string = ss.getSystemProperty(property);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (string == null) {
                if (!_jarread) {
                    _jarread = true;
                    try {
                        InputStream inputStream;
                        if (classLoader != null) {
                            inputStream = ss.getResourceAsStream(classLoader, "META-INF/services/org.xml.sax.driver");
                            if (inputStream == null) {
                                classLoader = null;
                                inputStream = ss.getResourceAsStream(classLoader, "META-INF/services/org.xml.sax.driver");
                            }
                        } else {
                            inputStream = ss.getResourceAsStream(null, "META-INF/services/org.xml.sax.driver");
                        }
                        if (inputStream == null) break block17;
                        try {
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
                            try {
                                string = bufferedReader.readLine();
                            }
                            finally {
                                StreamUtils.close(bufferedReader);
                            }
                            _jarreadClassname = string;
                        }
                        finally {
                            StreamUtils.close(inputStream);
                        }
                    }
                    catch (Throwable throwable) {}
                } else {
                    string = _jarreadClassname;
                }
            }
        }
        if (string == null) {
            string = "com.sun.org.apache.xerces.internal.parsers.SAXParser";
        }
        return XMLReaderFactoryPhloc._loadClass(classLoader, string);
    }

    @Nonnull
    public static XMLReader createXMLReader(String string) throws SAXException {
        return XMLReaderFactoryPhloc._loadClass(ss.getContextClassLoader(), string);
    }

    @Nonnull
    private static XMLReader _loadClass(ClassLoader classLoader, String string) throws SAXException {
        try {
            return (XMLReader)NewInstance.newInstance(classLoader, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException("SAX2 driver class " + string + " not found", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException("SAX2 driver class " + string + " found but cannot be loaded", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException("SAX2 driver class " + string + " loaded but cannot be instantiated (no empty public constructor?)", instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException("SAX2 driver class " + string + " does not implement XMLReader", classCastException);
        }
    }

    private static final class NewInstance {
        private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xerces.internal";

        private NewInstance() {
        }

        static Object newInstance(ClassLoader classLoader, String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            boolean bl = false;
            if (System.getSecurityManager() != null && string != null && string.startsWith(DEFAULT_PACKAGE)) {
                bl = true;
            }
            Class<?> clazz = classLoader == null || bl ? Class.forName(string) : classLoader.loadClass(string);
            return clazz.newInstance();
        }
    }

    private static final class SecuritySupport {
        private SecuritySupport() {
        }

        ClassLoader getContextClassLoader() throws SecurityException {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    return classLoader;
                }
            });
        }

        String getSystemProperty(String string) {
            return AccessController.doPrivileged(new PrivilegedActionSystemGetProperty(string));
        }

        InputStream getResourceAsStream(final ClassLoader classLoader, final String string) {
            return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    InputStream inputStream = classLoader == null ? Object.class.getResourceAsStream(string) : classLoader.getResourceAsStream(string);
                    return inputStream;
                }
            });
        }
    }
}

