/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.base64;

import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Base64 {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int GZIP = 2;
    public static final int DONT_GUNZIP = 4;
    public static final int DO_BREAK_LINES = 8;
    public static final int URL_SAFE = 16;
    public static final int ORDERED = 32;
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final Charset PREFERRED_ENCODING = CCharset.CHARSET_US_ASCII_OBJ;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] _STANDARD_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] _STANDARD_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final byte[] _URL_SAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] _URL_SAFE_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final byte[] _ORDERED_ALPHABET = new byte[]{45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte[] _ORDERED_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, -9, -9, -9, -1, -9, -9, -9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, -9, -9, -9, -9, 37, -9, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final Base64 s_aInstance = new Base64();

    @Nonnull
    private static byte[] _getAlphabet(int n) {
        if ((n & 0x10) == 16) {
            return _URL_SAFE_ALPHABET;
        }
        if ((n & 0x20) == 32) {
            return _ORDERED_ALPHABET;
        }
        return _STANDARD_ALPHABET;
    }

    @Nonnull
    private static byte[] _getDecodabet(int n) {
        if ((n & 0x10) == 16) {
            return _URL_SAFE_DECODABET;
        }
        if ((n & 0x20) == 32) {
            return _ORDERED_DECODABET;
        }
        return _STANDARD_DECODABET;
    }

    private Base64() {
    }

    private static byte[] _encode3to4(byte[] byArray, byte[] byArray2, int n, int n2) {
        Base64._encode3to4(byArray2, 0, n, byArray, 0, n2);
        return byArray;
    }

    @Nonnull
    private static byte[] _encode3to4(@Nonnull byte[] byArray, int n, int n2, @Nonnull byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = Base64._getAlphabet(n4);
        int n5 = (n2 > 0 ? byArray[n] << 24 >>> 8 : 0) | (n2 > 1 ? byArray[n + 1] << 24 >>> 16 : 0) | (n2 > 2 ? byArray[n + 2] << 24 >>> 24 : 0);
        switch (n2) {
            case 3: {
                byArray2[n3] = byArray3[n5 >>> 18];
                byArray2[n3 + 1] = byArray3[n5 >>> 12 & 0x3F];
                byArray2[n3 + 2] = byArray3[n5 >>> 6 & 0x3F];
                byArray2[n3 + 3] = byArray3[n5 & 0x3F];
                return byArray2;
            }
            case 2: {
                byArray2[n3] = byArray3[n5 >>> 18];
                byArray2[n3 + 1] = byArray3[n5 >>> 12 & 0x3F];
                byArray2[n3 + 2] = byArray3[n5 >>> 6 & 0x3F];
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
            case 1: {
                byArray2[n3] = byArray3[n5 >>> 18];
                byArray2[n3 + 1] = byArray3[n5 >>> 12 & 0x3F];
                byArray2[n3 + 2] = 61;
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
        }
        return byArray2;
    }

    public static void encode(@Nonnull ByteBuffer byteBuffer, @Nonnull ByteBuffer byteBuffer2) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[4];
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(3, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n);
            Base64._encode3to4(byArray2, byArray, n, 0);
            byteBuffer2.put(byArray2);
        }
    }

    public static void encode(@Nonnull ByteBuffer byteBuffer, @Nonnull CharBuffer charBuffer) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[4];
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(3, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n);
            Base64._encode3to4(byArray2, byArray, n, 0);
            for (int i = 0; i < 4; ++i) {
                charBuffer.put((char)(byArray2[i] & 0xFF));
            }
        }
    }

    public static String encodeObject(@Nonnull Serializable serializable) throws IOException {
        return Base64.encodeObject(serializable, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String encodeObject(@Nonnull Serializable serializable, int n) throws IOException {
        if (serializable == null) {
            throw new NullPointerException("Cannot serialize a null object.");
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = null;
        OutputStream outputStream = null;
        GZIPOutputStream gZIPOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
            outputStream = new OutputStream(nonBlockingByteArrayOutputStream, 1 | n);
            if ((n & 2) != 0) {
                gZIPOutputStream = new GZIPOutputStream(outputStream);
                objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            } else {
                objectOutputStream = new ObjectOutputStream(outputStream);
            }
            objectOutputStream.writeObject(serializable);
        }
        catch (Throwable throwable) {
            StreamUtils.close(objectOutputStream);
            StreamUtils.close(gZIPOutputStream);
            StreamUtils.close(outputStream);
            StreamUtils.close(nonBlockingByteArrayOutputStream);
            throw throwable;
        }
        StreamUtils.close(objectOutputStream);
        StreamUtils.close(gZIPOutputStream);
        StreamUtils.close(outputStream);
        StreamUtils.close(nonBlockingByteArrayOutputStream);
        return CharsetManager.getAsString(nonBlockingByteArrayOutputStream.toByteArray(), PREFERRED_ENCODING);
    }

    @Nonnull
    public static String encodeBytes(@Nonnull byte[] byArray) {
        String string;
        block3: {
            string = null;
            try {
                string = Base64.encodeBytes(byArray, 0, byArray.length, 0);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)iOException.getMessage());
            }
        }
        assert (string != null);
        return string;
    }

    @Nonnull
    public static String encodeBytes(@Nonnull byte[] byArray, int n) throws IOException {
        return Base64.encodeBytes(byArray, 0, byArray.length, n);
    }

    @Nonnull
    public static String encodeBytes(@Nonnull byte[] byArray, int n, int n2) {
        String string;
        block3: {
            string = null;
            try {
                string = Base64.encodeBytes(byArray, n, n2, 0);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)iOException.getMessage());
            }
        }
        assert (string != null);
        return string;
    }

    @Nonnull
    public static String encodeBytes(@Nonnull byte[] byArray, int n, int n2, int n3) throws IOException {
        byte[] byArray2 = Base64.encodeBytesToBytes(byArray, n, n2, n3);
        return CharsetManager.getAsString(byArray2, PREFERRED_ENCODING);
    }

    @Nonnull
    public static byte[] encodeBytesToBytes(@Nonnull byte[] byArray) {
        byte[] byArray2;
        try {
            byArray2 = Base64.encodeBytesToBytes(byArray, 0, byArray.length, 0);
        }
        catch (IOException iOException) {
            assert (false) : "IOExceptions only come from GZipping, which is turned off: " + iOException.getMessage();
            byArray2 = null;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static byte[] encodeBytesToBytes(@Nonnull byte[] byArray, int n, int n2, int n3) throws IOException {
        block11: {
            if (byArray == null) {
                throw new NullPointerException("Cannot serialize a null array.");
            }
            if (n < 0) {
                throw new IllegalArgumentException("Cannot have negative offset: " + n);
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot have length offset: " + n2);
            }
            if (n + n2 > byArray.length) {
                throw new IllegalArgumentException(String.format("Cannot have offset of %d and length of %d with array of length %d", n, n2, byArray.length));
            }
            if ((n3 & 2) == 0) break block11;
            NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = null;
            GZIPOutputStream gZIPOutputStream = null;
            OutputStream outputStream = null;
            try {
                nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
                outputStream = new OutputStream(nonBlockingByteArrayOutputStream, 1 | n3);
                gZIPOutputStream = new GZIPOutputStream(outputStream);
                gZIPOutputStream.write(byArray, n, n2);
                gZIPOutputStream.close();
            }
            catch (Throwable throwable) {
                StreamUtils.close(gZIPOutputStream);
                StreamUtils.close(outputStream);
                StreamUtils.close(nonBlockingByteArrayOutputStream);
                throw throwable;
            }
            StreamUtils.close(gZIPOutputStream);
            StreamUtils.close(outputStream);
            StreamUtils.close(nonBlockingByteArrayOutputStream);
            return nonBlockingByteArrayOutputStream.toByteArray();
        }
        boolean bl = (n3 & 8) != 0;
        int n4 = n2 / 3 * 4 + (n2 % 3 > 0 ? 4 : 0);
        if (bl) {
            n4 += n4 / 76;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 - 2;
        int n8 = 0;
        while (n5 < n7) {
            Base64._encode3to4(byArray, n5 + n, 3, byArray2, n6, n3);
            if (bl && (n8 += 4) >= 76) {
                byArray2[n6 + 4] = 10;
                ++n6;
                n8 = 0;
            }
            n5 += 3;
            n6 += 4;
        }
        if (n5 < n2) {
            Base64._encode3to4(byArray, n5 + n, n2 - n5, byArray2, n6, n3);
            n6 += 4;
        }
        if (n6 <= byArray2.length - 1) {
            byte[] byArray3 = new byte[n6];
            System.arraycopy(byArray2, 0, byArray3, 0, n6);
            return byArray3;
        }
        return byArray2;
    }

    @Nonnegative
    private static int _decode4to3(@Nonnull byte[] byArray, int n, @Nonnull byte[] byArray2, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("Source array was null.");
        }
        if (byArray2 == null) {
            throw new NullPointerException("Destination array was null.");
        }
        if (n < 0 || n + 3 >= byArray.length) {
            throw new IllegalArgumentException("Source array with length " + byArray.length + " cannot have offset of " + n + " and still process four bytes.");
        }
        if (n2 < 0 || n2 + 2 >= byArray2.length) {
            throw new IllegalArgumentException("Destination array with length " + byArray2.length + " cannot have offset of " + n2 + " and still store three bytes.");
        }
        byte[] byArray3 = Base64._getDecodabet(n3);
        if (byArray[n + 2] == 61) {
            int n4 = (byArray3[byArray[n]] & 0xFF) << 18 | (byArray3[byArray[n + 1]] & 0xFF) << 12;
            byArray2[n2] = (byte)(n4 >>> 16);
            return 1;
        }
        if (byArray[n + 3] == 61) {
            int n5 = (byArray3[byArray[n]] & 0xFF) << 18 | (byArray3[byArray[n + 1]] & 0xFF) << 12 | (byArray3[byArray[n + 2]] & 0xFF) << 6;
            byArray2[n2] = (byte)(n5 >>> 16);
            byArray2[n2 + 1] = (byte)(n5 >>> 8);
            return 2;
        }
        int n6 = (byArray3[byArray[n]] & 0xFF) << 18 | (byArray3[byArray[n + 1]] & 0xFF) << 12 | (byArray3[byArray[n + 2]] & 0xFF) << 6 | byArray3[byArray[n + 3]] & 0xFF;
        byArray2[n2] = (byte)(n6 >> 16);
        byArray2[n2 + 1] = (byte)(n6 >> 8);
        byArray2[n2 + 2] = (byte)n6;
        return 3;
    }

    @Nonnull
    public static byte[] decode(@Nonnull byte[] byArray) throws IOException {
        byte[] byArray2 = Base64.decode(byArray, 0, byArray.length, 0);
        return byArray2;
    }

    @Nonnull
    public static byte[] decode(@Nonnull byte[] byArray, int n, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("Cannot decode null source array.");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Source array with length " + byArray.length + " cannot have offset of " + n + " and process " + n2 + " bytes.");
        }
        if (n2 == 0) {
            return ArrayHelper.EMPTY_BYTE_ARRAY;
        }
        if (n2 < 4) {
            throw new IllegalArgumentException("Base64-encoded string must have at least four characters, but length specified was " + n2);
        }
        byte[] byArray2 = Base64._getDecodabet(n3);
        int n4 = n2 * 3 / 4;
        byte[] byArray3 = new byte[n4];
        int n5 = 0;
        byte[] byArray4 = new byte[4];
        int n6 = 0;
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray2[byArray[i] & 0xFF];
            if (by >= -5) {
                if (by < -1) continue;
                byArray4[n6++] = byArray[i];
                if (n6 <= 3) continue;
                n5 += Base64._decode4to3(byArray4, 0, byArray3, n5, n3);
                n6 = 0;
                if (byArray[i] != 61) continue;
                break;
            }
            throw new IOException("Bad Base64 input character decimal " + (byArray[i] & 0xFF) + " in array position " + i);
        }
        byte[] byArray5 = new byte[n5];
        System.arraycopy(byArray3, 0, byArray5, 0, n5);
        return byArray5;
    }

    @Nonnull
    public static byte[] decode(@Nonnull String string) throws IOException {
        return Base64.decode(string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nonnull
    public static byte[] decode(@Nonnull String string, int n) throws IOException {
        int n2;
        boolean bl;
        if (string == null) {
            throw new NullPointerException("Input string was null.");
        }
        byte[] byArray = CharsetManager.getAsBytes(string, PREFERRED_ENCODING);
        byArray = Base64.decode(byArray, 0, byArray.length, n);
        boolean bl2 = bl = (n & 4) != 0;
        if (byArray != null && byArray.length >= 4 && !bl && 35615 == (n2 = byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00)) {
            NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = null;
            GZIPInputStream gZIPInputStream = null;
            NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = null;
            byte[] byArray2 = new byte[2048];
            try {
                int n3;
                nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
                nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);
                gZIPInputStream = new GZIPInputStream(nonBlockingByteArrayInputStream);
                while ((n3 = gZIPInputStream.read(byArray2)) >= 0) {
                    nonBlockingByteArrayOutputStream.write(byArray2, 0, n3);
                }
                byArray = nonBlockingByteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                StreamUtils.close(nonBlockingByteArrayOutputStream);
                StreamUtils.close(gZIPInputStream);
                StreamUtils.close(nonBlockingByteArrayInputStream);
                catch (Throwable throwable) {
                    StreamUtils.close(nonBlockingByteArrayOutputStream);
                    StreamUtils.close(gZIPInputStream);
                    StreamUtils.close(nonBlockingByteArrayInputStream);
                    throw throwable;
                }
            }
            StreamUtils.close(nonBlockingByteArrayOutputStream);
            StreamUtils.close(gZIPInputStream);
            StreamUtils.close(nonBlockingByteArrayInputStream);
        }
        return byArray;
    }

    public static Object decodeToObject(@Nonnull String string) throws IOException, ClassNotFoundException {
        return Base64.decodeToObject(string, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decodeToObject(@Nonnull String string, int n, final ClassLoader classLoader) throws IOException, ClassNotFoundException {
        byte[] byArray = Base64.decode(string, n);
        NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);
            objectInputStream = classLoader == null ? new ObjectInputStream(nonBlockingByteArrayInputStream) : new ObjectInputStream(nonBlockingByteArrayInputStream){

                @Override
                public Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                    Class<?> clazz = Class.forName(objectStreamClass.getName(), false, classLoader);
                    if (clazz != null) {
                        return clazz;
                    }
                    return super.resolveClass(objectStreamClass);
                }
            };
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            StreamUtils.close(nonBlockingByteArrayInputStream);
            StreamUtils.close(objectInputStream);
            throw throwable;
        }
        StreamUtils.close(nonBlockingByteArrayInputStream);
        StreamUtils.close(objectInputStream);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeToFile(@Nonnull byte[] byArray, String string) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("Data to encode was null.");
        }
        OutputStream outputStream = null;
        try {
            outputStream = new OutputStream(FileUtils.getOutputStream(string), 1);
            outputStream.write(byArray);
        }
        catch (Throwable throwable) {
            StreamUtils.close(outputStream);
            throw throwable;
        }
        StreamUtils.close(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeToFile(@Nonnull String string, @Nonnull String string2) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new OutputStream(FileUtils.getOutputStream(string2), 0);
            outputStream.write(CharsetManager.getAsBytes(string, PREFERRED_ENCODING));
        }
        catch (Throwable throwable) {
            StreamUtils.close(outputStream);
            throw throwable;
        }
        StreamUtils.close(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static byte[] decodeFromFile(@Nonnull String string) throws IOException {
        byte[] byArray;
        InputStream inputStream = null;
        try {
            int n;
            File file = new File(string);
            int n2 = 0;
            if (file.length() > Integer.MAX_VALUE) {
                throw new IOException("File is too big for this convenience method (" + file.length() + " bytes).");
            }
            byte[] byArray2 = new byte[(int)file.length()];
            inputStream = new InputStream(StreamUtils.getBuffered(FileUtils.getInputStream(file)), 0);
            while ((n = inputStream.read(byArray2, n2, 4096)) >= 0) {
                n2 += n;
            }
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
        }
        catch (Throwable throwable) {
            StreamUtils.close(inputStream);
            throw throwable;
        }
        StreamUtils.close(inputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String encodeFromFile(@Nonnull String string) throws IOException {
        String string2 = null;
        InputStream inputStream = null;
        try {
            int n;
            File file = new File(string);
            byte[] byArray = new byte[Math.max((int)((double)file.length() * 1.4 + 1.0), 40)];
            int n2 = 0;
            inputStream = new InputStream(StreamUtils.getBuffered(FileUtils.getInputStream(file)), 1);
            while ((n = inputStream.read(byArray, n2, 4096)) >= 0) {
                n2 += n;
            }
            string2 = CharsetManager.getAsString(byArray, 0, n2, PREFERRED_ENCODING);
        }
        catch (Throwable throwable) {
            StreamUtils.close(inputStream);
            throw throwable;
        }
        StreamUtils.close(inputStream);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeFileToFile(@Nonnull String string, @Nonnull String string2) throws IOException {
        String string3 = Base64.encodeFromFile(string);
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(FileUtils.getOutputStream(string2));
            ((java.io.OutputStream)bufferedOutputStream).write(CharsetManager.getAsBytes(string3, PREFERRED_ENCODING));
        }
        catch (Throwable throwable) {
            StreamUtils.close(bufferedOutputStream);
            throw throwable;
        }
        StreamUtils.close(bufferedOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeFileToFile(@Nonnull String string, @Nonnull String string2) throws IOException {
        byte[] byArray = Base64.decodeFromFile(string);
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(FileUtils.getOutputStream(string2));
            ((java.io.OutputStream)bufferedOutputStream).write(byArray);
        }
        catch (Throwable throwable) {
            StreamUtils.close(bufferedOutputStream);
            throw throwable;
        }
        StreamUtils.close(bufferedOutputStream);
    }

    public static class OutputStream
    extends FilterOutputStream {
        private final boolean m_bEncode;
        private int m_nPosition;
        private byte[] m_aBuffer;
        private final int m_nBufferLength;
        private int m_nLineLength;
        private final boolean m_bBreakLines;
        private final byte[] m_aB4;
        private boolean m_bSuspendEncoding;
        private final int m_nOptions;
        private final byte[] m_aDecodabet;

        public OutputStream(java.io.OutputStream outputStream) {
            this(outputStream, 1);
        }

        public OutputStream(java.io.OutputStream outputStream, int n) {
            super(outputStream);
            this.m_bBreakLines = (n & 8) != 0;
            this.m_bEncode = (n & 1) != 0;
            this.m_nBufferLength = this.m_bEncode ? 3 : 4;
            this.m_aBuffer = new byte[this.m_nBufferLength];
            this.m_nPosition = 0;
            this.m_nLineLength = 0;
            this.m_bSuspendEncoding = false;
            this.m_aB4 = new byte[4];
            this.m_nOptions = n;
            this.m_aDecodabet = Base64._getDecodabet(n);
        }

        @Override
        public void write(int n) throws IOException {
            if (this.m_bSuspendEncoding) {
                this.out.write(n);
                return;
            }
            if (this.m_bEncode) {
                this.m_aBuffer[this.m_nPosition++] = (byte)n;
                if (this.m_nPosition >= this.m_nBufferLength) {
                    this.out.write(Base64._encode3to4(this.m_aB4, this.m_aBuffer, this.m_nBufferLength, this.m_nOptions));
                    this.m_nLineLength += 4;
                    if (this.m_bBreakLines && this.m_nLineLength >= 76) {
                        this.out.write(10);
                        this.m_nLineLength = 0;
                    }
                    this.m_nPosition = 0;
                }
            } else if (this.m_aDecodabet[n & 0x7F] > -5) {
                this.m_aBuffer[this.m_nPosition++] = (byte)n;
                if (this.m_nPosition >= this.m_nBufferLength) {
                    int n2 = Base64._decode4to3(this.m_aBuffer, 0, this.m_aB4, 0, this.m_nOptions);
                    this.out.write(this.m_aB4, 0, n2);
                    this.m_nPosition = 0;
                }
            } else if (this.m_aDecodabet[n & 0x7F] != -5) {
                throw new IOException("Invalid character in Base64 data.");
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.m_bSuspendEncoding) {
                this.out.write(byArray, n, n2);
                return;
            }
            for (int i = 0; i < n2; ++i) {
                this.write(byArray[n + i]);
            }
        }

        public void flushBase64() throws IOException {
            if (this.m_nPosition > 0) {
                if (this.m_bEncode) {
                    this.out.write(Base64._encode3to4(this.m_aB4, this.m_aBuffer, this.m_nPosition, this.m_nOptions));
                    this.m_nPosition = 0;
                } else {
                    throw new IOException("Base64 input not properly padded.");
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.flushBase64();
            if (this.out != null) {
                super.close();
            }
            this.m_aBuffer = null;
            this.out = null;
        }

        public void suspendEncoding() throws IOException {
            this.flushBase64();
            this.m_bSuspendEncoding = true;
        }

        public void resumeEncoding() {
            this.m_bSuspendEncoding = false;
        }
    }

    public static class InputStream
    extends FilterInputStream {
        private final boolean m_bEncode;
        private int m_nPosition;
        private final byte[] m_aBuffer;
        private final int m_nBufferLength;
        private int m_nNumSigBytes;
        private int m_nLineLength;
        private final boolean m_bBreakLines;
        private final int m_nOptions;
        private final byte[] m_aDecodabet;

        public InputStream(java.io.InputStream inputStream) {
            this(inputStream, 0);
        }

        public InputStream(java.io.InputStream inputStream, int n) {
            super(inputStream);
            this.m_nOptions = n;
            this.m_bBreakLines = (n & 8) > 0;
            this.m_bEncode = (n & 1) > 0;
            this.m_nBufferLength = this.m_bEncode ? 4 : 3;
            this.m_aBuffer = new byte[this.m_nBufferLength];
            this.m_nPosition = -1;
            this.m_nLineLength = 0;
            this.m_aDecodabet = Base64._getDecodabet(n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read() throws IOException {
            if (this.m_nPosition < 0) {
                byte[] byArray;
                if (this.m_bEncode) {
                    int n;
                    byArray = new byte[3];
                    int n2 = 0;
                    for (int i = 0; i < 3 && (n = this.in.read()) >= 0; ++i) {
                        byArray[i] = (byte)n;
                        ++n2;
                    }
                    if (n2 <= 0) return -1;
                    Base64._encode3to4(byArray, 0, n2, this.m_aBuffer, 0, this.m_nOptions);
                    this.m_nPosition = 0;
                    this.m_nNumSigBytes = 4;
                } else {
                    int n;
                    byArray = new byte[4];
                    for (n = 0; n < 4; ++n) {
                        int n3;
                        while ((n3 = this.in.read()) >= 0 && this.m_aDecodabet[n3 & 0x7F] <= -5) {
                        }
                        if (n3 < 0) break;
                        byArray[n] = (byte)n3;
                    }
                    if (n == 4) {
                        this.m_nNumSigBytes = Base64._decode4to3(byArray, 0, this.m_aBuffer, 0, this.m_nOptions);
                        this.m_nPosition = 0;
                    } else {
                        if (n != 0) throw new IOException("Improperly padded Base64 input.");
                        return -1;
                    }
                }
            }
            if (this.m_nPosition < 0) throw new IOException("Error in Base64 code reading stream.");
            if (this.m_nPosition >= this.m_nNumSigBytes) {
                return -1;
            }
            if (this.m_bEncode && this.m_bBreakLines && this.m_nLineLength >= 76) {
                this.m_nLineLength = 0;
                return 10;
            }
            ++this.m_nLineLength;
            byte by = this.m_aBuffer[this.m_nPosition++];
            if (this.m_nPosition < this.m_nBufferLength) return by & 0xFF;
            this.m_nPosition = -1;
            return by & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.read();
                if (n4 < 0) {
                    if (n3 != 0) break;
                    return -1;
                }
                byArray[n + n3] = (byte)n4;
            }
            return n3;
        }
    }
}

