/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingBitOutputStream
implements Closeable,
Flushable {
    private static final Logger s_aLogger = LoggerFactory.getLogger(NonBlockingBitOutputStream.class);
    private OutputStream m_aOS;
    private final boolean m_bHighOrderBitFirst;
    private int m_nBuffer;
    private int m_nBufferedBitCount;

    public NonBlockingBitOutputStream(@Nonnull OutputStream outputStream, @Nonnull ByteOrder byteOrder) {
        ValueEnforcer.notNull(outputStream, "OutputStream");
        ValueEnforcer.notNull(byteOrder, "ByteOrder");
        this.m_aOS = outputStream;
        this.m_bHighOrderBitFirst = byteOrder.equals(ByteOrder.LITTLE_ENDIAN);
        this.m_nBufferedBitCount = 0;
    }

    @Nonnull
    public ByteOrder getByteOrder() {
        return this.m_bHighOrderBitFirst ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public void writeBit(int n) throws IOException {
        if (this.m_aOS == null) {
            throw new IllegalStateException("Already closed");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(n + " is not a bit");
        }
        if (n == 1) {
            this.m_nBuffer = this.m_bHighOrderBitFirst ? (this.m_nBuffer |= n << 7 - this.m_nBufferedBitCount) : (this.m_nBuffer |= n << this.m_nBufferedBitCount);
        }
        if (++this.m_nBufferedBitCount == 8) {
            this.flush();
        }
    }

    public void writeBits(int n, @Nonnegative int n2) throws IOException {
        ValueEnforcer.isBetweenInclusive(n2, "NumberOfBits", 1, 32);
        for (int i = n2 - 1; i >= 0; --i) {
            this.writeBit(n >> i & 1);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.m_nBufferedBitCount > 0) {
            if (this.m_nBufferedBitCount != 8 && s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Flushing BitOutputStream with only " + this.m_nBufferedBitCount + " bits");
            }
            this.m_aOS.write((byte)this.m_nBuffer);
            this.m_nBufferedBitCount = 0;
            this.m_nBuffer = 0;
        }
    }

    @Override
    public void close() {
        StreamUtils.flush(this);
        StreamUtils.close(this.m_aOS);
        this.m_aOS = null;
    }

    public String toString() {
        return new ToStringGenerator(this).append("OS", this.m_aOS).append("highOrderBitFirst", this.m_bHighOrderBitFirst).append("buffer", this.m_nBuffer).append("bitCount", this.m_nBufferedBitCount).toString();
    }
}

