/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.CGlobal;
import com.phloc.commons.ICloneable;
import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.system.ENewLineMode;
import com.phloc.commons.xml.EXMLIncorrectCharacterHandling;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.serialize.EXMLSerializeComments;
import com.phloc.commons.xml.serialize.EXMLSerializeDocType;
import com.phloc.commons.xml.serialize.EXMLSerializeFormat;
import com.phloc.commons.xml.serialize.EXMLSerializeIndent;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;

@NotThreadSafe
public class XMLWriterSettings
implements IXMLWriterSettings,
ICloneable<XMLWriterSettings> {
    public static final String DEFAULT_XML_CHARSET = "UTF-8";
    public static final Charset DEFAULT_XML_CHARSET_OBJ = CCharset.CHARSET_UTF_8_OBJ;
    public static final boolean DEFAULT_USE_DOUBLE_QUOTES_FOR_ATTRIBUTES = true;
    public static final boolean DEFAULT_SPACE_ON_SELF_CLOSED_ELEMENT = true;
    public static final String DEFAULT_NEWLINE_STRING = CGlobal.LINE_SEPARATOR;
    public static final String DEFAULT_INDENTATION_STRING = "  ";
    public static final boolean DEFAULT_EMIT_NAMESPACES = true;
    public static final boolean DEFAULT_PUT_NAMESPACE_CONTEXT_PREFIXES_IN_ROOT = false;
    public static final IXMLWriterSettings DEFAULT_XML_SETTINGS = new XMLWriterSettings();
    private EXMLSerializeFormat m_eFormat = EXMLSerializeFormat.XML;
    private EXMLVersion m_eXMLVersion = EXMLVersion.XML_10;
    private EXMLSerializeDocType m_eSerializeDocType = EXMLSerializeDocType.EMIT;
    private EXMLSerializeComments m_eSerializeComments = EXMLSerializeComments.EMIT;
    private EXMLSerializeIndent m_eIndent = EXMLSerializeIndent.INDENT_AND_ALIGN;
    private EXMLIncorrectCharacterHandling m_eIncorrectCharacterHandling = EXMLIncorrectCharacterHandling.DO_NOT_WRITE_LOG_WARNING;
    private Charset m_aCharset = DEFAULT_XML_CHARSET_OBJ;
    private NamespaceContext m_aNamespaceContext;
    private boolean m_bUseDoubleQuotesForAttributes = true;
    private boolean m_bSpaceOnSelfClosedElement = true;
    private String m_sNewlineString = DEFAULT_NEWLINE_STRING;
    private String m_sIndentationString = "  ";
    private boolean m_bEmitNamespaces = true;
    private boolean m_bPutNamespaceContextPrefixesInRoot = false;

    public XMLWriterSettings() {
    }

    public XMLWriterSettings(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull(iXMLWriterSettings, "Other");
        this.setFormat(iXMLWriterSettings.getFormat());
        this.setXMLVersion(iXMLWriterSettings.getXMLVersion());
        this.setSerializeDocType(iXMLWriterSettings.getSerializeDocType());
        this.setSerializeComments(iXMLWriterSettings.getSerializeComments());
        this.setIndent(iXMLWriterSettings.getIndent());
        this.setIncorrectCharacterHandling(iXMLWriterSettings.getIncorrectCharacterHandling());
        this.setCharset(iXMLWriterSettings.getCharsetObj());
        this.setNamespaceContext(iXMLWriterSettings.getNamespaceContext());
        this.setUseDoubleQuotesForAttributes(iXMLWriterSettings.isUseDoubleQuotesForAttributes());
        this.setSpaceOnSelfClosedElement(iXMLWriterSettings.isSpaceOnSelfClosedElement());
        this.setNewlineString(iXMLWriterSettings.getNewlineString());
        this.setIndentationString(iXMLWriterSettings.getIndentationString());
        this.setEmitNamespaces(iXMLWriterSettings.isEmitNamespaces());
        this.setPutNamespaceContextPrefixesInRoot(iXMLWriterSettings.isPutNamespaceContextPrefixesInRoot());
    }

    @Nonnull
    public final XMLWriterSettings setFormat(@Nonnull EXMLSerializeFormat eXMLSerializeFormat) {
        this.m_eFormat = ValueEnforcer.notNull(eXMLSerializeFormat, "Format");
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeFormat getFormat() {
        return this.m_eFormat;
    }

    @Nonnull
    public final XMLWriterSettings setXMLVersion(@Nonnull EXMLVersion eXMLVersion) {
        this.m_eXMLVersion = ValueEnforcer.notNull(eXMLVersion, "Version");
        return this;
    }

    @Override
    @Nonnull
    public EXMLVersion getXMLVersion() {
        return this.m_eXMLVersion;
    }

    @Nonnull
    public final XMLWriterSettings setSerializeDocType(@Nonnull EXMLSerializeDocType eXMLSerializeDocType) {
        this.m_eSerializeDocType = ValueEnforcer.notNull(eXMLSerializeDocType, "SerializeDocType");
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeDocType getSerializeDocType() {
        return this.m_eSerializeDocType;
    }

    @Nonnull
    public final XMLWriterSettings setSerializeComments(@Nonnull EXMLSerializeComments eXMLSerializeComments) {
        this.m_eSerializeComments = ValueEnforcer.notNull(eXMLSerializeComments, "SerializeComments");
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeComments getSerializeComments() {
        return this.m_eSerializeComments;
    }

    @Nonnull
    public final XMLWriterSettings setIndent(@Nonnull EXMLSerializeIndent eXMLSerializeIndent) {
        this.m_eIndent = ValueEnforcer.notNull(eXMLSerializeIndent, "Indent");
        return this;
    }

    @Override
    @Nonnull
    public EXMLSerializeIndent getIndent() {
        return this.m_eIndent;
    }

    @Nonnull
    public final XMLWriterSettings setIncorrectCharacterHandling(@Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling) {
        this.m_eIncorrectCharacterHandling = ValueEnforcer.notNull(eXMLIncorrectCharacterHandling, "IncorrectCharacterHandling");
        return this;
    }

    @Override
    @Nonnull
    public EXMLIncorrectCharacterHandling getIncorrectCharacterHandling() {
        return this.m_eIncorrectCharacterHandling;
    }

    @Nonnull
    public final XMLWriterSettings setCharset(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
        return this;
    }

    @Nonnull
    @Deprecated
    public final XMLWriterSettings setCharset(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Chrset");
        return this.setCharset(CharsetManager.getCharsetFromName(string));
    }

    @Override
    @Nonnull
    public String getCharset() {
        return this.m_aCharset.name();
    }

    @Override
    @Nonnull
    public Charset getCharsetObj() {
        return this.m_aCharset;
    }

    @Nonnull
    public final XMLWriterSettings setNamespaceContext(@Nullable NamespaceContext namespaceContext) {
        this.m_aNamespaceContext = namespaceContext;
        return this;
    }

    @Override
    @Nullable
    public NamespaceContext getNamespaceContext() {
        return this.m_aNamespaceContext;
    }

    @Nonnull
    public final XMLWriterSettings setUseDoubleQuotesForAttributes(boolean bl) {
        this.m_bUseDoubleQuotesForAttributes = bl;
        return this;
    }

    @Override
    public boolean isUseDoubleQuotesForAttributes() {
        return this.m_bUseDoubleQuotesForAttributes;
    }

    @Nonnull
    public final XMLWriterSettings setSpaceOnSelfClosedElement(boolean bl) {
        this.m_bSpaceOnSelfClosedElement = bl;
        return this;
    }

    @Override
    public boolean isSpaceOnSelfClosedElement() {
        return this.m_bSpaceOnSelfClosedElement;
    }

    @Nonnull
    public final XMLWriterSettings setNewlineString(@Nonnull @Nonempty ENewLineMode eNewLineMode) {
        ValueEnforcer.notNull(eNewLineMode, "NewlineMode");
        return this.setNewlineString(eNewLineMode.getText());
    }

    @Nonnull
    public final XMLWriterSettings setNewlineString(@Nonnull @Nonempty String string) {
        this.m_sNewlineString = ValueEnforcer.notEmpty(string, "NewlineString");
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNewlineString() {
        return this.m_sNewlineString;
    }

    @Nonnull
    public final XMLWriterSettings setIndentationString(@Nonnull @Nonempty String string) {
        this.m_sIndentationString = ValueEnforcer.notEmpty(string, "IndentationString");
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getIndentationString() {
        return this.m_sIndentationString;
    }

    @Nonnull
    public final XMLWriterSettings setEmitNamespaces(boolean bl) {
        this.m_bEmitNamespaces = bl;
        return this;
    }

    @Override
    public boolean isEmitNamespaces() {
        return this.m_bEmitNamespaces;
    }

    @Nonnull
    public final XMLWriterSettings setPutNamespaceContextPrefixesInRoot(boolean bl) {
        this.m_bPutNamespaceContextPrefixesInRoot = bl;
        return this;
    }

    @Override
    public boolean isPutNamespaceContextPrefixesInRoot() {
        return this.m_bPutNamespaceContextPrefixesInRoot;
    }

    @Override
    @Nonnull
    public XMLWriterSettings getClone() {
        return new XMLWriterSettings(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XMLWriterSettings xMLWriterSettings = (XMLWriterSettings)object;
        return this.m_eFormat.equals(xMLWriterSettings.m_eFormat) && this.m_eXMLVersion.equals((Object)xMLWriterSettings.m_eXMLVersion) && this.m_eSerializeDocType.equals(xMLWriterSettings.m_eSerializeDocType) && this.m_eSerializeComments.equals(xMLWriterSettings.m_eSerializeComments) && this.m_eIndent.equals(xMLWriterSettings.m_eIndent) && this.m_eIncorrectCharacterHandling.equals((Object)xMLWriterSettings.m_eIncorrectCharacterHandling) && this.m_aCharset.equals(xMLWriterSettings.m_aCharset) && EqualsUtils.equals(this.m_aNamespaceContext, xMLWriterSettings.m_aNamespaceContext) && this.m_bUseDoubleQuotesForAttributes == xMLWriterSettings.m_bUseDoubleQuotesForAttributes && this.m_bSpaceOnSelfClosedElement == xMLWriterSettings.m_bSpaceOnSelfClosedElement && this.m_sNewlineString.equals(xMLWriterSettings.m_sNewlineString) && this.m_sIndentationString.equals(xMLWriterSettings.m_sIndentationString) && this.m_bEmitNamespaces == xMLWriterSettings.m_bEmitNamespaces && this.m_bPutNamespaceContextPrefixesInRoot == xMLWriterSettings.m_bPutNamespaceContextPrefixesInRoot;
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eFormat)).append((Enum)this.m_eXMLVersion)).append((Enum)this.m_eSerializeDocType)).append((Enum)this.m_eSerializeComments)).append((Enum)this.m_eIndent)).append((Enum)this.m_eIncorrectCharacterHandling)).append(this.m_aCharset).append(this.m_aNamespaceContext).append(this.m_bUseDoubleQuotesForAttributes).append(this.m_bSpaceOnSelfClosedElement).append(this.m_sNewlineString).append(this.m_sIndentationString).append(this.m_bEmitNamespaces).append(this.m_bPutNamespaceContextPrefixesInRoot).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("format", this.m_eFormat).append("xmlVersion", this.m_eXMLVersion).append("serializeDocType", this.m_eSerializeDocType).append("serializeComments", this.m_eSerializeComments).append("indent", this.m_eIndent).append("incorrectCharHandling", this.m_eIncorrectCharacterHandling).append("charset", this.m_aCharset).append("namespaceContext", this.m_aNamespaceContext).append("doubleQuotesForAttrs", this.m_bUseDoubleQuotesForAttributes).append("spaceOnSelfClosedElement", this.m_bSpaceOnSelfClosedElement).append("newlineString", StringHelper.getHexEncoded(CharsetManager.getAsBytes(this.m_sNewlineString, CCharset.CHARSET_ISO_8859_1_OBJ))).append("indentationString", StringHelper.getHexEncoded(CharsetManager.getAsBytes(this.m_sIndentationString, CCharset.CHARSET_ISO_8859_1_OBJ))).append("emitNamespaces", this.m_bEmitNamespaces).append("putNamespaceContextPrefixesInRoot", this.m_bPutNamespaceContextPrefixesInRoot).toString();
    }
}

