/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamSource;

@NotThreadSafe
public class CachingTransformStreamSource
extends StreamSource {
    public CachingTransformStreamSource(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource.getInputStream(), iReadableResource.getResourceID());
    }

    public CachingTransformStreamSource(@Nonnull IInputStreamProvider iInputStreamProvider) {
        this(iInputStreamProvider, null);
    }

    public CachingTransformStreamSource(@Nonnull IInputStreamProvider iInputStreamProvider, @Nullable String string) {
        this(iInputStreamProvider.getInputStream(), string);
    }

    public CachingTransformStreamSource(@Nonnull @WillClose InputStream inputStream) {
        this(inputStream, null);
    }

    public CachingTransformStreamSource(@Nonnull @WillClose InputStream inputStream, @Nullable String string) {
        super(new NonBlockingByteArrayInputStream(StreamUtils.getAllBytes(inputStream)), string);
    }

    public String toString() {
        return new ToStringGenerator(this).append("systemID", this.getSystemId()).toString();
    }
}

