/**
 * Copyright (C) 2006-2015 phloc systems
 * http://www.phloc.com
 * office[at]phloc[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.phloc.commons.io.streams;

import java.io.IOException;
import java.io.OutputStream;

import javax.annotation.Nonnull;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.string.ToStringGenerator;

/**
 * A wrapper around another {@link OutputStream}. Pass through of all
 * {@link OutputStream} methods.
 * 
 * @author Philip Helger
 */
public class WrappedOutputStream extends OutputStream
{
  private final OutputStream m_aWrappedOS;

  public WrappedOutputStream (@Nonnull final OutputStream aWrappedOS)
  {
    m_aWrappedOS = ValueEnforcer.notNull (aWrappedOS, "WrappedOutputStream");
  }

  @Nonnull
  public OutputStream getWrappedOutputStream ()
  {
    return m_aWrappedOS;
  }

  @Override
  public void write (final int n) throws IOException
  {
    m_aWrappedOS.write (n);
  }

  @Override
  public final void write (final byte [] aBuf) throws IOException
  {
    write (aBuf, 0, aBuf.length);
  }

  @Override
  public void write (final byte [] aBuf, final int nOfs, final int nLength) throws IOException
  {
    m_aWrappedOS.write (aBuf, nOfs, nLength);
  }

  @Override
  public void flush () throws IOException
  {
    m_aWrappedOS.flush ();
  }

  @Override
  public void close () throws IOException
  {
    m_aWrappedOS.close ();
  }

  @Override
  public String toString ()
  {
    return new ToStringGenerator (this).append ("wrappedOS", m_aWrappedOS).toString ();
  }
}
