/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.EmptySortedSet;
import com.phloc.commons.collections.NonBlockingStack;
import com.phloc.commons.collections.iterate.CombinedEnumeration;
import com.phloc.commons.collections.iterate.CombinedIterator;
import com.phloc.commons.collections.iterate.EmptyEnumeration;
import com.phloc.commons.collections.iterate.EmptyIterator;
import com.phloc.commons.collections.iterate.EnumerationFromIterator;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.collections.iterate.IterableIteratorFromEnumeration;
import com.phloc.commons.collections.iterate.ReverseListIterator;
import com.phloc.commons.collections.multimap.IMultiMap;
import com.phloc.commons.collections.multimap.IMultiMapSetBased;
import com.phloc.commons.collections.multimap.MultiHashMapHashSetBased;
import com.phloc.commons.compare.ComparatorComparableNullAware;
import com.phloc.commons.compare.ComparatorUtils;
import com.phloc.commons.compare.ESortOrder;
import com.phloc.commons.state.EChange;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ContainerHelper {
    private ContainerHelper() {
    }

    @Nonnull
    public static <ELEMENTTYPE> List<? extends ELEMENTTYPE> getNotNull(List<? extends ELEMENTTYPE> list) {
        return list == null ? ContainerHelper.newList() : list;
    }

    @Nonnull
    public static <ELEMENTTYPE> Set<? extends ELEMENTTYPE> getNotNull(Set<? extends ELEMENTTYPE> set) {
        return set == null ? ContainerHelper.newSet() : set;
    }

    @Nonnull
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<? extends ELEMENTTYPE> getNotNull(SortedSet<? extends ELEMENTTYPE> sortedSet) {
        return sortedSet == null ? ContainerHelper.newSortedSet() : sortedSet;
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Map<? extends KEYTYPE, ? extends VALUETYPE> getNotNull(Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        return map == null ? ContainerHelper.newMap() : map;
    }

    @Nonnull
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<? extends KEYTYPE, ? extends VALUETYPE> getNotNull(SortedMap<? extends KEYTYPE, ? extends VALUETYPE> sortedMap) {
        return sortedMap == null ? ContainerHelper.newSortedMap() : sortedMap;
    }

    @Nullable
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Collection<ELEMENTTYPE> makeUnmodifiable(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return collection == null ? null : Collections.unmodifiableCollection(collection);
    }

    @Nullable
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> makeUnmodifiable(@Nullable List<? extends ELEMENTTYPE> list) {
        return list == null ? null : Collections.unmodifiableList(list);
    }

    @Nullable
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> makeUnmodifiable(@Nullable Set<? extends ELEMENTTYPE> set) {
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    @Nullable
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> makeUnmodifiable(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    @Nullable
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> makeUnmodifiable(@Nullable SortedSet<ELEMENTTYPE> sortedSet) {
        return sortedSet == null ? null : Collections.unmodifiableSortedSet(sortedSet);
    }

    @Nullable
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> makeUnmodifiable(@Nullable SortedMap<KEYTYPE, ? extends VALUETYPE> sortedMap) {
        return sortedMap == null ? null : Collections.unmodifiableSortedMap(sortedMap);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Collection<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return collection == null ? ContainerHelper.newUnmodifiableList() : Collections.unmodifiableCollection(collection);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable List<? extends ELEMENTTYPE> list) {
        return list == null ? ContainerHelper.newUnmodifiableList() : Collections.unmodifiableList(list);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable Set<? extends ELEMENTTYPE> set) {
        return set == null ? ContainerHelper.newUnmodifiableSet() : Collections.unmodifiableSet(set);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> makeUnmodifiableNotNull(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        return map == null ? ContainerHelper.newUnmodifiableMap() : Collections.unmodifiableMap(map);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable SortedSet<ELEMENTTYPE> sortedSet) {
        return sortedSet == null ? ContainerHelper.newUnmodifiableSortedSet() : Collections.unmodifiableSortedSet(sortedSet);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> makeUnmodifiableNotNull(@Nullable SortedMap<KEYTYPE, ? extends VALUETYPE> sortedMap) {
        return Collections.unmodifiableSortedMap(sortedMap == null ? ContainerHelper.newSortedMap() : sortedMap);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> getDifference(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        if (ContainerHelper.isEmpty(collection)) {
            return ContainerHelper.newSet();
        }
        if (ContainerHelper.isEmpty(collection2)) {
            return ContainerHelper.newSet(collection);
        }
        Set<ELEMENTTYPE> set = ContainerHelper.newSet(collection);
        set.removeAll(collection2);
        return set;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> getIntersected(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        if (ContainerHelper.isEmpty(collection)) {
            return ContainerHelper.newSet();
        }
        if (ContainerHelper.isEmpty(collection2)) {
            return ContainerHelper.newSet();
        }
        Set<ELEMENTTYPE> set = ContainerHelper.newSet(collection);
        set.retainAll(collection2);
        return set;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap() {
        return new HashMap(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        HashMap<KEYTYPE, VALUETYPE> hashMap = new HashMap<KEYTYPE, VALUETYPE>(1);
        hashMap.put(KEYTYPE, VALUETYPE);
        return hashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Map<ELEMENTTYPE, ELEMENTTYPE> newMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return new HashMap(0);
        }
        if (ELEMENTTYPEArray.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        HashMap<ELEMENTTYPE, ELEMENTTYPE> hashMap = new HashMap<ELEMENTTYPE, ELEMENTTYPE>(ELEMENTTYPEArray.length / 2);
        for (int i = 0; i < ELEMENTTYPEArray.length; i += 2) {
            hashMap.put(ELEMENTTYPEArray[i], ELEMENTTYPEArray[i + 1]);
        }
        return hashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        if (ArrayHelper.isEmpty(KEYTYPEArray) && ArrayHelper.isEmpty(VALUETYPEArray)) {
            return new HashMap(0);
        }
        if (ArrayHelper.getSize(KEYTYPEArray) != ArrayHelper.getSize(VALUETYPEArray)) {
            throw new IllegalArgumentException("The passed arrays have different length!");
        }
        HashMap<KEYTYPE, VALUETYPE> hashMap = new HashMap<KEYTYPE, VALUETYPE>(KEYTYPEArray.length);
        for (int i = 0; i < KEYTYPEArray.length; ++i) {
            hashMap.put(KEYTYPEArray[i], VALUETYPEArray[i]);
        }
        return hashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        if (ContainerHelper.isEmpty(collection) && ContainerHelper.isEmpty(collection2)) {
            return new HashMap(0);
        }
        if (ContainerHelper.getSize(collection) != ContainerHelper.getSize(collection2)) {
            throw new IllegalArgumentException("Number of keys is different from number of values");
        }
        HashMap<KEYTYPE, VALUETYPE> hashMap = new HashMap<KEYTYPE, VALUETYPE>(collection.size());
        Iterator<KEYTYPE> iterator = collection.iterator();
        Iterator<VALUETYPE> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            hashMap.put(iterator.next(), iterator2.next());
        }
        return hashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (ContainerHelper.isEmpty(map)) {
            return new HashMap(0);
        }
        return new HashMap<KEYTYPE, VALUETYPE>(map);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        if (mapArray == null || mapArray.length == 0) {
            return new HashMap(0);
        }
        HashMap<? extends KEYTYPE, ? extends VALUETYPE> hashMap = new HashMap<KEYTYPE, VALUETYPE>();
        for (Map<? extends KEYTYPE, ? extends VALUETYPE> map : mapArray) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return new HashMap(0);
        }
        HashMap<KEYTYPE, VALUETYPE> hashMap = new HashMap<KEYTYPE, VALUETYPE>(collection.size());
        for (Map.Entry<KEYTYPE, VALUETYPE> entry : collection) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap() {
        return Collections.emptyMap();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        return Collections.singletonMap(KEYTYPE, VALUETYPE);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Map<ELEMENTTYPE, ELEMENTTYPE> newUnmodifiableMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newMap(ELEMENTTYPEArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newMap(KEYTYPEArray, VALUETYPEArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newMap(collection, collection2));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        return ContainerHelper.makeUnmodifiable(map);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newMap(mapArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newMap(collection));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap() {
        return new LinkedHashMap(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        LinkedHashMap<KEYTYPE, VALUETYPE> linkedHashMap = new LinkedHashMap<KEYTYPE, VALUETYPE>(1);
        linkedHashMap.put(KEYTYPE, VALUETYPE);
        return linkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Map<ELEMENTTYPE, ELEMENTTYPE> newOrderedMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return new LinkedHashMap(0);
        }
        if (ELEMENTTYPEArray.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        LinkedHashMap<ELEMENTTYPE, ELEMENTTYPE> linkedHashMap = new LinkedHashMap<ELEMENTTYPE, ELEMENTTYPE>(ELEMENTTYPEArray.length / 2);
        for (int i = 0; i < ELEMENTTYPEArray.length; i += 2) {
            linkedHashMap.put(ELEMENTTYPEArray[i], ELEMENTTYPEArray[i + 1]);
        }
        return linkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        if (ArrayHelper.isEmpty(KEYTYPEArray) && ArrayHelper.isEmpty(VALUETYPEArray)) {
            return new LinkedHashMap(0);
        }
        if (ArrayHelper.getSize(KEYTYPEArray) != ArrayHelper.getSize(VALUETYPEArray)) {
            throw new IllegalArgumentException("The passed arrays have different length!");
        }
        LinkedHashMap<KEYTYPE, VALUETYPE> linkedHashMap = new LinkedHashMap<KEYTYPE, VALUETYPE>(KEYTYPEArray.length);
        for (int i = 0; i < KEYTYPEArray.length; ++i) {
            linkedHashMap.put(KEYTYPEArray[i], VALUETYPEArray[i]);
        }
        return linkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        if (ContainerHelper.isEmpty(collection) && ContainerHelper.isEmpty(collection2)) {
            return new LinkedHashMap(0);
        }
        if (ContainerHelper.getSize(collection) != ContainerHelper.getSize(collection2)) {
            throw new IllegalArgumentException("Number of keys is different from number of values");
        }
        LinkedHashMap<KEYTYPE, VALUETYPE> linkedHashMap = new LinkedHashMap<KEYTYPE, VALUETYPE>(collection.size());
        Iterator<KEYTYPE> iterator = collection.iterator();
        Iterator<VALUETYPE> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            linkedHashMap.put(iterator.next(), iterator2.next());
        }
        return linkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (ContainerHelper.isEmpty(map)) {
            return new LinkedHashMap(0);
        }
        return new LinkedHashMap<KEYTYPE, VALUETYPE>(map);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        if (mapArray == null || mapArray.length == 0) {
            return new LinkedHashMap(0);
        }
        LinkedHashMap<? extends KEYTYPE, ? extends VALUETYPE> linkedHashMap = new LinkedHashMap<KEYTYPE, VALUETYPE>();
        for (Map<? extends KEYTYPE, ? extends VALUETYPE> map : mapArray) {
            linkedHashMap.putAll(map);
        }
        return linkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return new LinkedHashMap(0);
        }
        LinkedHashMap<KEYTYPE, VALUETYPE> linkedHashMap = new LinkedHashMap<KEYTYPE, VALUETYPE>(collection.size());
        for (Map.Entry<KEYTYPE, VALUETYPE> entry : collection) {
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        return linkedHashMap;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap() {
        return Collections.emptyMap();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        return Collections.singletonMap(KEYTYPE, VALUETYPE);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Map<ELEMENTTYPE, ELEMENTTYPE> newUnmodifiableOrderedMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedMap(ELEMENTTYPEArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedMap(KEYTYPEArray, VALUETYPEArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedMap(collection, collection2));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        return ContainerHelper.makeUnmodifiable(map);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedMap(mapArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedMap(collection));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap() {
        return new TreeMap(new ComparatorComparableNullAware());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        TreeMap treeMap = new TreeMap(new ComparatorComparableNullAware());
        treeMap.put(KEYTYPE, VALUETYPE);
        return treeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeMap<ELEMENTTYPE, ELEMENTTYPE> newSortedMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        if (ELEMENTTYPEArray.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        TreeMap treeMap = new TreeMap(new ComparatorComparableNullAware());
        for (int i = 0; i < ELEMENTTYPEArray.length; i += 2) {
            treeMap.put(ELEMENTTYPEArray[i], ELEMENTTYPEArray[i + 1]);
        }
        return treeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        if (ArrayHelper.isEmpty(KEYTYPEArray) && ArrayHelper.isEmpty(VALUETYPEArray)) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        if (ArrayHelper.getSize(KEYTYPEArray) != ArrayHelper.getSize(VALUETYPEArray)) {
            throw new IllegalArgumentException("The passed arrays have different length!");
        }
        TreeMap treeMap = new TreeMap(new ComparatorComparableNullAware());
        for (int i = 0; i < KEYTYPEArray.length; ++i) {
            treeMap.put(KEYTYPEArray[i], VALUETYPEArray[i]);
        }
        return treeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        if (ContainerHelper.isEmpty(collection) && ContainerHelper.isEmpty(collection2)) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        if (ContainerHelper.getSize(collection) != ContainerHelper.getSize(collection2)) {
            throw new IllegalArgumentException("Number of keys is different from number of values");
        }
        TreeMap treeMap = new TreeMap(new ComparatorComparableNullAware());
        Iterator<KEYTYPE> iterator = collection.iterator();
        Iterator<VALUETYPE> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            treeMap.put(iterator.next(), iterator2.next());
        }
        return treeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (ContainerHelper.isEmpty(map)) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        TreeMap treeMap = new TreeMap(new ComparatorComparableNullAware());
        treeMap.putAll(map);
        return treeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        if (mapArray == null || mapArray.length == 0) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        TreeMap treeMap = new TreeMap(new ComparatorComparableNullAware());
        for (Map<? extends KEYTYPE, ? extends VALUETYPE> map : mapArray) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        TreeMap treeMap = new TreeMap(new ComparatorComparableNullAware());
        for (Map.Entry<KEYTYPE, VALUETYPE> entry : collection) {
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap() {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.<KEYTYPE, VALUETYPE>newSortedMap());
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(KEYTYPE, VALUETYPE));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedMap<ELEMENTTYPE, ELEMENTTYPE> newUnmodifiableSortedMap(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(ELEMENTTYPEArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable KEYTYPE[] KEYTYPEArray, @Nullable VALUETYPE[] VALUETYPEArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(KEYTYPEArray, VALUETYPEArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable Collection<? extends KEYTYPE> collection, @Nullable Collection<? extends VALUETYPE> collection2) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(collection, collection2));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable SortedMap<KEYTYPE, ? extends VALUETYPE> sortedMap) {
        return ContainerHelper.makeUnmodifiable(sortedMap);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable Map<KEYTYPE, ? extends VALUETYPE>[] mapArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(mapArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> collection) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(collection));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet() {
        return new HashSet(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        HashSet<ELEMENTTYPE> hashSet = new HashSet<ELEMENTTYPE>(1);
        hashSet.add(ELEMENTTYPE);
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return new HashSet(0);
        }
        HashSet hashSet = new HashSet(ELEMENTTYPEArray.length);
        Collections.addAll(hashSet, ELEMENTTYPEArray);
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        HashSet<ELEMENTTYPE> hashSet = new HashSet<ELEMENTTYPE>();
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                hashSet.add(ELEMENTTYPE);
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return new HashSet(0);
        }
        return new HashSet<ELEMENTTYPE>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        HashSet<ELEMENTTYPE> hashSet = new HashSet<ELEMENTTYPE>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return new HashSet(0);
        }
        return ContainerHelper.newSet(iIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        HashSet<ELEMENTTYPE> hashSet = new HashSet<ELEMENTTYPE>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Enum<ELEMENTTYPE>> EnumSet<ELEMENTTYPE> newEnumSet(@Nonnull Class<ELEMENTTYPE> clazz, ELEMENTTYPE ... ELEMENTTYPEArray) {
        EnumSet<ELEMENTTYPE> enumSet = EnumSet.noneOf(clazz);
        if (ELEMENTTYPEArray != null) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                enumSet.add(ELEMENTTYPE);
            }
        }
        return enumSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Enum<ELEMENTTYPE>> EnumSet<ELEMENTTYPE> newEnumSet(@Nonnull Class<ELEMENTTYPE> clazz, @Nullable Collection<ELEMENTTYPE> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return EnumSet.noneOf(clazz);
        }
        return EnumSet.copyOf(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Enum<ELEMENTTYPE>> EnumSet<ELEMENTTYPE> newEnumSet(@Nonnull Class<ELEMENTTYPE> clazz, @Nullable EnumSet<ELEMENTTYPE> enumSet) {
        if (enumSet == null) {
            return EnumSet.noneOf(clazz);
        }
        return EnumSet.copyOf(enumSet);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Boolean> newBooleanSet(boolean ... blArray) {
        HashSet<Boolean> hashSet = new HashSet<Boolean>();
        if (blArray != null) {
            for (boolean bl : blArray) {
                hashSet.add(bl);
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Byte> newByteSet(byte ... byArray) {
        HashSet<Byte> hashSet = new HashSet<Byte>();
        if (byArray != null) {
            for (byte by : byArray) {
                hashSet.add(by);
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Character> newCharSet(char ... cArray) {
        HashSet<Character> hashSet = new HashSet<Character>();
        if (cArray != null) {
            for (char c : cArray) {
                hashSet.add(Character.valueOf(c));
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Double> newDoubleSet(double ... dArray) {
        HashSet<Double> hashSet = new HashSet<Double>();
        if (dArray != null) {
            for (double d : dArray) {
                hashSet.add(d);
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Float> newFloatSet(float ... fArray) {
        HashSet<Float> hashSet = new HashSet<Float>();
        if (fArray != null) {
            for (float f : fArray) {
                hashSet.add(Float.valueOf(f));
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Integer> newIntSet(int ... nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (nArray != null) {
            for (int n : nArray) {
                hashSet.add(n);
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Long> newLongSet(long ... lArray) {
        HashSet<Long> hashSet = new HashSet<Long>();
        if (lArray != null) {
            for (long l : lArray) {
                hashSet.add(l);
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Short> newShortSet(short ... sArray) {
        HashSet<Short> hashSet = new HashSet<Short>();
        if (sArray != null) {
            for (short s : sArray) {
                hashSet.add(s);
            }
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet() {
        return Collections.emptySet();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return Collections.singleton(ELEMENTTYPE);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(ELEMENTTYPEArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(iterable));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(collection));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(iterator));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(iIterableIterator));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(enumeration));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Boolean> newUnmodifiableBooleanSet(boolean ... blArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newBooleanSet(blArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Byte> newUnmodifiableByteSet(byte ... byArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newByteSet(byArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Character> newUnmodifiableCharSet(char ... cArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newCharSet(cArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Double> newUnmodifiableDoubleSet(double ... dArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newDoubleSet(dArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Float> newUnmodifiableFloatSet(float ... fArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newFloatSet(fArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Integer> newUnmodifiableIntSet(int ... nArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newIntSet(nArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Long> newUnmodifiableLongSet(long ... lArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newLongSet(lArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Short> newUnmodifiableShortSet(short ... sArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newShortSet(sArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet() {
        return new TreeSet(new ComparatorComparableNullAware());
    }

    @Nonnull
    @ReturnsMutableCopy
    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="When using the constructor with the Comparator it works with null values!")
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        TreeSet treeSet = new TreeSet(new ComparatorComparableNullAware());
        treeSet.add(ELEMENTTYPE);
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        TreeSet treeSet = new TreeSet(new ComparatorComparableNullAware());
        if (ArrayHelper.isNotEmpty(ELEMENTTYPEArray)) {
            Collections.addAll(treeSet, ELEMENTTYPEArray);
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        TreeSet treeSet = new TreeSet(new ComparatorComparableNullAware());
        if (iterable != null) {
            for (Comparable comparable : iterable) {
                treeSet.add(comparable);
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        TreeSet treeSet = new TreeSet(new ComparatorComparableNullAware());
        if (ContainerHelper.isNotEmpty(collection)) {
            treeSet.addAll(collection);
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        TreeSet treeSet = new TreeSet(new ComparatorComparableNullAware());
        if (iterator != null) {
            while (iterator.hasNext()) {
                treeSet.add(iterator.next());
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return new TreeSet(new ComparatorComparableNullAware());
        }
        return ContainerHelper.newSortedSet(iIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        TreeSet treeSet = new TreeSet(new ComparatorComparableNullAware());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                treeSet.add(enumeration.nextElement());
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Boolean> newBooleanSortedSet(boolean ... blArray) {
        TreeSet<Boolean> treeSet = new TreeSet<Boolean>(new ComparatorComparableNullAware());
        if (blArray != null) {
            for (boolean bl : blArray) {
                treeSet.add(bl);
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Byte> newByteSortedSet(byte ... byArray) {
        TreeSet<Byte> treeSet = new TreeSet<Byte>(new ComparatorComparableNullAware());
        if (byArray != null) {
            for (byte by : byArray) {
                treeSet.add(by);
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Character> newCharSortedSet(char ... cArray) {
        TreeSet<Character> treeSet = new TreeSet<Character>(new ComparatorComparableNullAware());
        if (cArray != null) {
            for (char c : cArray) {
                treeSet.add(Character.valueOf(c));
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Double> newDoubleSortedSet(double ... dArray) {
        TreeSet<Double> treeSet = new TreeSet<Double>(new ComparatorComparableNullAware());
        if (dArray != null) {
            for (double d : dArray) {
                treeSet.add(d);
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Float> newFloatSortedSet(float ... fArray) {
        TreeSet<Float> treeSet = new TreeSet<Float>(new ComparatorComparableNullAware());
        if (fArray != null) {
            for (float f : fArray) {
                treeSet.add(Float.valueOf(f));
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Integer> newIntSortedSet(int ... nArray) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>(new ComparatorComparableNullAware());
        if (nArray != null) {
            for (int n : nArray) {
                treeSet.add(n);
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Long> newLongSortedSet(long ... lArray) {
        TreeSet<Long> treeSet = new TreeSet<Long>(new ComparatorComparableNullAware());
        if (lArray != null) {
            for (long l : lArray) {
                treeSet.add(l);
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Short> newShortSortedSet(short ... sArray) {
        TreeSet<Short> treeSet = new TreeSet<Short>(new ComparatorComparableNullAware());
        if (sArray != null) {
            for (short s : sArray) {
                treeSet.add(s);
            }
        }
        return treeSet;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet() {
        return EmptySortedSet.getInstance();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(ELEMENTTYPE));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(ELEMENTTYPEArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(iterable));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(collection));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(iterator));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(iIterableIterator));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(enumeration));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Boolean> newUnmodifiableBooleanSortedSet(boolean ... blArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newBooleanSortedSet(blArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Byte> newUnmodifiableByteSortedSet(byte ... byArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newByteSortedSet(byArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Character> newUnmodifiableCharSortedSet(char ... cArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newCharSortedSet(cArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Double> newUnmodifiableDoubleSortedSet(double ... dArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newDoubleSortedSet(dArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Float> newUnmodifiableFloatSortedSet(float ... fArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newFloatSortedSet(fArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Integer> newUnmodifiableIntSortedSet(int ... nArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newIntSortedSet(nArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Long> newUnmodifiableLongSortedSet(long ... lArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newLongSortedSet(lArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Short> newUnmodifiableShortSortedSet(short ... sArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newShortSortedSet(sArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet() {
        return new LinkedHashSet(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        LinkedHashSet<ELEMENTTYPE> linkedHashSet = new LinkedHashSet<ELEMENTTYPE>(1);
        linkedHashSet.add(ELEMENTTYPE);
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return new LinkedHashSet(0);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(ELEMENTTYPEArray.length);
        Collections.addAll(linkedHashSet, ELEMENTTYPEArray);
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        LinkedHashSet<ELEMENTTYPE> linkedHashSet = new LinkedHashSet<ELEMENTTYPE>();
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                linkedHashSet.add(ELEMENTTYPE);
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return new LinkedHashSet(0);
        }
        return new LinkedHashSet<ELEMENTTYPE>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nonnull Iterator<? extends ELEMENTTYPE> iterator) {
        LinkedHashSet<ELEMENTTYPE> linkedHashSet = new LinkedHashSet<ELEMENTTYPE>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                linkedHashSet.add(iterator.next());
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return new LinkedHashSet(0);
        }
        return ContainerHelper.newOrderedSet(iIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        LinkedHashSet<ELEMENTTYPE> linkedHashSet = new LinkedHashSet<ELEMENTTYPE>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                linkedHashSet.add(enumeration.nextElement());
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Boolean> newBooleanOrderedSet(boolean ... blArray) {
        LinkedHashSet<Boolean> linkedHashSet = new LinkedHashSet<Boolean>();
        if (blArray != null) {
            for (boolean bl : blArray) {
                linkedHashSet.add(bl);
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Byte> newByteOrderedSet(byte ... byArray) {
        LinkedHashSet<Byte> linkedHashSet = new LinkedHashSet<Byte>();
        if (byArray != null) {
            for (byte by : byArray) {
                linkedHashSet.add(by);
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Character> newCharOrderedSet(char ... cArray) {
        LinkedHashSet<Character> linkedHashSet = new LinkedHashSet<Character>();
        if (cArray != null) {
            for (char c : cArray) {
                linkedHashSet.add(Character.valueOf(c));
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Double> newDoubleOrderedSet(double ... dArray) {
        LinkedHashSet<Double> linkedHashSet = new LinkedHashSet<Double>();
        if (dArray != null) {
            for (double d : dArray) {
                linkedHashSet.add(d);
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Float> newFloatOrderedSet(float ... fArray) {
        LinkedHashSet<Float> linkedHashSet = new LinkedHashSet<Float>();
        if (fArray != null) {
            for (float f : fArray) {
                linkedHashSet.add(Float.valueOf(f));
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Integer> newIntOrderedSet(int ... nArray) {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        if (nArray != null) {
            for (int n : nArray) {
                linkedHashSet.add(n);
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Long> newLongOrderedSet(long ... lArray) {
        LinkedHashSet<Long> linkedHashSet = new LinkedHashSet<Long>();
        if (lArray != null) {
            for (long l : lArray) {
                linkedHashSet.add(l);
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Short> newShortOrderedSet(short ... sArray) {
        LinkedHashSet<Short> linkedHashSet = new LinkedHashSet<Short>();
        if (sArray != null) {
            for (short s : sArray) {
                linkedHashSet.add(s);
            }
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet() {
        return Collections.emptySet();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return Collections.singleton(ELEMENTTYPE);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(ELEMENTTYPEArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterable<? extends ELEMENTTYPE> iterable) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(iterable));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nonnull Collection<? extends ELEMENTTYPE> collection) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(collection));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterator<? extends ELEMENTTYPE> iterator) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(iterator));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nonnull IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(iIterableIterator));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(enumeration));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Boolean> newUnmodifiableBooleanOrderedSet(boolean ... blArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newBooleanOrderedSet(blArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Byte> newUnmodifiableByteOrderedSet(byte ... byArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newByteOrderedSet(byArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Character> newUnmodifiableCharOrderedSet(char ... cArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newCharOrderedSet(cArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Double> newUnmodifiableDoubleOrderedSet(double ... dArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newDoubleOrderedSet(dArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Float> newUnmodifiableFloatOrderedSet(float ... fArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newFloatOrderedSet(fArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Integer> newUnmodifiableIntOrderedSet(int ... nArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newIntOrderedSet(nArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Long> newUnmodifiableLongOrderedSet(long ... lArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newLongOrderedSet(lArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Short> newUnmodifiableShortOrderedSet(short ... sArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newShortOrderedSet(sArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newListPrefilled(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Elements");
        ArrayList<ELEMENTTYPE> arrayList = new ArrayList<ELEMENTTYPE>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(ELEMENTTYPE);
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList() {
        return new ArrayList(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        ArrayList<ELEMENTTYPE> arrayList = new ArrayList<ELEMENTTYPE>(1);
        arrayList.add(ELEMENTTYPE);
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return new ArrayList(0);
        }
        ArrayList arrayList = new ArrayList(ELEMENTTYPEArray.length);
        Collections.addAll(arrayList, ELEMENTTYPEArray);
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        ArrayList<ELEMENTTYPE> arrayList = new ArrayList<ELEMENTTYPE>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        ArrayList<ELEMENTTYPE> arrayList = new ArrayList<ELEMENTTYPE>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        ArrayList<ELEMENTTYPE> arrayList = new ArrayList<ELEMENTTYPE>();
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                arrayList.add(ELEMENTTYPE);
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return new ArrayList(0);
        }
        return new ArrayList<ELEMENTTYPE>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return new ArrayList(0);
        }
        return ContainerHelper.newList(iIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVectorPrefilled(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Elements");
        Vector<ELEMENTTYPE> vector = new Vector<ELEMENTTYPE>(n);
        for (int i = 0; i < n; ++i) {
            vector.add(ELEMENTTYPE);
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector() {
        return new Vector(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        Vector<ELEMENTTYPE> vector = new Vector<ELEMENTTYPE>(1);
        vector.add(ELEMENTTYPE);
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return new Vector(0);
        }
        Vector vector = new Vector(ELEMENTTYPEArray.length);
        Collections.addAll(vector, ELEMENTTYPEArray);
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        Vector<ELEMENTTYPE> vector = new Vector<ELEMENTTYPE>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        Vector<ELEMENTTYPE> vector = new Vector<ELEMENTTYPE>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        Vector<ELEMENTTYPE> vector = new Vector<ELEMENTTYPE>();
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                vector.add(ELEMENTTYPE);
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return new Vector(0);
        }
        return new Vector<ELEMENTTYPE>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return new Vector(0);
        }
        return ContainerHelper.newVector(iIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Boolean> newBooleanList(boolean ... blArray) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        if (blArray != null) {
            for (boolean bl : blArray) {
                arrayList.add(bl);
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Byte> newByteList(byte ... byArray) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        if (byArray != null) {
            for (byte by : byArray) {
                arrayList.add(by);
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Character> newCharList(char ... cArray) {
        ArrayList<Character> arrayList = new ArrayList<Character>();
        if (cArray != null) {
            for (char c : cArray) {
                arrayList.add(Character.valueOf(c));
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Double> newDoubleList(double ... dArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (dArray != null) {
            for (double d : dArray) {
                arrayList.add(d);
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Float> newFloatList(float ... fArray) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        if (fArray != null) {
            for (float f : fArray) {
                arrayList.add(Float.valueOf(f));
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Integer> newIntList(int ... nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (nArray != null) {
            for (int n : nArray) {
                arrayList.add(n);
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Long> newLongList(long ... lArray) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (lArray != null) {
            for (long l : lArray) {
                arrayList.add(l);
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Short> newShortList(short ... sArray) {
        ArrayList<Short> arrayList = new ArrayList<Short>();
        if (sArray != null) {
            for (short s : sArray) {
                arrayList.add(s);
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Boolean> newBooleanVector(boolean ... blArray) {
        Vector<Boolean> vector = new Vector<Boolean>();
        if (blArray != null) {
            for (boolean bl : blArray) {
                vector.add(bl);
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Byte> newByteVector(byte ... byArray) {
        Vector<Byte> vector = new Vector<Byte>();
        if (byArray != null) {
            for (byte by : byArray) {
                vector.add(by);
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Character> newCharVector(char ... cArray) {
        Vector<Character> vector = new Vector<Character>();
        if (cArray != null) {
            for (char c : cArray) {
                vector.add(Character.valueOf(c));
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Double> newDoubleVector(double ... dArray) {
        Vector<Double> vector = new Vector<Double>();
        if (dArray != null) {
            for (double d : dArray) {
                vector.add(d);
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Float> newFloatVector(float ... fArray) {
        Vector<Float> vector = new Vector<Float>();
        if (fArray != null) {
            for (float f : fArray) {
                vector.add(Float.valueOf(f));
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Integer> newIntVector(int ... nArray) {
        Vector<Integer> vector = new Vector<Integer>();
        if (nArray != null) {
            for (int n : nArray) {
                vector.add(n);
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Long> newLongVector(long ... lArray) {
        Vector<Long> vector = new Vector<Long>();
        if (lArray != null) {
            for (long l : lArray) {
                vector.add(l);
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Short> newShortVector(short ... sArray) {
        Vector<Short> vector = new Vector<Short>();
        if (sArray != null) {
            for (short s : sArray) {
                vector.add(s);
            }
        }
        return vector;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList() {
        return Collections.emptyList();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return Collections.singletonList(ELEMENTTYPE);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(ELEMENTTYPEArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(enumeration));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(iterator));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(iterable));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(collection));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(iIterableIterator));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Boolean> newUnmodifiableBooleanList(boolean ... blArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newBooleanList(blArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Byte> newUnmodifiableByteList(byte ... byArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newByteList(byArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Character> newUnmodifiableCharList(char ... cArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newCharList(cArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Double> newUnmodifiableDoubleList(double ... dArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newDoubleList(dArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Float> newUnmodifiableFloatList(float ... fArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newFloatList(fArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Integer> newUnmodifiableIntList(int ... nArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newIntList(nArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Long> newUnmodifiableLongList(long ... lArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newLongList(lArray));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Short> newUnmodifiableShortList(short ... sArray) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newShortList(sArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack() {
        return new NonBlockingStack();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        NonBlockingStack<ELEMENTTYPE> nonBlockingStack = new NonBlockingStack<ELEMENTTYPE>();
        nonBlockingStack.push(ELEMENTTYPE);
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return new NonBlockingStack<ELEMENTTYPE>(ELEMENTTYPEArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return new NonBlockingStack<ELEMENTTYPE>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue() {
        return new PriorityQueue(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nonnull ELEMENTTYPE ELEMENTTYPE) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = new PriorityQueue<ELEMENTTYPE>(1);
        priorityQueue.add(ELEMENTTYPE);
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return new PriorityQueue(0);
        }
        PriorityQueue priorityQueue = new PriorityQueue(ELEMENTTYPEArray.length);
        Collections.addAll(priorityQueue, ELEMENTTYPEArray);
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = new PriorityQueue<ELEMENTTYPE>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                priorityQueue.add(enumeration.nextElement());
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = new PriorityQueue<ELEMENTTYPE>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                priorityQueue.add(iterator.next());
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = new PriorityQueue<ELEMENTTYPE>();
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                priorityQueue.add(ELEMENTTYPE);
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return new PriorityQueue(0);
        }
        return new PriorityQueue<ELEMENTTYPE>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return new PriorityQueue(0);
        }
        return ContainerHelper.newQueue(iIterableIterator.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(iIterableIterator));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(iIterableIterator), comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(iterator));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSorted(@Nullable Iterator<? extends ELEMENTTYPE> iterator, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(iterator), comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(iterable));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSorted(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(iterable), comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(collection));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSorted(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(collection), comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(ELEMENTTYPEArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSorted(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(ELEMENTTYPEArray), comparator);
    }

    @Nullable
    @ReturnsMutableObject(reason="design")
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSortedInline(@Nullable List<ELEMENTTYPE> list) {
        if (ContainerHelper.isNotEmpty(list)) {
            Collections.sort(list);
        }
        return list;
    }

    @Nullable
    @ReturnsMutableObject(reason="design")
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSortedInline(@Nullable List<ELEMENTTYPE> list, @Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        ValueEnforcer.notNull(comparator, "Comparator");
        if (ContainerHelper.isNotEmpty(list)) {
            Collections.sort(list, comparator);
        }
        return list;
    }

    @Nullable
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> Map<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return ContainerHelper.getSortedByKey(map, ESortOrder.DEFAULT);
    }

    @Nullable
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> Map<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull ESortOrder eSortOrder) {
        if (ContainerHelper.isEmpty(map)) {
            return map;
        }
        List<Map.Entry<KEYTYPE, VALUETYPE>> list = ContainerHelper.newList(map.entrySet());
        Collections.sort(list, ComparatorUtils.getComparatorMapEntryKey(eSortOrder));
        return ContainerHelper.newOrderedMap(list);
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Comparator<? super KEYTYPE> comparator) {
        ValueEnforcer.notNull(comparator, "KeyComparator");
        if (ContainerHelper.isEmpty(map)) {
            return map;
        }
        List<Map.Entry<KEYTYPE, VALUETYPE>> list = ContainerHelper.newList(map.entrySet());
        Collections.sort(list, ComparatorUtils.getComparatorMapEntryKey(comparator));
        return ContainerHelper.newOrderedMap(list);
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> Map<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return ContainerHelper.getSortedByValue(map, ESortOrder.DEFAULT);
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> Map<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull ESortOrder eSortOrder) {
        if (ContainerHelper.isEmpty(map)) {
            return map;
        }
        List<Map.Entry<KEYTYPE, VALUETYPE>> list = ContainerHelper.newList(map.entrySet());
        Collections.sort(list, ComparatorUtils.getComparatorMapEntryValue(eSortOrder));
        return ContainerHelper.newOrderedMap(list);
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map, @Nonnull Comparator<? super VALUETYPE> comparator) {
        ValueEnforcer.notNull(comparator, "ValueComparator");
        if (ContainerHelper.isEmpty(map)) {
            return map;
        }
        List<Map.Entry<KEYTYPE, VALUETYPE>> list = ContainerHelper.newList(map.entrySet());
        Collections.sort(list, ComparatorUtils.getComparatorMapEntryValue(comparator));
        return ContainerHelper.newOrderedMap(list);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getReverseList(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return new ArrayList(0);
        }
        ArrayList<? extends ELEMENTTYPE> arrayList = new ArrayList<ELEMENTTYPE>(collection);
        Collections.reverse(arrayList);
        return arrayList;
    }

    @Nullable
    @ReturnsMutableObject(reason="semantics of this method")
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getReverseInlineList(@Nullable List<ELEMENTTYPE> list) {
        if (list == null) {
            return null;
        }
        Collections.reverse(list);
        return list;
    }

    @Nonnull
    public static <ELEMENTTYPE> IIterableIterator<ELEMENTTYPE> getIterator(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        return new IterableIteratorFromEnumeration<ELEMENTTYPE>(enumeration);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(@Nullable Iterable<ELEMENTTYPE> iterable) {
        return iterable == null ? EmptyIterator.getInstance() : ContainerHelper.getIterator(iterable.iterator());
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(@Nullable Iterator<ELEMENTTYPE> iterator) {
        return iterator == null ? EmptyIterator.getInstance() : iterator;
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ArrayHelper.isEmpty(ELEMENTTYPEArray) ? EmptyIterator.getInstance() : ContainerHelper.getIterator(ContainerHelper.newList(ELEMENTTYPEArray).iterator());
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getReverseIterator(@Nullable List<? extends ELEMENTTYPE> list) {
        if (ContainerHelper.isEmpty(list)) {
            return EmptyIterator.getInstance();
        }
        return ReverseListIterator.create(list);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getEmptyIterator() {
        return EmptyIterator.getInstance();
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getCombinedIterator(@Nullable Iterator<? extends ELEMENTTYPE> iterator, @Nullable Iterator<? extends ELEMENTTYPE> iterator2) {
        return new CombinedIterator<ELEMENTTYPE>(iterator, iterator2);
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(@Nullable Iterable<ELEMENTTYPE> iterable) {
        return ContainerHelper.isEmpty(iterable) ? EmptyEnumeration.getInstance() : ContainerHelper.getEnumeration(iterable.iterator());
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ContainerHelper.getEnumeration(ContainerHelper.getIterator(ELEMENTTYPEArray));
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(@Nullable Iterator<ELEMENTTYPE> iterator) {
        if (iterator == null) {
            return EmptyEnumeration.getInstance();
        }
        return new EnumerationFromIterator<ELEMENTTYPE>(iterator);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Enumeration<Map.Entry<KEYTYPE, VALUETYPE>> getEnumeration(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        if (map == null) {
            return EmptyEnumeration.getInstance();
        }
        return ContainerHelper.getEnumeration(map.entrySet());
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getCombinedEnumeration(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration, @Nullable Enumeration<? extends ELEMENTTYPE> enumeration2) {
        return new CombinedEnumeration<ELEMENTTYPE>(enumeration, enumeration2);
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEmptyEnumeration() {
        return EmptyEnumeration.getInstance();
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> getStackCopyWithoutTop(@Nullable NonBlockingStack<ELEMENTTYPE> nonBlockingStack) {
        if (ContainerHelper.isEmpty(nonBlockingStack)) {
            return null;
        }
        NonBlockingStack<ELEMENTTYPE> nonBlockingStack2 = new NonBlockingStack<ELEMENTTYPE>(nonBlockingStack);
        nonBlockingStack2.pop();
        return nonBlockingStack2;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <KEY, VALUE> Map<KEY, VALUE> getFilteredMap(@Nullable Map<KEY, VALUE> map, @Nullable Collection<KEY> collection) {
        if (ContainerHelper.isEmpty(map) || ContainerHelper.isEmpty(collection)) {
            return null;
        }
        HashMap<KEY, VALUE> hashMap = new HashMap<KEY, VALUE>();
        for (KEY KEY : collection) {
            if (!map.containsKey(KEY)) continue;
            hashMap.put(KEY, map.get(KEY));
        }
        return hashMap;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable List<ELEMENTTYPE> list) {
        return ContainerHelper.isEmpty(list) ? null : (ELEMENTTYPE)list.get(0);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable SortedSet<ELEMENTTYPE> sortedSet) {
        return ContainerHelper.isEmpty(sortedSet) ? null : (ELEMENTTYPE)sortedSet.first();
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable Collection<ELEMENTTYPE> collection) {
        return ContainerHelper.isEmpty(collection) ? null : (ELEMENTTYPE)collection.iterator().next();
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable Iterable<ELEMENTTYPE> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<ELEMENTTYPE> iterator = iterable.iterator();
        return iterator.hasNext() ? (ELEMENTTYPE)iterator.next() : null;
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> Map.Entry<KEYTYPE, VALUETYPE> getFirstElement(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return ContainerHelper.isEmpty(map) ? null : map.entrySet().iterator().next();
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> KEYTYPE getFirstKey(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return ContainerHelper.isEmpty(map) ? null : (KEYTYPE)map.keySet().iterator().next();
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> KEYTYPE getFirstKey(@Nullable SortedMap<KEYTYPE, VALUETYPE> sortedMap) {
        return ContainerHelper.isEmpty(sortedMap) ? null : (KEYTYPE)sortedMap.firstKey();
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> VALUETYPE getFirstValue(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return ContainerHelper.isEmpty(map) ? null : (VALUETYPE)map.values().iterator().next();
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> VALUETYPE getFirstValue(@Nullable SortedMap<KEYTYPE, VALUETYPE> sortedMap) {
        KEYTYPE KEYTYPE = ContainerHelper.getFirstKey(sortedMap);
        return KEYTYPE == null ? null : (VALUETYPE)sortedMap.get(KEYTYPE);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE removeFirstElement(@Nullable List<ELEMENTTYPE> list) {
        return ContainerHelper.isEmpty(list) ? null : (ELEMENTTYPE)list.remove(0);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable List<ELEMENTTYPE> list) {
        int n = ContainerHelper.getSize(list);
        return n == 0 ? null : (ELEMENTTYPE)list.get(n - 1);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable SortedSet<ELEMENTTYPE> sortedSet) {
        return ContainerHelper.isEmpty(sortedSet) ? null : (ELEMENTTYPE)sortedSet.last();
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable Collection<ELEMENTTYPE> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            return null;
        }
        ELEMENTTYPE ELEMENTTYPE = null;
        for (ELEMENTTYPE ELEMENTTYPE2 : collection) {
            ELEMENTTYPE = ELEMENTTYPE2;
        }
        return ELEMENTTYPE;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable Iterable<ELEMENTTYPE> iterable) {
        if (iterable == null) {
            return null;
        }
        ELEMENTTYPE ELEMENTTYPE = null;
        for (ELEMENTTYPE ELEMENTTYPE2 : iterable) {
            ELEMENTTYPE = ELEMENTTYPE2;
        }
        return ELEMENTTYPE;
    }

    @Nonnull
    public static EChange removeElementAtIndex(@Nullable List<?> list, int n) {
        if (list == null || n < 0 || n >= list.size()) {
            return EChange.UNCHANGED;
        }
        list.remove(n);
        return EChange.CHANGED;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE removeAndReturnElementAtIndex(@Nullable List<ELEMENTTYPE> list, int n) {
        if (list == null || n < 0 || n >= list.size()) {
            return null;
        }
        return list.remove(n);
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> KEYTYPE getLastKey(@Nullable SortedMap<KEYTYPE, VALUETYPE> sortedMap) {
        return ContainerHelper.isEmpty(sortedMap) ? null : (KEYTYPE)sortedMap.lastKey();
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> VALUETYPE getLastValue(@Nullable SortedMap<KEYTYPE, VALUETYPE> sortedMap) {
        KEYTYPE KEYTYPE = ContainerHelper.getLastKey(sortedMap);
        return KEYTYPE == null ? null : (VALUETYPE)sortedMap.get(KEYTYPE);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE removeLastElement(@Nullable List<ELEMENTTYPE> list) {
        int n = ContainerHelper.getSize(list);
        return n == 0 ? null : (ELEMENTTYPE)list.remove(n - 1);
    }

    public static boolean isEmpty(@Nullable Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static boolean isEmpty(@Nullable Iterator<?> iterator) {
        return iterator == null || !iterator.hasNext();
    }

    public static boolean isEmpty(@Nullable IIterableIterator<?> iIterableIterator) {
        return iIterableIterator == null || !iIterableIterator.hasNext();
    }

    public static boolean isEmpty(@Nullable Enumeration<?> enumeration) {
        return enumeration == null || !enumeration.hasMoreElements();
    }

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Iterable<?> iterable) {
        return iterable != null && iterable.iterator().hasNext();
    }

    public static boolean isNotEmpty(@Nullable Iterator<?> iterator) {
        return iterator != null && iterator.hasNext();
    }

    public static boolean isNotEmpty(@Nullable IIterableIterator<?> iIterableIterator) {
        return iIterableIterator != null && iIterableIterator.hasNext();
    }

    public static boolean isNotEmpty(@Nullable Enumeration<?> enumeration) {
        return enumeration != null && enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(@Nullable Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    @Nonnegative
    public static int getSize(@Nullable Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    @Nonnegative
    public static int getSize(@Nullable Map<?, ?> map) {
        return map == null ? 0 : map.size();
    }

    @Nonnegative
    public static int getSize(@Nullable Iterable<?> iterable) {
        return iterable == null ? 0 : ContainerHelper.getSize(iterable.iterator());
    }

    @Nonnegative
    public static int getSize(@Nullable IIterableIterator<?> iIterableIterator) {
        return iIterableIterator == null ? 0 : ContainerHelper.getSize(iIterableIterator.iterator());
    }

    @Nonnegative
    public static int getSize(@Nullable Iterator<?> iterator) {
        int n = 0;
        if (iterator != null) {
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static int getSize(@Nullable Enumeration<?> enumeration) {
        int n = 0;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
        }
        return n;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getConcatenatedList(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        int n = ContainerHelper.getSize(collection);
        if (n == 0) {
            return ContainerHelper.newList(collection2);
        }
        int n2 = ContainerHelper.getSize(collection2);
        if (n2 == 0) {
            return ContainerHelper.newList(collection);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n + n2);
        arrayList.addAll(collection);
        arrayList.addAll(collection2);
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getConcatenatedList(@Nullable Collection<? extends ELEMENTTYPE> collection, ELEMENTTYPE ... ELEMENTTYPEArray) {
        int n = ContainerHelper.getSize(collection);
        if (n == 0) {
            return ContainerHelper.newList(ELEMENTTYPEArray);
        }
        int n2 = ArrayHelper.getSize(ELEMENTTYPEArray);
        if (n2 == 0) {
            return ContainerHelper.newList(collection);
        }
        ArrayList<? extends ELEMENTTYPE> arrayList = new ArrayList<ELEMENTTYPE>(n + n2);
        arrayList.addAll(collection);
        Collections.addAll(arrayList, ELEMENTTYPEArray);
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getConcatenatedList(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Collection<? extends ELEMENTTYPE> collection) {
        int n = ArrayHelper.getSize(ELEMENTTYPEArray);
        if (n == 0) {
            return ContainerHelper.newList(collection);
        }
        int n2 = ContainerHelper.getSize(collection);
        if (n2 == 0) {
            return ContainerHelper.newList(ELEMENTTYPEArray);
        }
        ArrayList<? extends ELEMENTTYPE> arrayList = new ArrayList<ELEMENTTYPE>(n + n2);
        Collections.addAll(arrayList, ELEMENTTYPEArray);
        arrayList.addAll(collection);
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> getConcatenatedSet(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable Collection<? extends ELEMENTTYPE> collection2) {
        int n = ContainerHelper.getSize(collection);
        if (n == 0) {
            return ContainerHelper.newSet(collection2);
        }
        int n2 = ContainerHelper.getSize(collection2);
        if (n2 == 0) {
            return ContainerHelper.newSet(collection);
        }
        HashSet<Object> hashSet = new HashSet<Object>(n + n2);
        hashSet.addAll(collection);
        hashSet.addAll(collection2);
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> getConcatenatedSet(@Nullable Collection<? extends ELEMENTTYPE> collection, ELEMENTTYPE ... ELEMENTTYPEArray) {
        int n = ContainerHelper.getSize(collection);
        if (n == 0) {
            return ContainerHelper.newSet(ELEMENTTYPEArray);
        }
        int n2 = ArrayHelper.getSize(ELEMENTTYPEArray);
        if (n2 == 0) {
            return ContainerHelper.newSet(collection);
        }
        HashSet<? extends ELEMENTTYPE> hashSet = new HashSet<ELEMENTTYPE>(n + n2);
        hashSet.addAll(collection);
        Collections.addAll(hashSet, ELEMENTTYPEArray);
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> getConcatenatedSet(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Collection<? extends ELEMENTTYPE> collection) {
        int n = ArrayHelper.getSize(ELEMENTTYPEArray);
        if (n == 0) {
            return ContainerHelper.newSet(collection);
        }
        int n2 = ContainerHelper.getSize(collection);
        if (n2 == 0) {
            return ContainerHelper.newSet(ELEMENTTYPEArray);
        }
        HashSet<? extends ELEMENTTYPE> hashSet = new HashSet<ELEMENTTYPE>(n + n2);
        Collections.addAll(hashSet, ELEMENTTYPEArray);
        hashSet.addAll(collection);
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableObject(reason="design")
    public static <ELEMENTTYPE, COLLTYPE extends Collection<? super ELEMENTTYPE>> COLLTYPE getConcatenatedInline(@Nonnull COLLTYPE COLLTYPE, ELEMENTTYPE ... ELEMENTTYPEArray) {
        ValueEnforcer.notNull(COLLTYPE, "Container");
        if (ELEMENTTYPEArray != null) {
            Collections.addAll(COLLTYPE, ELEMENTTYPEArray);
        }
        return COLLTYPE;
    }

    @Nonnull
    @ReturnsMutableObject(reason="design")
    public static <ELEMENTTYPE, COLLTYPE extends Collection<? super ELEMENTTYPE>> COLLTYPE getConcatenatedInline(@Nonnull COLLTYPE COLLTYPE, @Nullable Collection<? extends ELEMENTTYPE> collection) {
        ValueEnforcer.notNull(COLLTYPE, "Container");
        if (collection != null) {
            COLLTYPE.addAll(collection);
        }
        return COLLTYPE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEY, VALUE> Map<KEY, VALUE> getCombinedMap(@Nullable Map<KEY, VALUE> map, @Nullable Map<KEY, VALUE> map2) {
        if (ContainerHelper.isEmpty(map)) {
            return ContainerHelper.newMap(map2);
        }
        if (ContainerHelper.isEmpty(map2)) {
            return ContainerHelper.newMap(map);
        }
        HashMap<KEY, VALUE> hashMap = new HashMap<KEY, VALUE>(map);
        hashMap.putAll(map2);
        return hashMap;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Boolean> newObjectListFromArray(@Nullable boolean[] blArray) {
        if (ArrayHelper.isEmpty(blArray)) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(blArray.length);
        for (boolean bl : blArray) {
            arrayList.add(bl);
        }
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Byte> newObjectListFromArray(@Nullable byte[] byArray) {
        if (ArrayHelper.isEmpty(byArray)) {
            return null;
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
        for (byte by : byArray) {
            arrayList.add(by);
        }
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Character> newObjectListFromArray(@Nullable char[] cArray) {
        if (ArrayHelper.isEmpty(cArray)) {
            return null;
        }
        ArrayList<Character> arrayList = new ArrayList<Character>(cArray.length);
        for (char c : cArray) {
            arrayList.add(Character.valueOf(c));
        }
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Double> newObjectListFromArray(@Nullable double[] dArray) {
        if (ArrayHelper.isEmpty(dArray)) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
        for (double d : dArray) {
            arrayList.add(d);
        }
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Float> newObjectListFromArray(@Nullable float[] fArray) {
        if (ArrayHelper.isEmpty(fArray)) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
        for (float f : fArray) {
            arrayList.add(Float.valueOf(f));
        }
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Integer> newObjectListFromArray(@Nullable int[] nArray) {
        if (ArrayHelper.isEmpty(nArray)) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int n : nArray) {
            arrayList.add(n);
        }
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Long> newObjectListFromArray(@Nullable long[] lArray) {
        if (ArrayHelper.isEmpty(lArray)) {
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(lArray.length);
        for (long l : lArray) {
            arrayList.add(l);
        }
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Short> newObjectListFromArray(@Nullable short[] sArray) {
        if (ArrayHelper.isEmpty(sArray)) {
            return null;
        }
        ArrayList<Short> arrayList = new ArrayList<Short>(sArray.length);
        for (short s : sArray) {
            arrayList.add(s);
        }
        return arrayList;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<?> newObjectListFromArray(@Nullable Object object, @Nonnull Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return ContainerHelper.newObjectListFromArray((boolean[])object);
        }
        if (clazz == Byte.TYPE) {
            return ContainerHelper.newObjectListFromArray((byte[])object);
        }
        if (clazz == Character.TYPE) {
            return ContainerHelper.newObjectListFromArray((char[])object);
        }
        if (clazz == Double.TYPE) {
            return ContainerHelper.newObjectListFromArray((double[])object);
        }
        if (clazz == Float.TYPE) {
            return ContainerHelper.newObjectListFromArray((float[])object);
        }
        if (clazz == Integer.TYPE) {
            return ContainerHelper.newObjectListFromArray((int[])object);
        }
        if (clazz == Long.TYPE) {
            return ContainerHelper.newObjectListFromArray((long[])object);
        }
        if (clazz == Short.TYPE) {
            return ContainerHelper.newObjectListFromArray((short[])object);
        }
        Object[] objectArray = (Object[])object;
        if (ArrayHelper.isEmpty(objectArray)) {
            return null;
        }
        ArrayList arrayList = new ArrayList(objectArray.length);
        Collections.addAll(arrayList, objectArray);
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSubList(@Nullable List<ELEMENTTYPE> list, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGE0(n, "StartIndex");
        ValueEnforcer.isGE0(n2, "SectionLength");
        int n3 = ContainerHelper.getSize(list);
        if (n3 == 0) {
            return new ArrayList(0);
        }
        if (n >= n3) {
            return new ArrayList(0);
        }
        int n4 = n + n2;
        if (n4 > n3) {
            n4 = n3;
        }
        return ContainerHelper.newList(list.subList(n, n4));
    }

    @Nullable
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<VALUETYPE, KEYTYPE> getSwappedKeyValues(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        if (ContainerHelper.isEmpty(map)) {
            return null;
        }
        HashMap<VALUETYPE, KEYTYPE> hashMap = new HashMap<VALUETYPE, KEYTYPE>(map.size());
        for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> IMultiMapSetBased<VALUETYPE, KEYTYPE> getReverseLookupSet(@Nullable IMultiMap<KEYTYPE, VALUETYPE, ? extends Collection<VALUETYPE>> iMultiMap) {
        if (ContainerHelper.isEmpty(iMultiMap)) {
            return null;
        }
        MultiHashMapHashSetBased multiHashMapHashSetBased = new MultiHashMapHashSetBased();
        for (Map.Entry entry : iMultiMap.entrySet()) {
            for (Object e : (Collection)entry.getValue()) {
                multiHashMapHashSetBased.putSingle(e, entry.getKey());
            }
        }
        return multiHashMapHashSetBased;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> IMultiMapSetBased<VALUETYPE, KEYTYPE> getReverseLookup(@Nullable IMultiMapSetBased<KEYTYPE, VALUETYPE> iMultiMapSetBased) {
        if (ContainerHelper.isEmpty(iMultiMapSetBased)) {
            return null;
        }
        MultiHashMapHashSetBased multiHashMapHashSetBased = new MultiHashMapHashSetBased();
        for (Map.Entry entry : iMultiMapSetBased.entrySet()) {
            for (Object e : (Set)entry.getValue()) {
                multiHashMapHashSetBased.putSingle(e, entry.getKey());
            }
        }
        return multiHashMapHashSetBased;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getSafe(@Nullable List<ELEMENTTYPE> list, int n) {
        return ContainerHelper.getSafe(list, n, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getSafe(@Nullable List<ELEMENTTYPE> list, int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return list != null && n >= 0 && n < list.size() ? list.get(n) : ELEMENTTYPE;
    }

    public static boolean containsAnyNullElement(@Nullable Iterable<?> iterable) {
        if (iterable != null) {
            for (Object obj : iterable) {
                if (obj != null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnlyNullElements(@Nullable Iterable<?> iterable) {
        if (ContainerHelper.isEmpty(iterable)) {
            return false;
        }
        for (Object obj : iterable) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }
}

