/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ArrayIteratorShort {
    private final short[] m_aArray;
    private int m_nIndex;

    public ArrayIteratorShort(short ... sArray) {
        ValueEnforcer.notNull(sArray, "Array");
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(sArray);
    }

    private ArrayIteratorShort(@Nonnull short[] sArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(sArray, n, n2);
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(sArray, n, n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public short next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    @Deprecated
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayIteratorShort)) {
            return false;
        }
        ArrayIteratorShort arrayIteratorShort = (ArrayIteratorShort)object;
        return EqualsUtils.equals(this.m_aArray, arrayIteratorShort.m_aArray) && this.m_nIndex == arrayIteratorShort.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).toString();
    }

    @Nonnull
    public static ArrayIteratorShort createOfsLen(@Nonnull short[] sArray, @Nonnegative int n, @Nonnegative int n2) {
        return new ArrayIteratorShort(sArray, n, n2);
    }

    @Nonnull
    public static ArrayIteratorShort createBeginEnd(@Nonnull short[] sArray, @Nonnegative int n, @Nonnegative int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Begin (" + n + ") must be between 0 and < end (" + n2 + ")");
        }
        return ArrayIteratorShort.createOfsLen(sArray, n, n2 - n);
    }
}

