/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.file.filter.AbstractFileFilter;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FileFilterParentDirectoryPublic
extends AbstractFileFilter {
    private static final FileFilterParentDirectoryPublic s_aInstance = new FileFilterParentDirectoryPublic();

    private FileFilterParentDirectoryPublic() {
    }

    @Nonnull
    public static FileFilterParentDirectoryPublic getInstance() {
        return s_aInstance;
    }

    @Override
    public boolean accept(@Nullable File file) {
        File file2 = file != null ? file.getAbsoluteFile().getParentFile() : null;
        return file2 != null && !FilenameHelper.isHiddenFilename(file2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof FileFilterParentDirectoryPublic;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).toString();
    }
}

