/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.withid;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import com.phloc.commons.tree.withid.ITreeItemWithIDFactory;
import com.phloc.commons.tree.withid.ITreeWithID;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTreeWithID<KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>>
implements ITreeWithID<KEYTYPE, DATATYPE, ITEMTYPE> {
    private final ITEMTYPE m_aRoot;

    public BasicTreeWithID(@Nonnull ITreeItemWithIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> iTreeItemWithIDFactory) {
        ValueEnforcer.notNull(iTreeItemWithIDFactory, "Factory");
        this.m_aRoot = iTreeItemWithIDFactory.createRoot();
        if (this.m_aRoot == null) {
            throw new IllegalStateException("Failed to create root item!");
        }
        if (this.m_aRoot.getParent() != null) {
            throw new IllegalStateException("Create root item has a non-null parent!!!");
        }
    }

    @Override
    @Nonnull
    public final ITEMTYPE getRootItem() {
        return this.m_aRoot;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicTreeWithID basicTreeWithID = (BasicTreeWithID)object;
        return this.m_aRoot.equals(basicTreeWithID.m_aRoot);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aRoot).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("root", this.m_aRoot).toString();
    }
}

