/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.db.jpa.eclipselink.EclipseLinkLogger;
import com.phloc.db.jpa.eclipselink.EclipseLinkSessionCustomizer;
import com.phloc.db.jpa.utils.PersistenceXmlUtils;
import com.phloc.scopes.singleton.GlobalSingleton;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGlobalEntityManagerFactory
extends GlobalSingleton {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractGlobalEntityManagerFactory.class);
    private final String m_sPersistenceUnitName;
    private final Map<String, Object> m_aFactoryProps;
    private EntityManagerFactory m_aFactory;

    protected AbstractGlobalEntityManagerFactory(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable String string4, @Nonnull @Nonempty String string5, @Nonnull @Nonempty String string6, @Nullable Map<String, Object> map) {
        String string7;
        if (StringHelper.hasNoText((String)string)) {
            throw new NullPointerException("JdbcDriverClass");
        }
        if (StringHelper.hasNoText((String)string2)) {
            throw new IllegalArgumentException("JdbcURL");
        }
        if (StringHelper.hasNoText((String)string5)) {
            throw new NullPointerException("PlatformClass");
        }
        if (StringHelper.hasNoText((String)string6)) {
            throw new IllegalArgumentException("PersistenceUnitName");
        }
        s_aLogger.info("Using JDBC URL " + string2 + " with JDBC driver " + string + " and user '" + string3 + "'");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("javax.persistence.jdbc.driver", string);
        hashMap.put("javax.persistence.jdbc.url", string2);
        hashMap.put("javax.persistence.jdbc.user", string3);
        hashMap.put("javax.persistence.jdbc.password", string4);
        hashMap.put("eclipselink.logging.logger", EclipseLinkLogger.class.getName());
        hashMap.put("eclipselink.session.customizer", EclipseLinkSessionCustomizer.class.getName());
        hashMap.put("eclipselink.target-database", string5);
        if (map != null) {
            hashMap.putAll(map);
        }
        if (hashMap.containsKey("eclipselink.ddl-generation") && !hashMap.containsKey("eclipselink.ddl-generation.output-mode") && !"none".equals(string7 = (String)hashMap.get("eclipselink.ddl-generation"))) {
            s_aLogger.warn("DDL generation is set to '" + string7 + "' but no DDL generation mode is defined, which defaults to '" + "database" + "' - defaulting to '" + "sql-script" + "'!!!");
            hashMap.put("eclipselink.ddl-generation.output-mode", "sql-script");
        }
        this.m_sPersistenceUnitName = string6;
        this.m_aFactoryProps = hashMap;
    }

    @Nonnull
    @OverrideOnDemand
    protected EntityManagerFactory customizeEntityManagerFactory(@Nonnull EntityManagerFactory entityManagerFactory) {
        return entityManagerFactory;
    }

    @OverridingMethodsMustInvokeSuper
    protected void onAfterInstantiation() {
        String string;
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)this.m_sPersistenceUnitName, this.m_aFactoryProps);
        if (entityManagerFactory == null) {
            throw new IllegalStateException("Failed to create entity manager factory for persistence unit '" + this.m_sPersistenceUnitName + "' with properties " + this.m_aFactoryProps.toString() + "!");
        }
        this.m_aFactory = this.customizeEntityManagerFactory(entityManagerFactory);
        s_aLogger.info("Created EntityManagerFactory for persistence unit '" + this.m_sPersistenceUnitName + "'");
        Map map = this.m_aFactory.getProperties();
        if (map.containsKey("eclipselink.ddl-generation") && !map.containsKey("eclipselink.ddl-generation.output-mode") && !"none".equals(string = (String)map.get("eclipselink.ddl-generation"))) {
            throw new IllegalStateException("DDL generation is set to '" + string + "' but no DDL generation mode is defined, which defaults to '" + "database" + "' which can erase all your data. Please explicitly state a value for the property '" + "eclipselink.ddl-generation.output-mode" + "'!!!\nEffective properties are: " + map.toString());
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void onDestroy() throws Exception {
        if (this.m_aFactory != null) {
            if (this.m_aFactory.isOpen()) {
                this.m_aFactory.getCache().evictAll();
                this.m_aFactory.close();
            }
            this.m_aFactory = null;
        }
        s_aLogger.info("Closed EntityManagerFactory for persistence unit '" + this.m_sPersistenceUnitName + "'");
    }

    @Nonnull
    @Nonempty
    public final String getPersistenceUnitName() {
        return this.m_sPersistenceUnitName;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final Map<String, Object> getAllFactoryProperties() {
        return ContainerHelper.newMap(this.m_aFactoryProps);
    }

    @Nonnull
    public final EntityManagerFactory getEntityManagerFactory() {
        if (this.m_aFactory == null) {
            throw new IllegalStateException("No EntityManagerFactory present!");
        }
        return this.m_aFactory;
    }

    @Nonnull
    public final EntityManager createEntityManager() {
        return this.createEntityManager(null);
    }

    @Nonnull
    public EntityManager createEntityManager(Map map) {
        EntityManager entityManager = this.getEntityManagerFactory().createEntityManager(map);
        if (entityManager == null) {
            throw new IllegalStateException("Failed to create EntityManager from factory " + this.m_aFactory + " with parameters " + map + "!");
        }
        return entityManager;
    }

    static {
        PersistenceXmlUtils.checkPersistenceXMLValidity();
    }
}

