/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa;

import com.phloc.commons.annotations.IsLocked;
import com.phloc.commons.annotations.UsedViaReflection;
import com.phloc.scopes.singleton.RequestSingleton;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractPerRequestEntityManager
extends RequestSingleton {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractPerRequestEntityManager.class);
    protected final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private volatile EntityManager m_aEntityManager;
    private boolean m_bDestroyed = false;

    @Deprecated
    @UsedViaReflection
    public AbstractPerRequestEntityManager() {
    }

    @Nonnull
    @IsLocked(value=IsLocked.ELockType.WRITE)
    protected abstract EntityManager createEntityManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EntityManager getEntityManager() {
        EntityManager entityManager;
        this.m_aRWLock.readLock().lock();
        try {
            if (this.m_bDestroyed) {
                throw new IllegalStateException("This object was already destroyed and should not be re-used!");
            }
            entityManager = this.m_aEntityManager;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        if (entityManager == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                entityManager = this.m_aEntityManager;
                if (entityManager == null) {
                    entityManager = this.createEntityManager();
                    if (entityManager == null) {
                        throw new IllegalStateException("Failed to create EntityManager!");
                    }
                    this.m_aEntityManager = entityManager;
                    if (s_aLogger.isDebugEnabled()) {
                        s_aLogger.debug("EntityManager created");
                    }
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        return entityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OverridingMethodsMustInvokeSuper
    protected void onDestroy() {
        this.m_aRWLock.writeLock().lock();
        try {
            EntityManager entityManager = this.m_aEntityManager;
            if (entityManager != null) {
                entityManager.close();
                this.m_aEntityManager = null;
                if (s_aLogger.isDebugEnabled()) {
                    s_aLogger.debug("EntityManager destroyed");
                }
            }
            this.m_bDestroyed = true;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }
}

