/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa;

import com.phloc.commons.callback.AdapterRunnableToCallable;
import com.phloc.commons.callback.AdapterThrowingRunnableToCallable;
import com.phloc.commons.callback.IExceptionHandler;
import com.phloc.commons.callback.IThrowingRunnable;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.timing.StopWatch;
import com.phloc.db.jpa.IEntityManagerProvider;
import com.phloc.db.jpa.JPAExecutionResult;
import com.phloc.db.jpa.callback.IExecutionTimeExceededHandler;
import com.phloc.db.jpa.callback.LoggingExecutionTimeExceededHandler;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.ThreadSafe;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class JPAEnabledManager {
    public static final boolean DEFAULT_SYNC_ENTITY_MGR = false;
    public static final boolean DEFAULT_ALLOW_NESTED_TRANSACTIONS = false;
    public static final boolean DEFAULT_USE_TRANSACTIONS_FOR_SELECT = false;
    public static final int DEFAULT_EXECUTION_WARN_TIME_MS = 1000;
    private static final Logger s_aLogger = LoggerFactory.getLogger(JPAEnabledManager.class);
    private static final IStatisticsHandlerCounter s_aStatsCounterTransactions = StatisticsManager.getCounterHandler((String)(JPAEnabledManager.class.getName() + "$transactions"));
    private static final IStatisticsHandlerCounter s_aStatsCounterRollback = StatisticsManager.getCounterHandler((String)(JPAEnabledManager.class.getName() + "$rollback"));
    private static final IStatisticsHandlerCounter s_aStatsCounterSuccess = StatisticsManager.getCounterHandler((String)(JPAEnabledManager.class.getName() + "$success"));
    private static final IStatisticsHandlerCounter s_aStatsCounterError = StatisticsManager.getCounterHandler((String)(JPAEnabledManager.class.getName() + "$error"));
    private static final IStatisticsHandlerTimer s_aStatsTimerExecutionSuccess = StatisticsManager.getTimerHandler((String)(JPAEnabledManager.class.getName() + "$execSuccess"));
    private static final IStatisticsHandlerTimer s_aStatsTimerExecutionError = StatisticsManager.getTimerHandler((String)(JPAEnabledManager.class.getName() + "$execError"));
    protected static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static IExceptionHandler<Throwable> s_aExceptionHandler;
    private static final AtomicInteger s_aExecutionWarnTime;
    private static IExecutionTimeExceededHandler s_aExecutionTimeExceededHandler;
    private final IEntityManagerProvider m_aEntityManagerProvider;
    private final AtomicBoolean m_aSyncEntityMgr = new AtomicBoolean(false);
    private final AtomicBoolean m_aAllowNestedTransactions = new AtomicBoolean(false);
    private final AtomicBoolean m_aUseTransactionsForSelect = new AtomicBoolean(false);

    public JPAEnabledManager(@Nonnull IEntityManagerProvider iEntityManagerProvider) {
        if (iEntityManagerProvider == null) {
            throw new NullPointerException("EntityManagerProvider");
        }
        this.m_aEntityManagerProvider = iEntityManagerProvider;
    }

    public final boolean isSyncEntityMgr() {
        return this.m_aSyncEntityMgr.get();
    }

    public final void setSyncEntityMgr(boolean bl) {
        this.m_aSyncEntityMgr.set(bl);
    }

    public final boolean isAllowNestedTransactions() {
        return this.m_aAllowNestedTransactions.get();
    }

    public final void setAllowNestedTransactions(boolean bl) {
        this.m_aAllowNestedTransactions.set(bl);
    }

    public final boolean isUseTransactionsForSelect() {
        return this.m_aUseTransactionsForSelect.get();
    }

    public final void setUseTransactionsForSelect(boolean bl) {
        this.m_aAllowNestedTransactions.set(bl);
    }

    @Nonnull
    protected final EntityManager getEntityManager() {
        return this.m_aEntityManagerProvider.getEntityManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setCustomExceptionHandler(@Nullable IExceptionHandler<Throwable> iExceptionHandler) {
        s_aRWLock.writeLock().lock();
        try {
            s_aExceptionHandler = iExceptionHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final IExceptionHandler<Throwable> getCustomExceptionHandler() {
        s_aRWLock.readLock().lock();
        try {
            IExceptionHandler<Throwable> iExceptionHandler = s_aExceptionHandler;
            return iExceptionHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    private static void _invokeCustomExceptionHandler(@Nonnull Throwable throwable) {
        IExceptionHandler<Throwable> iExceptionHandler = JPAEnabledManager.getCustomExceptionHandler();
        if (iExceptionHandler == null) {
            s_aLogger.error("Failed to perform something in a JPAEnabledManager!", throwable);
        } else {
            try {
                iExceptionHandler.onException(throwable);
            }
            catch (Throwable throwable2) {
                s_aLogger.error("Error in JPAEnabledManager custom exception handler " + iExceptionHandler, throwable2);
            }
        }
    }

    @Nonnegative
    public static final int getDefaultExecutionWarnTime() {
        return s_aExecutionWarnTime.get();
    }

    public static final void setDefaultExecutionWarnTime(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Milliseconds may not be negative: " + n);
        }
        s_aExecutionWarnTime.set(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setExecutionTimeExceededHandler(@Nullable IExecutionTimeExceededHandler iExecutionTimeExceededHandler) {
        s_aRWLock.writeLock().lock();
        try {
            s_aExecutionTimeExceededHandler = iExecutionTimeExceededHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final IExecutionTimeExceededHandler getExecutionTimeExceededHandler() {
        s_aRWLock.readLock().lock();
        try {
            IExecutionTimeExceededHandler iExecutionTimeExceededHandler = s_aExecutionTimeExceededHandler;
            return iExecutionTimeExceededHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static final void onExecutionTimeExceeded(@Nonnull String string, @Nonnegative long l) {
        IExecutionTimeExceededHandler iExecutionTimeExceededHandler = JPAEnabledManager.getExecutionTimeExceededHandler();
        if (iExecutionTimeExceededHandler != null) {
            try {
                iExecutionTimeExceededHandler.onExecutionTimeExceeded(string, l);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke exceution time exceeded handler " + iExecutionTimeExceededHandler, throwable);
            }
        }
    }

    @Nonnull
    public static final JPAExecutionResult<?> doInTransaction(@Nonnull @WillNotClose EntityManager entityManager, boolean bl, @Nonnull Runnable runnable) {
        return JPAEnabledManager.doInTransaction(entityManager, bl, AdapterRunnableToCallable.createAdapter((Runnable)runnable));
    }

    @Nonnull
    public static final JPAExecutionResult<?> doInTransaction(@Nonnull @WillNotClose EntityManager entityManager, boolean bl, @Nonnull IThrowingRunnable iThrowingRunnable) {
        return JPAEnabledManager.doInTransaction(entityManager, bl, AdapterThrowingRunnableToCallable.createAdapter((IThrowingRunnable)iThrowingRunnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public final JPAExecutionResult<?> doInTransaction(@Nonnull IThrowingRunnable iThrowingRunnable) {
        EntityManager entityManager = this.getEntityManager();
        if (!this.isSyncEntityMgr()) {
            return JPAEnabledManager.doInTransaction(entityManager, this.isAllowNestedTransactions(), iThrowingRunnable);
        }
        EntityManager entityManager2 = entityManager;
        synchronized (entityManager2) {
            return JPAEnabledManager.doInTransaction(entityManager, this.isAllowNestedTransactions(), iThrowingRunnable);
        }
    }

    @Nonnull
    public final JPAExecutionResult<?> doInTransaction(final @Nonnull Runnable runnable) {
        return this.doInTransaction(new IThrowingRunnable(){

            public void run() throws Exception {
                runnable.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final <T> JPAExecutionResult<T> doInTransaction(@Nonnull @WillNotClose EntityManager entityManager, boolean bl, @Nonnull Callable<T> callable) {
        boolean bl2;
        StopWatch stopWatch = new StopWatch(true);
        EntityTransaction entityTransaction = entityManager.getTransaction();
        boolean bl3 = bl2 = !bl || !entityTransaction.isActive();
        if (bl2) {
            s_aStatsCounterTransactions.increment();
            entityTransaction.begin();
        }
        try {
            T t = callable.call();
            if (bl2) {
                entityTransaction.commit();
            }
            s_aStatsCounterSuccess.increment();
            s_aStatsTimerExecutionSuccess.addTime(stopWatch.stopAndGetMillis());
            JPAExecutionResult<T> jPAExecutionResult = JPAExecutionResult.createSuccess(t);
            return jPAExecutionResult;
        }
        catch (Throwable throwable) {
            s_aStatsCounterError.increment();
            s_aStatsTimerExecutionError.addTime(stopWatch.stopAndGetMillis());
            JPAEnabledManager._invokeCustomExceptionHandler(throwable);
            JPAExecutionResult jPAExecutionResult = JPAExecutionResult.createFailure(throwable);
            return jPAExecutionResult;
        }
        finally {
            if (bl2 && entityTransaction.isActive()) {
                entityTransaction.rollback();
                s_aLogger.warn("Rolled back transaction for callable " + callable);
                s_aStatsCounterRollback.increment();
            }
            if (stopWatch.getMillis() > (long)JPAEnabledManager.getDefaultExecutionWarnTime()) {
                JPAEnabledManager.onExecutionTimeExceeded("Callback: " + stopWatch.getMillis() + " ms; transaction: " + bl2 + "; Execution of callable in transaction took too long: " + callable.toString(), stopWatch.getMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public final <T> JPAExecutionResult<T> doInTransaction(@Nonnull Callable<T> callable) {
        EntityManager entityManager = this.getEntityManager();
        if (!this.isSyncEntityMgr()) {
            return JPAEnabledManager.doInTransaction(entityManager, this.isAllowNestedTransactions(), callable);
        }
        EntityManager entityManager2 = entityManager;
        synchronized (entityManager2) {
            return JPAEnabledManager.doInTransaction(entityManager, this.isAllowNestedTransactions(), callable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final <T> JPAExecutionResult<T> doSelectStatic(@Nonnull Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException("callable");
        }
        StopWatch stopWatch = new StopWatch(true);
        try {
            T t = callable.call();
            s_aStatsCounterSuccess.increment();
            s_aStatsTimerExecutionSuccess.addTime(stopWatch.stopAndGetMillis());
            JPAExecutionResult<T> jPAExecutionResult = JPAExecutionResult.createSuccess(t);
            return jPAExecutionResult;
        }
        catch (Throwable throwable) {
            s_aStatsCounterError.increment();
            s_aStatsTimerExecutionError.addTime(stopWatch.stopAndGetMillis());
            JPAEnabledManager._invokeCustomExceptionHandler(throwable);
            JPAExecutionResult jPAExecutionResult = JPAExecutionResult.createFailure(throwable);
            return jPAExecutionResult;
        }
        finally {
            if (stopWatch.getMillis() > (long)JPAEnabledManager.getDefaultExecutionWarnTime()) {
                JPAEnabledManager.onExecutionTimeExceeded("Execution of select took too long: " + callable.toString(), stopWatch.getMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public final <T> JPAExecutionResult<T> doSelect(@Nonnull Callable<T> callable) {
        if (this.isUseTransactionsForSelect()) {
            return this.doInTransaction(callable);
        }
        EntityManager entityManager = this.getEntityManager();
        if (!this.isSyncEntityMgr()) {
            return JPAEnabledManager.doSelectStatic(callable);
        }
        EntityManager entityManager2 = entityManager;
        synchronized (entityManager2) {
            return JPAEnabledManager.doSelectStatic(callable);
        }
    }

    @Nonnull
    public static final Number getSelectCountResultObj(@Nonnull Query query) {
        Number number = (Number)query.getSingleResult();
        return number != null ? (Number)number : (Number)0;
    }

    @Nonnegative
    public static final long getSelectCountResult(@Nonnull Query query) {
        return JPAEnabledManager.getSelectCountResultObj(query).longValue();
    }

    static {
        s_aExecutionWarnTime = new AtomicInteger(1000);
        s_aExecutionTimeExceededHandler = new LoggingExecutionTimeExceededHandler(true);
    }
}

