/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa.callback;

import com.phloc.commons.string.ToStringGenerator;
import com.phloc.db.jpa.callback.IExecutionTimeExceededHandler;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingExecutionTimeExceededHandler
implements IExecutionTimeExceededHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingExecutionTimeExceededHandler.class);
    private final boolean m_bEmitStackTrace;

    public LoggingExecutionTimeExceededHandler(boolean bl) {
        this.m_bEmitStackTrace = bl;
    }

    public boolean isEmitStackTrace() {
        return this.m_bEmitStackTrace;
    }

    @Override
    public void onExecutionTimeExceeded(@Nonnull String string, @Nonnegative long l) {
        s_aLogger.warn(string + " took " + l + "ms", (Throwable)(this.m_bEmitStackTrace ? new Exception() : null));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("emitStackTraces", this.m_bEmitStackTrace).toString();
    }
}

