/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa.eclipselink.converter;

import com.phloc.commons.lang.CGStringHelper;
import java.sql.Timestamp;
import javax.annotation.concurrent.Immutable;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JPAJodaDurationConverter
implements Converter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(JPAJodaDurationConverter.class);

    public Timestamp convertObjectValueToDataValue(Object object, Session session) {
        return object == null ? null : new Timestamp(((Duration)object).getMillis());
    }

    public Duration convertDataValueToObjectValue(Object object, Session session) {
        if (object != null) {
            try {
                return new Duration(((Timestamp)object).getTime());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                s_aLogger.warn("Failed to convert '" + object + "' of type " + CGStringHelper.getSafeClassName((Object)object) + "to Duration!");
            }
        }
        return null;
    }

    public boolean isMutable() {
        return false;
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
        AbstractDirectMapping abstractDirectMapping;
        if (databaseMapping.isDirectToFieldMapping() && (abstractDirectMapping = (AbstractDirectMapping)databaseMapping).getFieldClassification() == null) {
            abstractDirectMapping.setFieldClassification(ClassConstants.TIMESTAMP);
        }
    }
}

