/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa.eclipselink.converter;

import com.phloc.commons.lang.CGStringHelper;
import com.phloc.datetime.PDTFactory;
import com.phloc.datetime.config.PDTConfig;
import java.sql.Date;
import javax.annotation.concurrent.Immutable;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JPAJodaLocalDateConverter
implements Converter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(JPAJodaLocalDateConverter.class);

    public Date convertObjectValueToDataValue(Object object, Session session) {
        return object == null ? null : new Date(PDTFactory.createDateTime((LocalDate)((LocalDate)object)).getMillis());
    }

    public LocalDate convertDataValueToObjectValue(Object object, Session session) {
        if (object != null) {
            try {
                return new LocalDate(object, PDTConfig.getDefaultChronology());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                s_aLogger.warn("Failed to convert '" + object + "' of type " + CGStringHelper.getSafeClassName((Object)object) + " to LocalDate!");
            }
        }
        return null;
    }

    public boolean isMutable() {
        return false;
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
        AbstractDirectMapping abstractDirectMapping;
        if (databaseMapping.isDirectToFieldMapping() && (abstractDirectMapping = (AbstractDirectMapping)databaseMapping).getFieldClassification() == null) {
            abstractDirectMapping.setFieldClassification(ClassConstants.SQLDATE);
        }
    }
}

