/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa.eclipselink.converter;

import com.phloc.commons.lang.CGStringHelper;
import com.phloc.datetime.config.PDTConfig;
import java.sql.Timestamp;
import javax.annotation.concurrent.Immutable;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JPAJodaLocalDateTimeConverter
implements Converter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(JPAJodaLocalDateTimeConverter.class);

    public Timestamp convertObjectValueToDataValue(Object object, Session session) {
        return object == null ? null : new Timestamp(((LocalDateTime)object).toDateTime().getMillis());
    }

    public LocalDateTime convertDataValueToObjectValue(Object object, Session session) {
        if (object != null) {
            try {
                return new LocalDateTime(object, PDTConfig.getDefaultChronology());
            }
            catch (RuntimeException runtimeException) {
                s_aLogger.warn("Failed to convert '" + object + "' of type " + CGStringHelper.getSafeClassName((Object)object) + " to LocalDateTime!");
            }
        }
        return null;
    }

    public boolean isMutable() {
        return false;
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
        AbstractDirectMapping abstractDirectMapping;
        if (databaseMapping.isDirectToFieldMapping() && (abstractDirectMapping = (AbstractDirectMapping)databaseMapping).getFieldClassification() == null) {
            abstractDirectMapping.setFieldClassification(ClassConstants.TIMESTAMP);
        }
    }
}

