/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa.eclipselink.converter;

import com.phloc.commons.lang.CGStringHelper;
import com.phloc.datetime.config.PDTConfig;
import java.sql.Time;
import javax.annotation.concurrent.Immutable;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JPAJodaLocalTimeConverter
implements Converter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(JPAJodaLocalTimeConverter.class);

    public Time convertObjectValueToDataValue(Object object, Session session) {
        return object == null ? null : new Time(((LocalTime)object).toDateTimeToday().getMillis());
    }

    public LocalTime convertDataValueToObjectValue(Object object, Session session) {
        if (object != null) {
            try {
                return new LocalTime(object, PDTConfig.getDefaultChronology());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                s_aLogger.warn("Failed to convert '" + object + "' of type " + CGStringHelper.getSafeClassName((Object)object) + "to LocalTime!");
            }
        }
        return null;
    }

    public boolean isMutable() {
        return false;
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
        AbstractDirectMapping abstractDirectMapping;
        if (databaseMapping.isDirectToFieldMapping() && (abstractDirectMapping = (AbstractDirectMapping)databaseMapping).getFieldClassification() == null) {
            abstractDirectMapping.setFieldClassification(ClassConstants.TIME);
        }
    }
}

