/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa.h2;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.db.api.h2.EH2LockMode;
import com.phloc.db.api.h2.EH2Log;
import com.phloc.db.jpa.IEntityManagerProvider;
import com.phloc.db.jpa.JPAEnabledManager;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class JPAEnabledManagerH2
extends JPAEnabledManager {
    private static final Logger s_aLogger = LoggerFactory.getLogger(JPAEnabledManager.class);

    public JPAEnabledManagerH2(@Nonnull IEntityManagerProvider iEntityManagerProvider) {
        super(iEntityManagerProvider);
    }

    protected final boolean isTableExisting(@Nonnull String string) {
        return JPAEnabledManagerH2.getSelectCountResultObj((Query)this.getEntityManager().createQuery("SELECT count(ID) FROM TABLES t WHERE t.TABLE_TYPE = 'TABLE' AND TABLE_NAME = :tablename", Integer.class).setParameter("tablename", (Object)string)).intValue() > 0;
    }

    private void _executeH2Native(final @Nonnull @Nonempty String string) {
        this.doInTransaction(new Runnable(){

            @Override
            public void run() {
                s_aLogger.info("Running H2 native command: " + string);
                JPAEnabledManagerH2.this.getEntityManager().createNativeQuery(string).executeUpdate();
            }
        });
    }

    public final void doH2Analyze() {
        this._executeH2Native("ANALYZE");
    }

    public final void setH2LockMode(@Nonnull EH2LockMode eH2LockMode) {
        this._executeH2Native("SET LOCK_MODE=" + eH2LockMode.getValue());
    }

    public final void setH2Log(@Nonnull EH2Log eH2Log) {
        this._executeH2Native("SET LOG=" + eH2Log.getValue());
    }

    public final void setH2UndoLog(boolean bl) {
        this._executeH2Native("SET UNDO_LOG=" + (bl ? "1" : "0"));
    }
}

