/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa.proxy;

import com.phloc.db.jpa.proxy.EntityManagerFactoryProxy;
import com.phloc.db.jpa.proxy.EntityManagerWithListener;
import com.phloc.db.jpa.proxy.IEntityManagerListener;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SynchronizationType;

public class EntityManagerFactoryWithListener
extends EntityManagerFactoryProxy
implements IEntityManagerListener {
    private static final ThreadLocal<EntityManagerWithListener> s_aTL = new ThreadLocal();

    public EntityManagerFactoryWithListener(@Nonnull EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    @Override
    public EntityManagerWithListener createEntityManager() {
        return this.createEntityManager((Map)null);
    }

    @Override
    public EntityManagerWithListener createEntityManager(@Nullable Map map) {
        EntityManagerWithListener entityManagerWithListener = s_aTL.get();
        if (entityManagerWithListener == null) {
            entityManagerWithListener = new EntityManagerWithListener(super.createEntityManager(map));
            s_aTL.set(entityManagerWithListener);
            entityManagerWithListener.setCloseListener(this);
        }
        return entityManagerWithListener;
    }

    @Override
    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.createEntityManager(synchronizationType, null);
    }

    @Override
    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        EntityManagerWithListener entityManagerWithListener = s_aTL.get();
        if (entityManagerWithListener == null) {
            entityManagerWithListener = new EntityManagerWithListener(super.createEntityManager(synchronizationType, map));
            s_aTL.set(entityManagerWithListener);
            entityManagerWithListener.setCloseListener(this);
        }
        return entityManagerWithListener;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onAfterEntityManagerClosed() {
        s_aTL.remove();
    }
}

