/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.db.jpa.utils;

import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.serialize.MicroReader;
import com.phloc.commons.string.StringHelper;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PersistenceXmlUtils {
    public static final String PATH_PERSISTENCE_XML = "META-INF/persistence.xml";
    public static final String PERSISTENCE_NAMESPACE_URI = "http://java.sun.com/xml/ns/persistence";
    private static final Logger s_aLogger = LoggerFactory.getLogger(PersistenceXmlUtils.class);

    private PersistenceXmlUtils() {
    }

    public static void checkPersistenceXMLValidity() {
        try {
            int n = 0;
            Enumeration<URL> enumeration = ClassHelper.getDefaultClassLoader().getResources(PATH_PERSISTENCE_XML);
            while (enumeration.hasMoreElements()) {
                ++n;
                URL uRL = enumeration.nextElement();
                IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)new URLResource(uRL));
                if (iMicroDocument == null || iMicroDocument.getDocumentElement() == null) {
                    throw new IllegalStateException("No XML file: " + uRL);
                }
                for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements(PERSISTENCE_NAMESPACE_URI, "persistence-unit")) {
                    for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(PERSISTENCE_NAMESPACE_URI, "class")) {
                        String string = iMicroElement2.getTextContent();
                        if (StringHelper.hasNoTextAfterTrim((String)string)) {
                            throw new IllegalStateException("Persistence file " + uRL + ": class name is missing!");
                        }
                        GenericReflection.getClassFromName((String)string.trim());
                    }
                }
            }
            s_aLogger.info("All META-INF/persistence.xml files are valid (count=" + n + ")");
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to read META-INF/persistence.xml file", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Failed to resolve class", classNotFoundException);
        }
    }
}

