/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.validator;

import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.serialize.MicroWriter;
import com.phloc.commons.xml.sax.CollectingSAXErrorHandler;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import com.phloc.schematron.CSchematron;
import com.phloc.schematron.relaxng.RelaxNGCompactSchemaCache;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.Source;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@Immutable
public final class SchematronValidator {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronValidator.class);
    private static final SchematronValidator s_aInstance = new SchematronValidator();

    private SchematronValidator() {
    }

    public static boolean isValidSchematron(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == null) {
            return false;
        }
        return SchematronValidator.isValidSchematron((Source)TransformSourceFactory.create((String)MicroWriter.getXMLString((IMicroNode)iMicroNode)));
    }

    public static boolean isValidSchematron(@Nullable Node node) {
        if (node == null) {
            return false;
        }
        return SchematronValidator.isValidSchematron(TransformSourceFactory.create((Node)node));
    }

    public static boolean isValidSchematron(@Nullable IReadableResource iReadableResource) {
        if (iReadableResource == null) {
            return false;
        }
        return SchematronValidator.isValidSchematron((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    public static boolean isValidSchematron(@Nullable Source source) {
        if (source == null) {
            return false;
        }
        try {
            CollectingSAXErrorHandler collectingSAXErrorHandler;
            Validator validator = RelaxNGCompactSchemaCache.getInstance().getValidator((IReadableResource)CSchematron.SCHEMATRON_RNC);
            ErrorHandler errorHandler = validator.getErrorHandler();
            if (errorHandler instanceof CollectingSAXErrorHandler) {
                collectingSAXErrorHandler = (CollectingSAXErrorHandler)errorHandler;
            } else {
                collectingSAXErrorHandler = new CollectingSAXErrorHandler(errorHandler);
                validator.setErrorHandler((ErrorHandler)collectingSAXErrorHandler);
            }
            validator.validate(source, null);
            return collectingSAXErrorHandler.getResourceErrors().getMostSevereErrorLevel().isLessSevereThan(EErrorLevel.ERROR);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            s_aLogger.warn("Failed to read source " + source, (Throwable)iOException);
        }
        return false;
    }
}

