/*
 * Decompiled with CFR 0.152.
 */
package chapi.app.analyser;

import chapi.app.analyser.CSharpAnalyserApp;
import chapi.app.analyser.GoAnalyserApp;
import chapi.app.analyser.JavaAnalyserApp;
import chapi.app.analyser.KotlinAnalyserApp;
import chapi.app.analyser.PythonAnalyserApp;
import chapi.app.analyser.ScalaAnalyserApp;
import chapi.app.analyser.TypeScriptAnalyserApp;
import chapi.app.analyser.config.ChapiConfig;
import chapi.app.analyser.support.BaseAnalyser;
import chapi.domain.core.CodeDataStruct;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0011"}, d2={"Lchapi/app/analyser/ChapiAnalyser;", "", "config", "Lchapi/app/analyser/config/ChapiConfig;", "(Lchapi/app/analyser/config/ChapiConfig;)V", "getConfig", "()Lchapi/app/analyser/config/ChapiConfig;", "setConfig", "analysis", "", "Lchapi/domain/core/CodeDataStruct;", "path", "", "(Ljava/lang/String;)[Lchapi/domain/core/CodeDataStruct;", "getAnalyserByLang", "Lchapi/app/analyser/support/BaseAnalyser;", "lang", "chapi-application"})
public class ChapiAnalyser {
    @NotNull
    private ChapiConfig config;

    public ChapiAnalyser(@NotNull ChapiConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public /* synthetic */ ChapiAnalyser(ChapiConfig chapiConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            chapiConfig = new ChapiConfig(null, false, null, false, 15, null);
        }
        this(chapiConfig);
    }

    @NotNull
    public final ChapiConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull ChapiConfig chapiConfig) {
        Intrinsics.checkNotNullParameter((Object)chapiConfig, (String)"<set-?>");
        this.config = chapiConfig;
    }

    @NotNull
    public CodeDataStruct[] analysis(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        BaseAnalyser appAnalyser = this.getAnalyserByLang(this.config.getLanguage());
        return appAnalyser.analysisNodeByPath(path);
    }

    @NotNull
    public BaseAnalyser getAnalyserByLang(@NotNull String lang) {
        BaseAnalyser baseAnalyser;
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        switch (lang) {
            case "java": {
                baseAnalyser = new JavaAnalyserApp(this.config);
                break;
            }
            case "go": {
                baseAnalyser = new GoAnalyserApp(this.config);
                break;
            }
            case "python": {
                baseAnalyser = new PythonAnalyserApp(this.config);
                break;
            }
            case "typescript": {
                baseAnalyser = new TypeScriptAnalyserApp(this.config);
                break;
            }
            case "scala": {
                baseAnalyser = new ScalaAnalyserApp(this.config);
                break;
            }
            case "kotlin": {
                baseAnalyser = new KotlinAnalyserApp(this.config);
                break;
            }
            case "c#": 
            case "csharp": {
                baseAnalyser = new CSharpAnalyserApp(this.config);
                break;
            }
            default: {
                baseAnalyser = new JavaAnalyserApp(this.config);
            }
        }
        return baseAnalyser;
    }

    public ChapiAnalyser() {
        this(null, 1, null);
    }
}

