/*
 * Decompiled with CFR 0.152.
 */
package chapi.app.analyser.filter;

import chapi.app.analyser.config.ChapiConfig;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lchapi/app/analyser/filter/FileFilter;", "", "()V", "Companion", "chapi-application"})
public class FileFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lchapi/app/analyser/filter/FileFilter$Companion;", "", "()V", "filterByLanguage", "", "path", "", "config", "Lchapi/app/analyser/config/ChapiConfig;", "chapi-application"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean filterByLanguage(@NotNull String path, @NotNull ChapiConfig config) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (((CharSequence)config.getFilterRule()).length() > 0) {
                return new Regex(config.getFilterRule()).matches((CharSequence)path);
            }
            if (!new File(path).isFile()) {
                return false;
            }
            switch (config.getLanguage()) {
                case "java": {
                    bl = StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null);
                    break;
                }
                case "go": {
                    bl = StringsKt.endsWith$default((String)path, (String)".go", (boolean)false, (int)2, null);
                    break;
                }
                case "python": {
                    bl = StringsKt.endsWith$default((String)path, (String)".py", (boolean)false, (int)2, null);
                    break;
                }
                case "typescript": {
                    boolean isNormalFile = StringsKt.endsWith$default((String)path, (String)".ts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".tsx", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".js", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".jsx", (boolean)false, (int)2, null);
                    boolean isNotMinFile = StringsKt.endsWith$default((String)path, (String)".min.js", (boolean)false, (int)2, null);
                    if (config.getIgnoreMinFile()) {
                        return isNormalFile && !isNotMinFile;
                    }
                    bl = isNormalFile;
                    break;
                }
                case "scala": {
                    bl = StringsKt.endsWith$default((String)path, (String)".scala", (boolean)false, (int)2, null);
                    break;
                }
                case "c#": {
                    bl = StringsKt.endsWith$default((String)path, (String)".cs", (boolean)false, (int)2, null);
                    break;
                }
                case "kotlin": {
                    if (StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kts", (boolean)false, (int)2, null)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null);
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

