/*
 * Decompiled with CFR 0.152.
 */
package chapi.app.frontend;

import chapi.app.frontend.ApiCodeCall;
import chapi.app.frontend.ContainerDemand;
import chapi.app.frontend.ContainerService;
import chapi.app.frontend.NamingKt;
import chapi.app.frontend.identify.AxiosHttpIdentify;
import chapi.app.frontend.identify.UmiHttpIdentify;
import chapi.app.frontend.path.EcmaImportPathKt;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeField;
import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodeImport;
import chapi.domain.core.CodeProperty;
import chapi.domain.core.DataStructType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J1\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0016\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00122\u0006\u0010\u001e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001fJ&\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002J;\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012H\u0002\u00a2\u0006\u0002\u0010+J\u0013\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010-R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\f\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lchapi/app/frontend/FrontendApiAnalyser;", "", "()V", "axiosIdent", "Lchapi/app/frontend/identify/AxiosHttpIdentify;", "callMap", "Ljava/util/HashMap;", "", "Lchapi/domain/core/CodeCall;", "Lkotlin/collections/HashMap;", "componentCallMap", "", "componentInbounds", "httpAdapterMap", "Lchapi/app/frontend/ApiCodeCall;", "umiIdent", "Lchapi/app/frontend/identify/UmiHttpIdentify;", "analysis", "", "Lchapi/app/frontend/ContainerService;", "nodes", "Lchapi/domain/core/CodeDataStruct;", "workspace", "([Lchapi/domain/core/CodeDataStruct;Ljava/lang/String;)[Lchapi/app/frontend/ContainerService;", "analysisByPath", "", "node", "createInbounds", "imports", "Lchapi/domain/core/CodeImport;", "filePath", "(Ljava/lang/String;[Lchapi/domain/core/CodeImport;Ljava/lang/String;)Ljava/util/List;", "fieldToCallMap", "field", "Lchapi/domain/core/CodeField;", "componentName", "inbounds", "recursiveCall", "func", "Lchapi/domain/core/CodeFunction;", "calleeName", "isComponent", "", "(Lchapi/domain/core/CodeFunction;Ljava/lang/String;ZLjava/lang/String;[Lchapi/domain/core/CodeImport;)V", "toContainerServices", "()[Lchapi/app/frontend/ContainerService;", "chapi-application"})
public final class FrontendApiAnalyser {
    @NotNull
    private HashMap<String, List<String>> componentCallMap = new HashMap();
    @NotNull
    private HashMap<String, List<String>> componentInbounds = new HashMap();
    @NotNull
    private HashMap<String, CodeCall> callMap = new HashMap();
    @NotNull
    private HashMap<String, ApiCodeCall> httpAdapterMap = new HashMap();
    @NotNull
    private final AxiosHttpIdentify axiosIdent = new AxiosHttpIdentify();
    @NotNull
    private final UmiHttpIdentify umiIdent = new UmiHttpIdentify();

    @NotNull
    public final ContainerService[] analysis(@NotNull CodeDataStruct[] nodes, @NotNull String workspace) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        CodeDataStruct[] $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (CodeDataStruct element$iv : $this$forEach$iv) {
            CodeDataStruct node = element$iv;
            boolean bl = false;
            this.analysisByPath(node, workspace);
        }
        return this.toContainerServices();
    }

    private final ContainerService[] toContainerServices() {
        Object[] componentCalls = null;
        componentCalls = new ContainerService[]{};
        Map $this$forEach$iv = this.componentInbounds;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry map = element$iv = iterator.next();
            boolean bl = false;
            ContainerService componentRef = new ContainerService((String)map.getKey(), null, null, 6, null);
            Iterable $this$forEach$iv2 = (Iterable)map.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ApiCodeCall apiCodeCall;
                Object httpApi;
                String it = (String)element$iv2;
                boolean bl2 = false;
                if (this.httpAdapterMap.get(it) != null) {
                    ApiCodeCall apiCodeCall2;
                    Intrinsics.checkNotNull((Object)((Object)this.httpAdapterMap.get(it)));
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)apiCodeCall2), (String)"httpAdapterMap[it]!!");
                    ApiCodeCall call = apiCodeCall2;
                    httpApi = new ContainerDemand(null, null, null, null, null, null, 63, null);
                    String string = call.getApiType();
                    if (Intrinsics.areEqual((Object)string, (Object)"axios")) {
                        httpApi = this.axiosIdent.convert(call);
                    } else if (Intrinsics.areEqual((Object)string, (Object)"umi")) {
                        httpApi = this.umiIdent.convert(call);
                    }
                    httpApi.setSource_caller(it);
                    httpApi.setCall_routes(CollectionsKt.listOf((Object)it));
                    componentRef.setDemands(CollectionsKt.plus((Collection)componentRef.getDemands(), (Object)httpApi));
                    continue;
                }
                if (this.callMap.get(it) == null) continue;
                Intrinsics.checkNotNull((Object)this.callMap.get(it));
                Intrinsics.checkNotNullExpressionValue((Object)httpApi, (String)"callMap[it]!!");
                CodeCall codeCall = httpApi;
                String name = NamingKt.naming(codeCall.getNodeName(), codeCall.getFunctionName());
                if (this.httpAdapterMap.get(name) == null) continue;
                Intrinsics.checkNotNull((Object)((Object)this.httpAdapterMap.get(name)));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)apiCodeCall), (String)"httpAdapterMap[name]!!");
                ApiCodeCall call = apiCodeCall;
                ContainerDemand httpApi2 = new ContainerDemand(null, null, null, null, null, null, 63, null);
                Object[] objectArray = call.getApiType();
                if (Intrinsics.areEqual((Object)objectArray, (Object)"axios")) {
                    httpApi2 = this.axiosIdent.convert(call);
                } else if (Intrinsics.areEqual((Object)objectArray, (Object)"umi")) {
                    httpApi2 = this.umiIdent.convert(call);
                }
                httpApi2.setSource_caller(name);
                objectArray = new String[]{it, name};
                httpApi2.setCall_routes(CollectionsKt.listOf((Object[])objectArray));
                componentRef.setDemands(CollectionsKt.plus((Collection)componentRef.getDemands(), (Object)httpApi2));
            }
            if (!(!((Collection)componentRef.getDemands()).isEmpty())) continue;
            componentCalls = ArraysKt.plus((Object[])componentCalls, (Object)componentRef);
        }
        return componentCalls;
    }

    private final void analysisByPath(CodeDataStruct node, String workspace) {
        boolean isComponent = false;
        boolean isComponentExt = Intrinsics.areEqual((Object)node.fileExt(), (Object)"tsx") || Intrinsics.areEqual((Object)node.fileExt(), (Object)"jsx");
        boolean isNotInterface = node.getType() != DataStructType.INTERFACE;
        List<String> inbounds = this.createInbounds(workspace, node.getImports(), node.getFilePath());
        String moduleName = StringsKt.substringBeforeLast((String)EcmaImportPathKt.relativeRoot(workspace, node.getFilePath()), (char)'.', (String)"");
        String componentName = NamingKt.naming(moduleName, node.getNodeName());
        CodeField[] $this$forEach$iv = node.getFields();
        boolean $i$f$forEach = false;
        for (CodeField element$iv : $this$forEach$iv) {
            CodeField field = element$iv;
            boolean bl = false;
            this.fieldToCallMap(field, componentName, inbounds);
        }
        $this$forEach$iv = node.getFunctions();
        $i$f$forEach = false;
        CodeField[] codeFieldArray = $this$forEach$iv;
        int n = 0;
        int n2 = codeFieldArray.length;
        while (n < n2) {
            CodeField element$iv;
            element$iv = codeFieldArray[n];
            ++n;
            CodeField func = element$iv;
            boolean bl = false;
            boolean bl2 = isComponent = isNotInterface && isComponentExt && func.getIsReturnHtml();
            if (isComponent) {
                Map map = this.componentCallMap;
                List list = new ArrayList();
                map.put(componentName, list);
            }
            String calleeName = null;
            calleeName = NamingKt.naming(componentName, func.getName());
            if (isComponent) {
                calleeName = componentName;
            }
            CodeCall[] $this$forEach$iv2 = func.getFunctionCalls();
            boolean $i$f$forEach2 = false;
            CodeCall[] codeCallArray = $this$forEach$iv2;
            int n3 = 0;
            int n4 = codeCallArray.length;
            while (n3 < n4) {
                Object object;
                CodeCall element$iv2 = codeCallArray[n3];
                ++n3;
                CodeCall call = element$iv2;
                boolean bl3 = false;
                Map map = this.callMap;
                Object object2 = calleeName;
                map.put(object2, call);
                if (this.axiosIdent.isMatch(call, node.getImports())) {
                    map = this.httpAdapterMap;
                    object2 = calleeName;
                    object = ApiCodeCall.Companion.from(call, "axios");
                    map.put(object2, object);
                }
                if (this.umiIdent.isMatch(call, node.getImports())) {
                    map = this.httpAdapterMap;
                    object2 = calleeName;
                    object = ApiCodeCall.Companion.from(call, "umi");
                    map.put(object2, object);
                }
                if (!isComponent) continue;
                List<String> list = this.componentCallMap.get(componentName);
                if (list == null) continue;
                object2 = list;
                object = call.getFunctionName();
                object2.add(object);
            }
            this.recursiveCall((CodeFunction)func, calleeName, isComponent, componentName, node.getImports());
            if (!isComponent) continue;
            ((Map)this.componentInbounds).put(componentName, inbounds);
        }
    }

    private final void fieldToCallMap(CodeField field, String componentName, List<String> inbounds) {
        CodeCall[] $this$forEach$iv = field.getCalls();
        boolean $i$f$forEach = false;
        CodeCall[] codeCallArray = $this$forEach$iv;
        int n = 0;
        int n2 = codeCallArray.length;
        while (n < n2) {
            CodeCall element$iv = codeCallArray[n];
            ++n;
            CodeCall it = element$iv;
            boolean bl = false;
            String calleeName = NamingKt.naming(componentName, field.getTypeKey());
            ((Map)this.callMap).put(calleeName, it);
            CodeProperty[] $this$forEach$iv2 = it.getParameters();
            boolean $i$f$forEach2 = false;
            CodeProperty[] codePropertyArray = $this$forEach$iv2;
            int n3 = 0;
            int n4 = codePropertyArray.length;
            while (n3 < n4) {
                CodeProperty element$iv2 = codePropertyArray[n3];
                ++n3;
                CodeProperty it2 = element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv3 = inbounds;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    String inbound = (String)element$iv3;
                    boolean bl3 = false;
                    if (!StringsKt.endsWith$default((String)inbound, (String)Intrinsics.stringPlus((String)"::", (Object)it2.getTypeValue()), (boolean)false, (int)2, null)) continue;
                    Object object = new String[]{"::"};
                    List split = StringsKt.split$default((CharSequence)inbound, (String[])object, (boolean)false, (int)0, (int)6, null);
                    object = this.callMap;
                    String string = (String)split.get(1);
                    String string2 = (String)split.get(0);
                    string = new CodeCall(null, null, string2, string, null, null, 51, null);
                    object.put(calleeName, string);
                }
            }
        }
    }

    private final List<String> createInbounds(String workspace, CodeImport[] imports, String filePath) {
        List inbounds = new ArrayList();
        CodeImport[] $this$forEach$iv = imports;
        boolean $i$f$forEach = false;
        CodeImport[] codeImportArray = $this$forEach$iv;
        int n = 0;
        int n2 = codeImportArray.length;
        while (n < n2) {
            CodeImport element$iv = codeImportArray[n];
            ++n;
            CodeImport imp = element$iv;
            boolean bl = false;
            String[] $this$forEach$iv2 = imp.getUsageName();
            boolean $i$f$forEach2 = false;
            for (String element$iv2 : $this$forEach$iv2) {
                String it = element$iv2;
                boolean bl2 = false;
                String source = EcmaImportPathKt.ecmaImportConvert(workspace, filePath, imp.getSource());
                ((Collection)inbounds).add(NamingKt.naming(source, it));
            }
        }
        return inbounds;
    }

    private final void recursiveCall(CodeFunction func, String calleeName, boolean isComponent, String componentName, CodeImport[] imports) {
        CodeFunction[] $this$forEach$iv = func.getInnerFunctions();
        boolean $i$f$forEach = false;
        CodeFunction[] codeFunctionArray = $this$forEach$iv;
        int n = 0;
        int n2 = codeFunctionArray.length;
        while (n < n2) {
            CodeFunction element$iv = codeFunctionArray[n];
            ++n;
            CodeFunction inner = element$iv;
            boolean bl = false;
            FrontendApiAnalyser $this$recursiveCall_u24lambda_u2d15_u24lambda_u2d13 = this;
            boolean bl2 = false;
            CodeCall[] $this$forEach$iv2 = inner.getFunctionCalls();
            boolean $i$f$forEach2 = false;
            CodeCall[] codeCallArray = $this$forEach$iv2;
            int n3 = 0;
            int n4 = codeCallArray.length;
            while (n3 < n4) {
                Object object;
                Map map;
                CodeCall element$iv2 = codeCallArray[n3];
                ++n3;
                CodeCall innerCall = element$iv2;
                boolean bl3 = false;
                FrontendApiAnalyser $this$recursiveCall_u24lambda_u2d15_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11 = $this$recursiveCall_u24lambda_u2d15_u24lambda_u2d13;
                boolean bl4 = false;
                ((Map)$this$recursiveCall_u24lambda_u2d15_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.callMap).put(calleeName, innerCall);
                if ($this$recursiveCall_u24lambda_u2d15_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.umiIdent.isMatch(innerCall, imports)) {
                    map = $this$recursiveCall_u24lambda_u2d15_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.httpAdapterMap;
                    object = ApiCodeCall.Companion.from(innerCall, "umi");
                    map.put(calleeName, object);
                }
                if ($this$recursiveCall_u24lambda_u2d15_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.axiosIdent.isMatch(innerCall, imports)) {
                    map = $this$recursiveCall_u24lambda_u2d15_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.httpAdapterMap;
                    object = ApiCodeCall.Companion.from(innerCall, "axios");
                    map.put(calleeName, object);
                }
                if (!isComponent) continue;
                List<String> list = $this$recursiveCall_u24lambda_u2d15_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.componentCallMap.get(componentName);
                if (list == null) continue;
                object = list;
                String string = innerCall.getFunctionName();
                object.add(string);
            }
            CodeFunction[] $this$forEach$iv3 = func.getInnerFunctions();
            boolean $i$f$forEach3 = false;
            for (CodeFunction element$iv3 : $this$forEach$iv3) {
                CodeFunction it = element$iv3;
                boolean bl5 = false;
                this.recursiveCall(it, calleeName, isComponent, componentName, imports);
            }
        }
    }
}

