/*
 * Decompiled with CFR 0.152.
 */
package chapi.app.frontend.path;

import chapi.app.frontend.path.OS;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\t"}, d2={"ecmaImportConvert", "", "workspace", "filepath", "importPath", "getOS", "Lchapi/app/frontend/path/OS;", "importConvert", "relativeRoot", "chapi-application"})
public final class EcmaImportPathKt {
    @Nullable
    public static final OS getOS() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
        String os = string2;
        return StringsKt.contains$default((CharSequence)os, (CharSequence)"win", (boolean)false, (int)2, null) ? OS.WINDOWS : (StringsKt.contains$default((CharSequence)os, (CharSequence)"nix", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)os, (CharSequence)"nux", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)os, (CharSequence)"aix", (boolean)false, (int)2, null) ? OS.LINUX : (StringsKt.contains$default((CharSequence)os, (CharSequence)"mac", (boolean)false, (int)2, null) ? OS.MAC : (StringsKt.contains$default((CharSequence)os, (CharSequence)"sunos", (boolean)false, (int)2, null) ? OS.SOLARIS : null)));
    }

    @NotNull
    public static final String ecmaImportConvert(@NotNull String workspace, @NotNull String filepath, @NotNull String importPath) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
        String pathname = filepath;
        boolean isResolvePath = StringsKt.startsWith$default((String)pathname, (String)"@/", (boolean)false, (int)2, null);
        if (isResolvePath) {
            String string = pathname;
            int n = 0;
            int n2 = 2;
            pathname = ((Object)StringsKt.removeRange((CharSequence)string, (int)n, (int)n2)).toString();
        }
        String relativePath = pathname;
        try {
            String string = FilesKt.relativeTo((File)new File(pathname), (File)new File(workspace)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(pathname).relativeT\u2026le(workspace)).toString()");
            relativePath = string;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        if (!StringsKt.startsWith$default((String)relativePath, (String)"./", (boolean)false, (int)2, null) || !StringsKt.startsWith$default((String)relativePath, (String)"../", (boolean)false, (int)2, null)) {
            relativePath = Intrinsics.stringPlus((String)"./", (Object)relativePath);
        }
        return EcmaImportPathKt.importConvert(relativePath, importPath);
    }

    @NotNull
    public static final String importConvert(@NotNull String filepath, @NotNull String importPath) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
        boolean isResolvePath = StringsKt.startsWith$default((String)importPath, (String)"@/", (boolean)false, (int)2, null);
        if (isResolvePath) {
            String string = importPath;
            int n = 0;
            int n2 = 2;
            return ((Object)StringsKt.removeRange((CharSequence)string, (int)n, (int)n2)).toString();
        }
        if (StringsKt.startsWith$default((String)importPath, (String)"./", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)importPath, (String)"../", (boolean)false, (int)2, null)) {
            File file = new File(filepath);
            if (((CharSequence)FilesKt.getExtension((File)file)).length() > 0 && file.getParentFile() != null) {
                File file2 = file.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.parentFile");
                file = file2;
            }
            File resolve = FilesKt.resolve((File)file, (File)new File(importPath));
            String string = FilesKt.normalize((File)resolve).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolve.normalize().toString()");
            return string;
        }
        String importPath2 = importPath;
        if (EcmaImportPathKt.getOS() == OS.WINDOWS) {
            importPath2 = StringsKt.replace$default((String)importPath2, (String)"\\", (String)"/", (boolean)false, (int)4, null);
        }
        return importPath2;
    }

    @NotNull
    public static final String relativeRoot(@NotNull String filepath, @NotNull String importPath) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
        String pathname = importPath;
        boolean isResolvePath = StringsKt.startsWith$default((String)pathname, (String)"@/", (boolean)false, (int)2, null);
        if (isResolvePath) {
            String string = pathname;
            int n = 0;
            int n2 = 2;
            pathname = ((Object)StringsKt.removeRange((CharSequence)string, (int)n, (int)n2)).toString();
        }
        String relativePath = pathname;
        try {
            String string = FilesKt.relativeTo((File)new File(pathname), (File)new File(filepath)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(pathname).relativeT\u2026ile(filepath)).toString()");
            relativePath = string;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        if (EcmaImportPathKt.getOS() == OS.WINDOWS) {
            relativePath = StringsKt.replace$default((String)relativePath, (String)"\\", (String)"/", (boolean)false, (int)4, null);
        }
        return relativePath;
    }
}

