/*
 * Decompiled with CFR 0.152.
 */
package chapi.ast.goast;

import chapi.ast.antlr.GoParser;
import chapi.ast.goast.GoAstListener;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeContainer;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeField;
import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodeImport;
import chapi.domain.core.CodeProperty;
import chapi.domain.core.DataStructType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u001a\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0002J\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0012\u0010&\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0012\u0010)\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010*H\u0016J\u0012\u0010+\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010,H\u0016J\u0012\u0010-\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010.H\u0016J\u0012\u0010/\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u000100H\u0016J\u0012\u00101\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u000102H\u0016J\u0012\u00103\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u000104H\u0016J\u0012\u00105\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u000106H\u0016J\u0012\u00107\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u000108H\u0016J\u0012\u00109\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010:H\u0016J\u0012\u0010;\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010,H\u0016J\u0012\u0010<\u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u000102H\u0016J\u0006\u0010=\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lchapi/ast/goast/GoFullIdentListener;", "Lchapi/ast/goast/GoAstListener;", "fileName", "", "(Ljava/lang/String;)V", "codeContainer", "Lchapi/domain/core/CodeContainer;", "currentFunction", "Lchapi/domain/core/CodeFunction;", "currentNode", "Lchapi/domain/core/CodeDataStruct;", "defaultNode", "getFileName", "()Ljava/lang/String;", "setFileName", "localVars", "", "structMap", "addReceiverToStruct", "", "receiverName", "codeFunction", "buildPrimaryExprCtx", "primaryExprCtx", "Lorg/antlr/v4/runtime/tree/ParseTree;", "buildStruct", "identifyName", "typeChild", "buildStructFields", "", "Lchapi/domain/core/CodeField;", "structTypeCtx", "Lchapi/ast/antlr/GoParser$StructTypeContext;", "(Lchapi/ast/antlr/GoParser$StructTypeContext;)[Lchapi/domain/core/CodeField;", "buildTypeSpec", "typeSpec", "Lchapi/ast/antlr/GoParser$TypeSpecContext;", "createStructByName", "enterConstDecl", "ctx", "Lchapi/ast/antlr/GoParser$ConstDeclContext;", "enterExpression", "Lchapi/ast/antlr/GoParser$ExpressionContext;", "enterFunctionDecl", "Lchapi/ast/antlr/GoParser$FunctionDeclContext;", "enterImportDecl", "Lchapi/ast/antlr/GoParser$ImportDeclContext;", "enterImportSpec", "Lchapi/ast/antlr/GoParser$ImportSpecContext;", "enterMethodDecl", "Lchapi/ast/antlr/GoParser$MethodDeclContext;", "enterPackageClause", "Lchapi/ast/antlr/GoParser$PackageClauseContext;", "enterShortVarDecl", "Lchapi/ast/antlr/GoParser$ShortVarDeclContext;", "enterTypeDecl", "Lchapi/ast/antlr/GoParser$TypeDeclContext;", "enterVarDecl", "Lchapi/ast/antlr/GoParser$VarDeclContext;", "exitFunctionDecl", "exitMethodDecl", "getNodeInfo", "chapi-ast-go"})
public final class GoFullIdentListener
extends GoAstListener {
    @NotNull
    private String fileName;
    @NotNull
    private CodeContainer codeContainer;
    @NotNull
    private CodeDataStruct currentNode;
    @NotNull
    private CodeDataStruct defaultNode;
    @NotNull
    private Map<String, CodeDataStruct> structMap;
    @NotNull
    private Map<String, String> localVars;
    @NotNull
    private CodeFunction currentFunction;

    public GoFullIdentListener(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fileName = fileName;
        this.codeContainer = new CodeContainer(this.fileName, null, null, null, null, null, null, 126, null);
        this.currentNode = new CodeDataStruct(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 131071, null);
        this.defaultNode = new CodeDataStruct(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 131071, null);
        this.structMap = new LinkedHashMap();
        this.localVars = new LinkedHashMap();
        this.currentFunction = new CodeFunction(null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, false, false, 98303, null);
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fileName = string;
    }

    @Override
    public void enterImportDecl(@Nullable GoParser.ImportDeclContext ctx) {
        super.enterImportDecl(ctx);
    }

    @Override
    public void enterPackageClause(@Nullable GoParser.PackageClauseContext ctx) {
        GoParser.PackageClauseContext packageClauseContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)packageClauseContext));
        String string = packageClauseContext.IDENTIFIER().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx!!.IDENTIFIER().text");
        this.codeContainer.setPackageName(string);
    }

    @Override
    public void enterImportSpec(@Nullable GoParser.ImportSpecContext ctx) {
        Object object;
        GoParser.ImportSpecContext importSpecContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)importSpecContext));
        String originSource = importSpecContext.importPath().getText();
        Intrinsics.checkNotNullExpressionValue((Object)originSource, (String)"originSource");
        String sourceName = StringsKt.replace$default((String)originSource, (String)"\"", (String)"", (boolean)false, (int)4, null);
        CodeImport codeImport = new CodeImport(sourceName, null, null, null, 14, null);
        if (ctx.DOT() != null) {
            codeImport.setAsName(".");
        }
        if (ctx.IDENTIFIER() != null) {
            Object[] objectArray = codeImport.getUsageName();
            object = ctx.IDENTIFIER().getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.IDENTIFIER().text");
            codeImport.setUsageName((String[])ArraysKt.plus((Object[])objectArray, (Object)object));
        }
        object = this.codeContainer;
        object.setImports((CodeImport[])ArraysKt.plus((Object[])object.getImports(), (Object)codeImport));
    }

    @Override
    public void enterFunctionDecl(@Nullable GoParser.FunctionDeclContext ctx) {
        GoParser.FunctionDeclContext functionDeclContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)functionDeclContext));
        String funcName = functionDeclContext.IDENTIFIER().getText();
        Intrinsics.checkNotNullExpressionValue((Object)funcName, (String)"funcName");
        CodeFunction codeFunction = new CodeFunction(funcName, null, this.codeContainer.getPackageName(), null, null, null, null, null, false, null, null, null, null, null, null, false, false, 131066, null);
        codeFunction.setParameters(this.buildParameters(ctx.signature().parameters()));
        codeFunction.setMultipleReturns(this.buildReturnTypeFromSignature(ctx.signature()));
        this.currentFunction = codeFunction;
    }

    @Override
    public void exitFunctionDecl(@Nullable GoParser.FunctionDeclContext ctx) {
        this.currentFunction.addVarsFromMap(this.localVars);
        CodeDataStruct codeDataStruct = this.defaultNode;
        codeDataStruct.setFunctions((CodeFunction[])ArraysKt.plus((Object[])codeDataStruct.getFunctions(), (Object)this.currentFunction));
        this.currentFunction = new CodeFunction(null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, false, false, 131071, null);
    }

    @Override
    public void enterTypeDecl(@Nullable GoParser.TypeDeclContext ctx) {
        GoParser.TypeDeclContext typeDeclContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)typeDeclContext));
        List<GoParser.TypeSpecContext> typeSpecs = typeDeclContext.typeSpec();
        for (GoParser.TypeSpecContext typeSpec : typeSpecs) {
            Intrinsics.checkNotNullExpressionValue((Object)((Object)typeSpec), (String)"typeSpec");
            this.buildTypeSpec(typeSpec);
        }
    }

    @Override
    public void enterMethodDecl(@Nullable GoParser.MethodDeclContext ctx) {
        GoParser.MethodDeclContext methodDeclContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)methodDeclContext));
        String funcName = methodDeclContext.IDENTIFIER().getText();
        Intrinsics.checkNotNullExpressionValue((Object)funcName, (String)"funcName");
        CodeFunction codeFunction = new CodeFunction(funcName, null, null, null, null, null, null, null, false, null, null, null, null, null, null, false, false, 131070, null);
        codeFunction.setMultipleReturns(this.buildReturnTypeFromSignature(ctx.signature()));
        codeFunction.setParameters(this.buildParameters(ctx.signature().parameters()));
        this.currentFunction = codeFunction;
    }

    @Override
    public void exitMethodDecl(@Nullable GoParser.MethodDeclContext ctx) {
        GoParser.MethodDeclContext methodDeclContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)methodDeclContext));
        String string = this.getStructNameFromReceiver(methodDeclContext.receiver().parameters());
        Intrinsics.checkNotNull((Object)string);
        String receiverName = string;
        this.currentFunction.addVarsFromMap(this.localVars);
        this.addReceiverToStruct(receiverName, this.currentFunction);
        this.currentFunction = new CodeFunction(null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, false, false, 131071, null);
    }

    private final void addReceiverToStruct(String receiverName, CodeFunction codeFunction) {
        if (this.structMap.get(receiverName) == null) {
            CodeDataStruct struct = this.createStructByName(receiverName);
            struct.setFunctions((CodeFunction[])ArraysKt.plus((Object[])struct.getFunctions(), (Object)codeFunction));
            this.structMap.put(receiverName, struct);
        } else {
            CodeDataStruct codeDataStruct = this.structMap.get(receiverName);
            Intrinsics.checkNotNull((Object)codeDataStruct);
            CodeDataStruct codeDataStruct2 = codeDataStruct;
            codeDataStruct2.setFunctions((CodeFunction[])ArraysKt.plus((Object[])codeDataStruct2.getFunctions(), (Object)codeFunction));
        }
    }

    private final void buildTypeSpec(GoParser.TypeSpecContext typeSpec) {
        ParseTree typeChild;
        String identifyName = typeSpec.IDENTIFIER().getText();
        GoParser.TypeLitContext typeLit = typeSpec.type_().typeLit();
        if (typeLit != null && Intrinsics.areEqual((Object)(typeChild = typeLit.getChild(0)).getClass().getSimpleName(), (Object)"StructTypeContext")) {
            Intrinsics.checkNotNullExpressionValue((Object)identifyName, (String)"identifyName");
            this.buildStruct(identifyName, typeChild);
        }
    }

    private final void buildStruct(String identifyName, ParseTree typeChild) {
        CodeDataStruct struct = this.createStructByName(identifyName);
        ParseTree parseTree = typeChild;
        if (parseTree == null) {
            throw new NullPointerException("null cannot be cast to non-null type chapi.ast.antlr.GoParser.StructTypeContext");
        }
        GoParser.StructTypeContext structTypeCtx = (GoParser.StructTypeContext)parseTree;
        CodeField[] fields = this.buildStructFields(structTypeCtx);
        if (this.structMap.get(identifyName) != null) {
            CodeDataStruct codeDataStruct = this.structMap.get(identifyName);
            Intrinsics.checkNotNull((Object)codeDataStruct);
            codeDataStruct.setFields(fields);
        } else {
            struct.setFields(fields);
            this.structMap.put(identifyName, struct);
        }
    }

    private final CodeDataStruct createStructByName(String identifyName) {
        CodeDataStruct struct = new CodeDataStruct(identifyName, DataStructType.STRUCT, this.codeContainer.getPackageName(), this.codeContainer.getFullName(), null, null, null, null, null, null, null, null, null, null, null, null, null, 131056, null);
        return struct;
    }

    private final CodeField[] buildStructFields(GoParser.StructTypeContext structTypeCtx) {
        Object[] fields = new CodeField[]{};
        for (GoParser.FieldDeclContext fieldDeclContext : structTypeCtx.fieldDecl()) {
            String typeValue = fieldDeclContext.identifierList().getText();
            String typeType = fieldDeclContext.type_().getText();
            Intrinsics.checkNotNullExpressionValue((Object)typeType, (String)"typeType");
            Intrinsics.checkNotNullExpressionValue((Object)typeValue, (String)"typeValue");
            CodeField field = new CodeField(typeType, typeValue, null, null, null, null, 60, null);
            fields = (CodeField[])ArraysKt.plus((Object[])fields, (Object)field);
        }
        return fields;
    }

    @Override
    public void enterExpression(@Nullable GoParser.ExpressionContext ctx) {
        GoParser.ExpressionContext expressionContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)expressionContext));
        ParseTree firstChild = expressionContext.getChild(0);
        if (Intrinsics.areEqual((Object)firstChild.getClass().getSimpleName(), (Object)"PrimaryExprContext") && firstChild.getChild(1) != null) {
            this.buildPrimaryExprCtx(firstChild);
        }
    }

    private final void buildPrimaryExprCtx(ParseTree primaryExprCtx) {
        ParseTree parseTree = primaryExprCtx;
        Intrinsics.checkNotNull((Object)parseTree);
        if (Intrinsics.areEqual((Object)parseTree.getChild(1).getClass().getSimpleName(), (Object)"ArgumentsContext")) {
            String string = primaryExprCtx.getChild(0).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"primaryExprCtx.getChild(0).text");
            CodeCall codeCall = new CodeCall(null, null, string, null, null, null, 59, null);
            ParseTree parseTree2 = primaryExprCtx.getChild(1);
            if (parseTree2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type chapi.ast.antlr.GoParser.ArgumentsContext");
            }
            GoParser.ArgumentsContext argumentsContext = (GoParser.ArgumentsContext)parseTree2;
            for (GoParser.ExpressionContext expressionContext : argumentsContext.expressionList().expression()) {
                String string2 = expressionContext.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expressionContext.text");
                CodeProperty codeProperty = new CodeProperty(null, null, string2, "", null, null, null, null, 243, null);
                codeCall.setParameters((CodeProperty[])ArraysKt.plus((Object[])codeCall.getParameters(), (Object)codeProperty));
            }
            CodeFunction codeFunction = this.currentFunction;
            codeFunction.setFunctionCalls((CodeCall[])ArraysKt.plus((Object[])codeFunction.getFunctionCalls(), (Object)codeCall));
        }
    }

    @Override
    public void enterVarDecl(@Nullable GoParser.VarDeclContext ctx) {
        GoParser.VarDeclContext varDeclContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)varDeclContext));
        for (GoParser.VarSpecContext varSpecContext : varDeclContext.varSpec()) {
            Object varType = "";
            if (varSpecContext.type_() != null) {
                String string = varSpecContext.type_().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"varSpecContext.type_().text");
                varType = string;
            }
            for (TerminalNode terminalNode : varSpecContext.identifierList().IDENTIFIER()) {
                Map<String, String> map = this.localVars;
                String string = terminalNode.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"terminalNode.text");
                map.put(string, (String)varType);
            }
        }
    }

    @Override
    public void enterShortVarDecl(@Nullable GoParser.ShortVarDeclContext ctx) {
        GoParser.ShortVarDeclContext shortVarDeclContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)shortVarDeclContext));
        for (TerminalNode terminalNode : shortVarDeclContext.identifierList().IDENTIFIER()) {
            String string = terminalNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"terminalNode.text");
            this.localVars.put(string, "");
        }
    }

    @Override
    public void enterConstDecl(@Nullable GoParser.ConstDeclContext ctx) {
        GoParser.ConstDeclContext constDeclContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)constDeclContext));
        for (GoParser.ConstSpecContext constSpecContext : constDeclContext.constSpec()) {
            Object varType = "";
            if (constSpecContext.type_() != null) {
                String string = constSpecContext.type_().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constSpecContext.type_().text");
                varType = string;
            }
            for (TerminalNode terminalNode : constSpecContext.identifierList().IDENTIFIER()) {
                Map<String, String> map = this.localVars;
                String string = terminalNode.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"terminalNode.text");
                map.put(string, (String)varType);
            }
        }
    }

    @NotNull
    public final CodeContainer getNodeInfo() {
        for (Map.Entry<String, CodeDataStruct> entry : this.structMap.entrySet()) {
            CodeContainer codeContainer = this.codeContainer;
            codeContainer.setDataStructures((CodeDataStruct[])ArraysKt.plus((Object[])codeContainer.getDataStructures(), (Object)entry.getValue()));
        }
        if (!(this.defaultNode.getFunctions().length == 0)) {
            CodeContainer codeContainer = this.codeContainer;
            codeContainer.setDataStructures((CodeDataStruct[])ArraysKt.plus((Object[])codeContainer.getDataStructures(), (Object)this.defaultNode));
        }
        return this.codeContainer;
    }
}

