/*
 * Decompiled with CFR 0.152.
 */
package chapi.ast.javaast;

import chapi.ast.antlr.JavaParser;
import chapi.ast.javaast.JavaAstListener;
import chapi.ast.javaast.JavaTargetType;
import chapi.ast.javaast.TargetTypePackage;
import chapi.domain.core.CallType;
import chapi.domain.core.CodeAnnotation;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeContainer;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeField;
import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodeImport;
import chapi.domain.core.CodePosition;
import chapi.domain.core.CodeProperty;
import chapi.domain.core.DataStructType;
import chapi.infra.Stack;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000200H\u0002J\b\u00102\u001a\u000200H\u0002J\u001a\u00103\u001a\u0002002\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\tH\u0002J\u001a\u00107\u001a\u0002002\b\u00108\u001a\u0004\u0018\u00010\u00032\u0006\u00104\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003H\u0002J\u0018\u0010<\u001a\u0002002\u0006\u0010=\u001a\u00020\u00032\u0006\u00104\u001a\u00020>H\u0002J\u001b\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u00104\u001a\u000205H\u0016\u00a2\u0006\u0002\u0010@J\u0018\u0010A\u001a\u0002002\u0006\u0010B\u001a\u00020*2\u0006\u00104\u001a\u00020CH\u0002J,\u0010D\u001a\u0002002\u0006\u0010B\u001a\u00020*2\b\b\u0002\u0010E\u001a\u00020\u00032\b\u0010F\u001a\u0004\u0018\u00010\u00032\u0006\u00104\u001a\u00020CH\u0002J\u0018\u0010G\u001a\u0002002\u0006\u0010B\u001a\u00020*2\u0006\u00104\u001a\u00020CH\u0002J\u001d\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u00052\b\u0010J\u001a\u0004\u0018\u00010KH\u0002\u00a2\u0006\u0002\u0010LJ\u0012\u0010M\u001a\u00020\u00032\b\u0010N\u001a\u0004\u0018\u00010\u0003H\u0002J$\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010=\u001a\u00020Q2\b\u0010R\u001a\u0004\u0018\u00010P2\u0006\u0010S\u001a\u00020TH\u0002J\u0012\u0010U\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010VH\u0016J\u0012\u0010W\u001a\u0002002\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u0012\u0010X\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010YH\u0016J\u0012\u0010Z\u001a\u0002002\b\u00104\u001a\u0004\u0018\u000109H\u0016J\u0012\u0010[\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010\\H\u0016J\u0012\u0010]\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010>H\u0016J\u0012\u0010^\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010_H\u0016J\u0012\u0010`\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010aH\u0016J\u0012\u0010b\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010cH\u0016J\u0012\u0010d\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010eH\u0016J\u0012\u0010f\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010CH\u0016J\u0012\u0010g\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010hH\u0016J\u0012\u0010i\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010jH\u0016J\b\u0010k\u001a\u000200H\u0002J\u0012\u0010l\u001a\u0002002\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u0012\u0010m\u001a\u0002002\b\u00104\u001a\u0004\u0018\u000109H\u0016J\u0012\u0010n\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010oH\u0016J\u0012\u0010p\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010aH\u0016J\u0012\u0010q\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010hH\u0016J\u0010\u0010r\u001a\u00020\u00032\u0006\u0010s\u001a\u00020\u0013H\u0002J\u0006\u0010t\u001a\u00020\u0010J(\u0010u\u001a\u00020v2\u0006\u00104\u001a\u00020C2\u0006\u0010w\u001a\u00020\u00032\u0006\u0010x\u001a\u00020\u00032\u0006\u0010y\u001a\u00020\u0003H\u0002J\b\u0010z\u001a\u000200H\u0002J\u0014\u0010{\u001a\u0004\u0018\u00010\u00032\b\u0010|\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010}\u001a\u00020\u00032\u0006\u0010~\u001a\u00020\u0003H\u0002J\u0010\u0010\u007f\u001a\u0002002\u0006\u0010B\u001a\u00020*H\u0002J\u0012\u0010\u0080\u0001\u001a\u0002002\u0007\u0010\u0081\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u0082\u0001\u001a\u000200H\u0002J\u0014\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010N\u001a\u0004\u0018\u00010\u0003H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010$R\u000e\u0010%\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010+R\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010.\u00a8\u0006\u0085\u0001"}, d2={"Lchapi/ast/javaast/JavaFullIdentListener;", "Lchapi/ast/javaast/JavaAstListener;", "fileName", "", "classes", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "classNodeStack", "Lchapi/infra/Stack;", "Lchapi/domain/core/CodeDataStruct;", "classNodes", "[Lchapi/domain/core/CodeDataStruct;", "getClasses", "()[Ljava/lang/String;", "[Ljava/lang/String;", "codeContainer", "Lchapi/domain/core/CodeContainer;", "creatorMethodMap", "", "Lchapi/domain/core/CodeFunction;", "currentClz", "currentClzExtend", "currentCreatorNode", "currentFunction", "currentNode", "currentType", "Lchapi/domain/core/DataStructType;", "fields", "Lchapi/domain/core/CodeField;", "[Lchapi/domain/core/CodeField;", "fieldsMap", "formalParameters", "hasEnterClass", "", "imports", "Lchapi/domain/core/CodeImport;", "[Lchapi/domain/core/CodeImport;", "innerNode", "isOverrideMethod", "lastNode", "localVars", "methodCalls", "Lchapi/domain/core/CodeCall;", "[Lchapi/domain/core/CodeCall;", "methodMap", "methodQueue", "[Lchapi/domain/core/CodeFunction;", "addLocalVarsToFunction", "", "addToCreatorNodeMethod", "addToParentClassMethodInner", "buildClassExtension", "ctx", "Lchapi/ast/antlr/JavaParser$ClassDeclarationContext;", "classNode", "buildCreatedCall", "createdName", "Lchapi/ast/antlr/JavaParser$CreatorContext;", "buildExtend", "extendName", "buildFieldCall", "typeType", "Lchapi/ast/antlr/JavaParser$FieldDeclarationContext;", "buildImplements", "(Lchapi/ast/antlr/JavaParser$ClassDeclarationContext;)[Ljava/lang/String;", "buildMethodCallLocation", "codeCall", "Lchapi/ast/antlr/JavaParser$MethodCallContext;", "buildMethodCallMethodInfo", "callee", "_targetType", "buildMethodCallParameters", "buildMethodParameters", "Lchapi/domain/core/CodeProperty;", "params", "Lchapi/ast/antlr/JavaParser$FormalParametersContext;", "(Lchapi/ast/antlr/JavaParser$FormalParametersContext;)[Lchapi/domain/core/CodeProperty;", "buildPureTargetType", "targetType", "buildTypeCtxByIndex", "Lchapi/ast/antlr/JavaParser$ClassOrInterfaceTypeContext;", "Lorg/antlr/v4/runtime/tree/ParseTree;", "typeCtx", "index", "", "enterAnnotation", "Lchapi/ast/antlr/JavaParser$AnnotationContext;", "enterClassDeclaration", "enterConstructorDeclaration", "Lchapi/ast/antlr/JavaParser$ConstructorDeclarationContext;", "enterCreator", "enterExpression", "Lchapi/ast/antlr/JavaParser$ExpressionContext;", "enterFieldDeclaration", "enterImportDeclaration", "Lchapi/ast/antlr/JavaParser$ImportDeclarationContext;", "enterInterfaceDeclaration", "Lchapi/ast/antlr/JavaParser$InterfaceDeclarationContext;", "enterInterfaceMethodDeclaration", "Lchapi/ast/antlr/JavaParser$InterfaceMethodDeclarationContext;", "enterLocalVariableDeclaration", "Lchapi/ast/antlr/JavaParser$LocalVariableDeclarationContext;", "enterMethodCall", "enterMethodDeclaration", "Lchapi/ast/antlr/JavaParser$MethodDeclarationContext;", "enterPackageDeclaration", "Lchapi/ast/antlr/JavaParser$PackageDeclarationContext;", "exitBody", "exitClassDeclaration", "exitCreator", "exitFormalParameter", "Lchapi/ast/antlr/JavaParser$FormalParameterContext;", "exitInterfaceDeclaration", "exitMethodDeclaration", "getMethodMapName", "method", "getNodeInfo", "handleEmptyFullType", "Lchapi/ast/javaast/TargetTypePackage;", "targetTypeObj", "methodName", "packageName", "initClass", "parseTargetType", "target", "removeTarget", "fullType", "sendResultToMethodCallMap", "updateCodeFunction", "codeFunction", "updateStructMethods", "warpTargetFullType", "Lchapi/ast/javaast/JavaTargetType;", "chapi-ast-java"})
public class JavaFullIdentListener
extends JavaAstListener {
    @NotNull
    private final String[] classes;
    @NotNull
    private CodeDataStruct currentCreatorNode;
    private boolean isOverrideMethod;
    @NotNull
    private CodeField[] fields;
    @NotNull
    private CodeCall[] methodCalls;
    @NotNull
    private Map<String, CodeFunction> methodMap;
    @NotNull
    private Map<String, CodeFunction> creatorMethodMap;
    @NotNull
    private Map<String, String> localVars;
    @NotNull
    private Map<String, String> fieldsMap;
    @NotNull
    private Map<String, String> formalParameters;
    @NotNull
    private String currentClz;
    @NotNull
    private String currentClzExtend;
    private boolean hasEnterClass;
    @NotNull
    private CodeDataStruct[] classNodes;
    @NotNull
    private CodeDataStruct innerNode;
    @NotNull
    private Stack<CodeDataStruct> classNodeStack;
    @NotNull
    private CodeFunction[] methodQueue;
    @NotNull
    private CodeImport[] imports;
    @NotNull
    private CodeDataStruct lastNode;
    @NotNull
    private CodeDataStruct currentNode;
    @NotNull
    private CodeFunction currentFunction;
    @NotNull
    private DataStructType currentType;
    @NotNull
    private CodeContainer codeContainer;

    public JavaFullIdentListener(@NotNull String fileName, @NotNull String[] classes) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)classes, (String)"classes");
        this.classes = classes;
        this.currentCreatorNode = new CodeDataStruct(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 131071, null);
        this.fields = new CodeField[0];
        this.methodCalls = new CodeCall[0];
        this.methodMap = new LinkedHashMap();
        this.creatorMethodMap = new LinkedHashMap();
        this.localVars = new LinkedHashMap();
        this.fieldsMap = new LinkedHashMap();
        this.formalParameters = new LinkedHashMap();
        this.currentClz = "";
        this.currentClzExtend = "";
        this.classNodes = new CodeDataStruct[0];
        this.innerNode = new CodeDataStruct(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 131071, null);
        this.classNodeStack = new Stack();
        this.methodQueue = new CodeFunction[0];
        this.imports = new CodeImport[0];
        this.lastNode = new CodeDataStruct(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 131071, null);
        this.currentNode = new CodeDataStruct(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 131071, null);
        this.currentFunction = new CodeFunction(null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, false, false, 98303, null);
        this.currentType = DataStructType.EMPTY;
        this.codeContainer = new CodeContainer(fileName, null, null, null, null, null, null, 126, null);
    }

    @NotNull
    public final String[] getClasses() {
        return this.classes;
    }

    @Override
    public void enterPackageDeclaration(@Nullable JavaParser.PackageDeclarationContext ctx) {
        JavaParser.PackageDeclarationContext packageDeclarationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)packageDeclarationContext));
        JavaParser.QualifiedNameContext qualifiedNameContext = packageDeclarationContext.qualifiedName();
        Intrinsics.checkNotNull((Object)((Object)qualifiedNameContext));
        String string = qualifiedNameContext.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx!!.qualifiedName()!!.text");
        this.codeContainer.setPackageName(string);
    }

    @Override
    public void enterImportDeclaration(@Nullable JavaParser.ImportDeclarationContext ctx) {
        JavaParser.ImportDeclarationContext importDeclarationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)importDeclarationContext));
        JavaParser.QualifiedNameContext qualifiedNameContext = importDeclarationContext.qualifiedName();
        Intrinsics.checkNotNull((Object)((Object)qualifiedNameContext));
        String string = qualifiedNameContext.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx!!.qualifiedName()!!.text");
        CodeImport codeImport = new CodeImport(string, null, null, null, 14, null);
        this.imports = (CodeImport[])ArraysKt.plus((Object[])this.imports, (Object)codeImport);
        string = this.codeContainer;
        string.setImports((CodeImport[])ArraysKt.plus((Object[])string.getImports(), (Object)codeImport));
    }

    @Override
    public void enterClassDeclaration(@Nullable JavaParser.ClassDeclarationContext ctx) {
        boolean isInnerNode;
        boolean bl = isInnerNode = !Intrinsics.areEqual((Object)this.currentNode.getNodeName(), (Object)"");
        if (isInnerNode) {
            this.updateStructMethods();
            JavaParser.ClassDeclarationContext classDeclarationContext = ctx;
            Intrinsics.checkNotNull((Object)((Object)classDeclarationContext));
            this.innerNode = new CodeDataStruct(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.buildPosition(classDeclarationContext), 65535, null);
            this.currentType = DataStructType.INNER_STRUCTURES;
            this.innerNode.setType(this.currentType);
            this.buildClassExtension(ctx, this.innerNode);
            this.classNodeStack.push((Object)this.innerNode);
            CodeDataStruct codeDataStruct = this.lastNode;
            codeDataStruct.setInnerStructures((CodeDataStruct[])ArraysKt.plus((Object[])codeDataStruct.getInnerStructures(), (Object)this.innerNode));
            this.lastNode = this.innerNode;
        } else {
            this.currentType = DataStructType.CLASS;
            this.currentNode.setType(this.currentType);
            JavaParser.ClassDeclarationContext classDeclarationContext = ctx;
            Intrinsics.checkNotNull((Object)((Object)classDeclarationContext));
            this.currentNode.setPosition(this.buildPosition(classDeclarationContext));
            this.hasEnterClass = true;
            this.buildClassExtension(ctx, this.currentNode);
            this.lastNode = this.currentNode;
            this.classNodeStack.push((Object)this.currentNode);
        }
    }

    private final void updateStructMethods() {
        this.lastNode.setMethodsFromMap(this.methodMap);
        this.methodMap = new LinkedHashMap();
    }

    private final void buildClassExtension(JavaParser.ClassDeclarationContext ctx, CodeDataStruct classNode) {
        String string;
        classNode.setPackage(this.codeContainer.getPackageName());
        classNode.setFilePath(this.codeContainer.getFullName());
        JavaParser.ClassDeclarationContext classDeclarationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)classDeclarationContext));
        if (classDeclarationContext.identifier() != null) {
            string = ctx.identifier().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.identifier().text");
            this.currentClz = string;
            classNode.setNodeName(this.currentClz);
        }
        this.currentClzExtend = "";
        if (ctx.EXTENDS() != null) {
            string = ctx.typeType().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.typeType().text");
            this.currentClzExtend = string;
            classNode.setExtend(this.buildExtend(this.currentClzExtend));
        }
        if (ctx.IMPLEMENTS() != null) {
            classNode.setImplements(this.buildImplements(ctx));
        }
    }

    @NotNull
    public String[] buildImplements(@NotNull JavaParser.ClassDeclarationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Object[] objectArray = new String[]{};
        for (JavaParser.TypeListContext _type : ctx.typeList()) {
            String target = this.warpTargetFullType(_type.getText()).getTargetType();
            if (Intrinsics.areEqual((Object)target, (Object)"")) {
                String string = _type.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"_type.text");
                target = string;
            }
            objectArray = (String[])ArraysKt.plus((Object[])objectArray, (Object)target);
        }
        return objectArray;
    }

    @Override
    public void exitClassDeclaration(@Nullable JavaParser.ClassDeclarationContext ctx) {
        this.classNodeStack.pop();
        if (this.classNodeStack.count() == 0) {
            this.exitBody();
        } else {
            this.updateStructMethods();
        }
    }

    private final void exitBody() {
        this.currentNode.setFields(this.fields);
        this.currentNode.setMethodsFromMap(this.methodMap);
        this.classNodes = (CodeDataStruct[])ArraysKt.plus((Object[])this.classNodes, (Object)this.currentNode);
        this.initClass();
    }

    private final void initClass() {
        this.currentClz = "";
        this.currentClzExtend = "";
        this.currentFunction = new CodeFunction(null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, false, false, 98303, null);
        this.methodMap = new LinkedHashMap();
        this.methodCalls = new CodeCall[0];
        this.fields = new CodeField[0];
        this.isOverrideMethod = false;
    }

    @Override
    public void enterInterfaceMethodDeclaration(@Nullable JavaParser.InterfaceMethodDeclarationContext ctx) {
        JavaParser.InterfaceMethodDeclarationContext interfaceMethodDeclarationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)interfaceMethodDeclarationContext));
        String name = interfaceMethodDeclarationContext.interfaceCommonBodyDeclaration().identifier().getText();
        String typeType = ctx.interfaceCommonBodyDeclaration().typeTypeOrVoid().getText();
        CodePosition codePosition = new CodePosition(ctx.start.getLine(), ctx.start.getCharPositionInLine(), ctx.stop.getLine(), ctx.stop.getCharPositionInLine());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)typeType, (String)"typeType");
        CodeFunction codeFunction = new CodeFunction(name, null, null, typeType, null, null, null, null, false, null, null, null, codePosition, null, null, false, false, 94198, null);
        ParseTree mayModifierCtx = ctx.parent.parent.getChild(0);
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(mayModifierCtx.getClass()).getSimpleName(), (Object)"ModifierContext")) {
            ParseTree parseTree = mayModifierCtx;
            if (parseTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type chapi.ast.antlr.JavaParser.ModifierContext");
            }
            codeFunction.setAnnotations(this.buildAnnotationForMethod((JavaParser.ModifierContext)parseTree));
        }
        this.updateCodeFunction(codeFunction);
    }

    @Override
    public void enterMethodDeclaration(@Nullable JavaParser.MethodDeclarationContext ctx) {
        JavaParser.FormalParametersContext params;
        JavaParser.MethodDeclarationContext methodDeclarationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)methodDeclarationContext));
        String name = methodDeclarationContext.identifier().getText();
        String typeType = ctx.typeTypeOrVoid().getText();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)typeType, (String)"typeType");
        CodeFunction codeFunction = new CodeFunction(name, null, null, typeType, null, null, null, null, false, null, null, null, this.buildPosition(ctx), null, null, false, false, 94198, null);
        ParseTree mayModifierCtx = ctx.parent.parent.getChild(0);
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(mayModifierCtx.getClass()).getSimpleName(), (Object)"ModifierContext")) {
            ParseTree parseTree = mayModifierCtx;
            if (parseTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type chapi.ast.antlr.JavaParser.ModifierContext");
            }
            codeFunction.setAnnotations(this.buildAnnotationForMethod((JavaParser.ModifierContext)parseTree));
        }
        if ((params = ctx.formalParameters()) != null) {
            if (params.getChild(0) == null || Intrinsics.areEqual((Object)params.getText(), (Object)"()") || params.getChild(0) == null) {
                this.updateCodeFunction(codeFunction);
                return;
            }
            codeFunction.setParameters(this.buildMethodParameters(params));
        }
        this.updateCodeFunction(codeFunction);
    }

    private final CodeProperty[] buildMethodParameters(JavaParser.FormalParametersContext params) {
        Object[] methodParams = new CodeProperty[]{};
        JavaParser.FormalParametersContext formalParametersContext = params;
        Intrinsics.checkNotNull((Object)((Object)formalParametersContext));
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(formalParametersContext.getChild(1).getClass()).getSimpleName(), (Object)"FormalParameterListContext")) {
            return methodParams;
        }
        ParseTree parseTree = params.getChild(1);
        if (parseTree == null) {
            throw new NullPointerException("null cannot be cast to non-null type chapi.ast.antlr.JavaParser.FormalParameterListContext");
        }
        JavaParser.FormalParameterListContext parameterList = (JavaParser.FormalParameterListContext)parseTree;
        for (JavaParser.FormalParameterContext param : parameterList.formalParameter()) {
            JavaParser.FormalParameterContext paramCtx;
            if (param == null) {
                throw new NullPointerException("null cannot be cast to non-null type chapi.ast.antlr.JavaParser.FormalParameterContext");
            }
            String paramType = paramCtx.typeType().getText();
            String paramValue = paramCtx.variableDeclaratorId().identifier().getText();
            Intrinsics.checkNotNullExpressionValue((Object)paramValue, (String)"paramValue");
            Intrinsics.checkNotNullExpressionValue((Object)paramType, (String)"paramType");
            this.localVars.put(paramValue, paramType);
            CodeProperty parameter = new CodeProperty(null, null, paramValue, paramType, null, null, null, null, 243, null);
            methodParams = (CodeProperty[])ArraysKt.plus((Object[])methodParams, (Object)parameter);
        }
        return methodParams;
    }

    @Override
    public void exitMethodDeclaration(@Nullable JavaParser.MethodDeclarationContext ctx) {
        if (!this.localVars.isEmpty()) {
            this.addLocalVarsToFunction();
        }
    }

    private final void addLocalVarsToFunction() {
        String currentMethodName = this.getMethodMapName(this.currentFunction);
        CodeFunction mapFunc = this.methodMap.get(currentMethodName);
        if (mapFunc != null) {
            mapFunc.addVarsFromMap(this.localVars);
            this.methodMap.put(currentMethodName, mapFunc);
        }
    }

    @Override
    public void enterMethodCall(@Nullable JavaParser.MethodCallContext ctx) {
        ParseTree currentCtx;
        CodeCall codeCall = new CodeCall(null, null, null, null, null, null, 63, null);
        JavaParser.MethodCallContext methodCallContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)methodCallContext));
        ParseTree targetCtx = methodCallContext.parent.getChild(0);
        String targetType = this.parseTargetType(targetCtx.getText());
        if (targetCtx.getChild(0) != null && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass((currentCtx = targetCtx.getChild(0)).getClass()).getSimpleName(), (Object)"MethodCallContext")) {
            ParseTree parseTree = currentCtx;
            if (parseTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type chapi.ast.antlr.JavaParser.MethodCallContext");
            }
            targetType = ((JavaParser.MethodCallContext)parseTree).identifier().getText();
        }
        String callee = ctx.getChild(0).getText();
        this.buildMethodCallLocation(codeCall, ctx);
        Intrinsics.checkNotNullExpressionValue((Object)callee, (String)"callee");
        this.buildMethodCallMethodInfo(codeCall, callee, targetType, ctx);
        this.buildMethodCallParameters(codeCall, ctx);
        this.sendResultToMethodCallMap(codeCall);
    }

    private final void buildMethodCallParameters(CodeCall codeCall, JavaParser.MethodCallContext ctx) {
        if (ctx.expressionList() != null) {
            Object[] parameters = new CodeProperty[]{};
            for (JavaParser.ExpressionContext exprCtx : ctx.expressionList().expression()) {
                String string = exprCtx.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                CodeProperty parameter = new CodeProperty(null, null, string, "", null, null, null, null, 243, null);
                parameters = (CodeProperty[])ArraysKt.plus((Object[])parameters, (Object)parameter);
            }
            codeCall.setParameters((CodeProperty[])parameters);
        }
    }

    private final void buildMethodCallLocation(CodeCall codeCall, JavaParser.MethodCallContext ctx) {
        codeCall.setPosition(this.buildPosition(ctx));
    }

    private final void sendResultToMethodCallMap(CodeCall codeCall) {
        this.methodCalls = (CodeCall[])ArraysKt.plus((Object[])this.methodCalls, (Object)codeCall);
        String currentMethodName = this.getMethodMapName(this.currentFunction);
        CodeFunction method = this.methodMap.get(currentMethodName);
        if (method != null) {
            method.setFunctionCalls((CodeCall[])ArraysKt.plus((Object[])method.getFunctionCalls(), (Object)codeCall));
            this.methodMap.put(currentMethodName, method);
        }
    }

    private final void buildMethodCallMethodInfo(CodeCall codeCall, String callee, String _targetType, JavaParser.MethodCallContext ctx) {
        String packageName = this.codeContainer.getPackageName();
        String methodName = callee;
        String targetTypeStr = _targetType;
        JavaTargetType targetType = this.warpTargetFullType(targetTypeStr);
        CallType callType = targetType.getCallType();
        String fullType = targetType.getTargetType();
        if (Intrinsics.areEqual((Object)targetTypeStr, (Object)"super") || Intrinsics.areEqual((Object)callee, (Object)"super")) {
            callType = CallType.SUPER;
            targetTypeStr = this.currentClzExtend;
        }
        codeCall.setType(callType);
        if (!Intrinsics.areEqual((Object)fullType, (Object)"")) {
            packageName = this.removeTarget(fullType);
            methodName = callee;
        } else {
            String string = targetTypeStr;
            Intrinsics.checkNotNull((Object)string);
            TargetTypePackage targetTypePackage = this.handleEmptyFullType(ctx, string, methodName, packageName);
            if (!Intrinsics.areEqual((Object)targetTypePackage.getPackageName(), (Object)"")) {
                packageName = targetTypePackage.getPackageName();
            }
            if (!Intrinsics.areEqual((Object)targetTypePackage.getTargetType(), (Object)"")) {
                targetTypeStr = targetTypePackage.getTargetType();
            }
        }
        if (this.isChainCall(targetTypeStr)) {
            String string = targetTypeStr;
            Intrinsics.checkNotNull((Object)string);
            String[] stringArray = new String[]{"."};
            List split = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String string2 = targetTypeStr = this.parseTargetType((String)split.get(0));
            Intrinsics.checkNotNull((Object)string2);
            String[] stringArray2 = new String[]{"("};
            List splitQuote = StringsKt.split$default((CharSequence)string2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            targetTypeStr = (String)splitQuote.get(0);
        }
        codeCall.setPackage(packageName);
        codeCall.setFunctionName(methodName);
        String string = targetTypeStr;
        if (string == null) {
            string = "";
        }
        codeCall.setNodeName(string);
    }

    static /* synthetic */ void buildMethodCallMethodInfo$default(JavaFullIdentListener javaFullIdentListener, CodeCall codeCall, String string, String string2, JavaParser.MethodCallContext methodCallContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildMethodCallMethodInfo");
        }
        if ((n & 2) != 0) {
            string = "";
        }
        javaFullIdentListener.buildMethodCallMethodInfo(codeCall, string, string2, methodCallContext);
    }

    private final TargetTypePackage handleEmptyFullType(JavaParser.MethodCallContext ctx, String targetTypeObj, String methodName, String packageName) {
        String pkgName = packageName;
        String target = targetTypeObj;
        if (Intrinsics.areEqual((Object)ctx.getText(), (Object)target)) {
            String clz = this.currentClz;
            for (CodeImport imp : this.imports) {
                if (!StringsKt.endsWith$default((String)imp.getSource(), (String)Intrinsics.stringPlus((String)".", (Object)methodName), (boolean)false, (int)2, null)) continue;
                pkgName = imp.getSource();
                clz = "";
            }
            target = clz;
        } else if (StringsKt.contains$default((CharSequence)target, (CharSequence)"this.", (boolean)false, (int)2, null)) {
            String newType = StringsKt.replace$default((String)target, (String)"this.", (String)"", (boolean)false, (int)4, null);
            for (CodeField field : this.fields) {
                if (!Intrinsics.areEqual((Object)field.getTypeValue(), (Object)newType)) continue;
                target = field.getTypeType();
            }
        }
        return new TargetTypePackage(target, pkgName);
    }

    private final String removeTarget(String fullType) {
        String[] stringArray = new String[]{"."};
        List split = StringsKt.split$default((CharSequence)fullType, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)split, (int)1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    private final String parseTargetType(String target) {
        String targetType = target;
        String fieldType = this.fieldsMap.get(targetType);
        String localVarType = this.localVars.get(targetType);
        String formalType = this.formalParameters.get(targetType);
        if (fieldType != null && !Intrinsics.areEqual((Object)fieldType, (Object)"")) {
            targetType = fieldType;
        } else if (formalType != null && !Intrinsics.areEqual((Object)formalType, (Object)"")) {
            targetType = formalType;
        } else if (localVarType != null && !Intrinsics.areEqual((Object)localVarType, (Object)"")) {
            targetType = localVarType;
        }
        return targetType;
    }

    private final void updateCodeFunction(CodeFunction codeFunction) {
        if (this.currentType == DataStructType.CREATOR_CLASS) {
            Map<String, CodeFunction> map = this.creatorMethodMap;
            String string = this.getMethodMapName(codeFunction);
            map.put(string, codeFunction);
        } else {
            this.currentFunction = codeFunction;
            this.methodQueue = (CodeFunction[])ArraysKt.plus((Object[])this.methodQueue, (Object)this.currentFunction);
            Map<String, CodeFunction> map = this.methodMap;
            String string = this.getMethodMapName(codeFunction);
            map.put(string, codeFunction);
        }
    }

    private final String getMethodMapName(CodeFunction method) {
        String name = method.getName();
        if (!Intrinsics.areEqual((Object)name, (Object)"") && this.methodQueue.length > 1) {
            name = this.methodQueue[this.methodQueue.length - 1].getName();
        }
        return this.codeContainer.getPackageName() + '.' + this.currentClz + '.' + name + ':' + method.getPosition().getStartLine();
    }

    private final String buildExtend(String extendName) {
        String extend = extendName;
        String target = this.warpTargetFullType(extendName).getTargetType();
        if (!Intrinsics.areEqual((Object)target, (Object)"")) {
            extend = target;
        }
        return extend;
    }

    private final JavaTargetType warpTargetFullType(String targetType) {
        CallType callType = CallType.FUNCTION;
        if (Intrinsics.areEqual((Object)this.currentClz, (Object)targetType)) {
            return new JavaTargetType(this.codeContainer.getPackageName() + '.' + targetType, CallType.SELF);
        }
        String pureTargetType = this.buildPureTargetType(targetType);
        if (!Intrinsics.areEqual((Object)pureTargetType, (Object)"")) {
            for (CodeImport codeImport : this.imports) {
                if (!StringsKt.endsWith$default((String)codeImport.getSource(), (String)pureTargetType, (boolean)false, (int)2, null)) continue;
                return new JavaTargetType(codeImport.getSource(), CallType.CHAIN);
            }
        }
        for (String string : this.classes) {
            if (!StringsKt.endsWith$default((String)string, (String)Intrinsics.stringPlus((String)".", (Object)pureTargetType), (boolean)false, (int)2, null)) continue;
            return new JavaTargetType(string, CallType.SAME_PACKAGE);
        }
        if (Intrinsics.areEqual((Object)pureTargetType, (Object)"super") || Intrinsics.areEqual((Object)pureTargetType, (Object)"this")) {
            for (CodeImport codeImport : this.imports) {
                if (!StringsKt.endsWith$default((String)codeImport.getSource(), (String)this.currentClzExtend, (boolean)false, (int)2, null)) continue;
                return new JavaTargetType(codeImport.getSource(), CallType.SUPER);
            }
        }
        return new JavaTargetType(null, callType, 1, null);
    }

    private final String buildPureTargetType(String targetType) {
        String string = targetType;
        Intrinsics.checkNotNull((Object)string);
        String[] stringArray = new String[]{"."};
        List split = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String pureTargetType = StringsKt.replace$default((String)StringsKt.replace$default((String)((String)split.get(0)), (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null);
        return pureTargetType;
    }

    @Override
    public void exitFormalParameter(@Nullable JavaParser.FormalParameterContext ctx) {
        JavaParser.FormalParameterContext formalParameterContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)formalParameterContext));
        String paramKey = formalParameterContext.variableDeclaratorId().identifier().getText();
        Intrinsics.checkNotNullExpressionValue((Object)paramKey, (String)"paramKey");
        String string = ctx.typeType().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.typeType().text");
        this.formalParameters.put(paramKey, string);
    }

    @Override
    public void enterFieldDeclaration(@Nullable JavaParser.FieldDeclarationContext ctx) {
        super.enterFieldDeclaration(ctx);
        JavaParser.FieldDeclarationContext fieldDeclarationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)fieldDeclarationContext));
        JavaParser.VariableDeclaratorsContext declarators = fieldDeclarationContext.variableDeclarators();
        ParseTree typeType = declarators.parent.getChild(0);
        for (JavaParser.VariableDeclaratorContext declCtx : declarators.variableDeclarator()) {
            Intrinsics.checkNotNullExpressionValue((Object)typeType, (String)"typeType");
            JavaParser.ClassOrInterfaceTypeContext typeCtx = this.buildTypeCtxByIndex(typeType, null, 0);
            if (typeType.getChildCount() > 1) {
                typeCtx = this.buildTypeCtxByIndex(typeType, typeCtx, 1);
            }
            if (typeCtx == null) continue;
            String typeTypeText = typeCtx.identifier(0).getText();
            String typeValue = declCtx.variableDeclaratorId().identifier().getText();
            Intrinsics.checkNotNullExpressionValue((Object)typeValue, (String)"typeValue");
            Intrinsics.checkNotNullExpressionValue((Object)typeTypeText, (String)"typeTypeText");
            this.fieldsMap.put(typeValue, typeTypeText);
            CodeField field = new CodeField(typeTypeText, typeValue, null, null, new String[0], null, 44, null);
            this.fields = (CodeField[])ArraysKt.plus((Object[])this.fields, (Object)field);
            this.buildFieldCall(typeTypeText, ctx);
        }
    }

    private final void buildFieldCall(String typeType, JavaParser.FieldDeclarationContext ctx) {
        String target = this.warpTargetFullType(typeType).getTargetType();
        if (!Intrinsics.areEqual((Object)target, (Object)"")) {
            CodePosition position = this.buildPosition(ctx);
            CodeCall methodCall = new CodeCall(this.removeTarget(target), CallType.FIELD, typeType, null, null, position, 24, null);
            CodeDataStruct codeDataStruct = this.currentNode;
            codeDataStruct.setFunctionCalls((CodeCall[])ArraysKt.plus((Object[])codeDataStruct.getFunctionCalls(), (Object)methodCall));
        }
    }

    private final JavaParser.ClassOrInterfaceTypeContext buildTypeCtxByIndex(ParseTree typeType, JavaParser.ClassOrInterfaceTypeContext typeCtx, int index) {
        JavaParser.ClassOrInterfaceTypeContext newTypeCtx = typeCtx;
        ParseTree child = typeType.getChild(index);
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(child.getClass()).getSimpleName(), (Object)"ClassOrInterfaceTypeContext")) {
            ParseTree parseTree = child;
            if (parseTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type chapi.ast.antlr.JavaParser.ClassOrInterfaceTypeContext");
            }
            newTypeCtx = (JavaParser.ClassOrInterfaceTypeContext)parseTree;
        }
        return newTypeCtx;
    }

    @Override
    public void enterInterfaceDeclaration(@Nullable JavaParser.InterfaceDeclarationContext ctx) {
        this.hasEnterClass = true;
        this.currentType = DataStructType.INTERFACE;
        JavaParser.InterfaceDeclarationContext interfaceDeclarationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)interfaceDeclarationContext));
        String string = interfaceDeclarationContext.identifier().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx!!.identifier().text");
        this.currentNode.setNodeName(string);
        this.currentNode.setType(DataStructType.INTERFACE);
        this.currentNode.setPackage(this.codeContainer.getPackageName());
        if (ctx.EXTENDS() != null) {
            String extend = "";
            for (JavaParser.TypeListContext typeContext : ctx.typeList()) {
                String string2 = typeContext.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeContext.text");
                extend = this.buildExtend(string2);
            }
            this.currentNode.setExtend(extend);
        }
    }

    @Override
    public void exitInterfaceDeclaration(@Nullable JavaParser.InterfaceDeclarationContext ctx) {
        this.exitBody();
    }

    @Override
    public void enterAnnotation(@Nullable JavaParser.AnnotationContext ctx) {
        JavaParser.AnnotationContext annotationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)annotationContext));
        String annotationName = annotationContext.qualifiedName().getText();
        this.isOverrideMethod = Intrinsics.areEqual((Object)annotationName, (Object)"Override");
        if (!this.hasEnterClass) {
            CodeAnnotation annotation = this.buildAnnotation(ctx);
            if (this.currentType == DataStructType.CREATOR_CLASS) {
                CodeDataStruct codeDataStruct = this.currentNode;
                codeDataStruct.setAnnotations((CodeAnnotation[])ArraysKt.plus((Object[])codeDataStruct.getAnnotations(), (Object)annotation));
            } else {
                CodeDataStruct codeDataStruct = this.currentNode;
                codeDataStruct.setAnnotations((CodeAnnotation[])ArraysKt.plus((Object[])codeDataStruct.getAnnotations(), (Object)annotation));
            }
        }
    }

    @Override
    public void enterLocalVariableDeclaration(@Nullable JavaParser.LocalVariableDeclarationContext ctx) {
        JavaParser.LocalVariableDeclarationContext localVariableDeclarationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)localVariableDeclarationContext));
        String typ = localVariableDeclarationContext.getChild(0).getText();
        if (ctx.getChild(1) != null && ctx.getChild(1).getChild(0) != null && ctx.getChild(1).getChild(0).getChild(0) != null) {
            String variableName = ctx.getChild(1).getChild(0).getChild(0).getText();
            Intrinsics.checkNotNullExpressionValue((Object)variableName, (String)"variableName");
            Intrinsics.checkNotNullExpressionValue((Object)typ, (String)"typ");
            this.localVars.put(variableName, typ);
        }
    }

    @Override
    public void enterExpression(@Nullable JavaParser.ExpressionContext ctx) {
        JavaParser.ExpressionContext expressionContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)expressionContext));
        if (expressionContext.COLONCOLON() != null) {
            if (ctx.expression(0) == null) {
                return;
            }
            String text = ctx.expression(0).getText();
            String methodName = ctx.identifier().getText();
            String targetType = this.parseTargetType(text);
            String fullType = this.warpTargetFullType(targetType).getTargetType();
            CodePosition position = this.buildPosition(ctx);
            String string = this.removeTarget(fullType);
            String string2 = targetType;
            Intrinsics.checkNotNull((Object)string2);
            Intrinsics.checkNotNullExpressionValue((Object)methodName, (String)"methodName");
            CodeCall codeCall = new CodeCall(string, CallType.LAMBDA, string2, methodName, null, position, 16, null);
            this.sendResultToMethodCallMap(codeCall);
        }
    }

    @Override
    public void enterConstructorDeclaration(@Nullable JavaParser.ConstructorDeclarationContext ctx) {
        JavaParser.ConstructorDeclarationContext constructorDeclarationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)constructorDeclarationContext));
        String name = constructorDeclarationContext.identifier().getText();
        CodePosition position = this.buildPosition(ctx);
        boolean bl = this.isOverrideMethod;
        CodeAnnotation[] codeAnnotationArray = this.currentFunction.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        CodeFunction codeFunction = new CodeFunction(name, null, null, "", null, null, null, codeAnnotationArray, bl, null, null, null, position, null, null, true, false, 93814, null);
        JavaParser.FormalParametersContext paramCtx = ctx.formalParameters();
        if (paramCtx != null) {
            codeFunction.setParameters(this.buildMethodParameters(ctx.formalParameters()));
        }
        this.updateCodeFunction(codeFunction);
    }

    @Override
    public void enterCreator(@Nullable JavaParser.CreatorContext ctx) {
        List<JavaParser.IdentifierContext> allIdentifier;
        JavaParser.CreatorContext creatorContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)creatorContext));
        String variableName = creatorContext.getParent().getParent().getChild(0).getText();
        List<JavaParser.IdentifierContext> list = allIdentifier = ctx.createdName().identifier();
        Intrinsics.checkNotNull(list);
        for (JavaParser.IdentifierContext identifier : list) {
            CodeDataStruct creatorNode;
            String createdName = identifier.getText();
            Intrinsics.checkNotNullExpressionValue((Object)variableName, (String)"variableName");
            Intrinsics.checkNotNullExpressionValue((Object)createdName, (String)"createdName");
            this.localVars.put(variableName, createdName);
            if (Intrinsics.areEqual((Object)this.currentFunction.getName(), (Object)"")) {
                return;
            }
            if (ctx.classCreatorRest() == null) {
                return;
            }
            if (ctx.classCreatorRest().classBody() == null) {
                return;
            }
            String text = ctx.createdName().getText();
            this.currentType = DataStructType.CREATOR_CLASS;
            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
            this.currentCreatorNode = creatorNode = new CodeDataStruct(text, this.currentType, this.codeContainer.getPackageName(), null, null, null, null, null, null, null, null, null, null, null, null, null, this.buildPosition(ctx), 65528, null);
        }
    }

    @Override
    public void exitCreator(@Nullable JavaParser.CreatorContext ctx) {
        if (Intrinsics.areEqual((Object)this.currentCreatorNode.getNodeName(), (Object)"")) {
            return;
        }
        this.addToCreatorNodeMethod();
        this.addToParentClassMethodInner();
        this.classNodeStack.push((Object)this.currentCreatorNode);
        this.currentType = ((CodeDataStruct)this.classNodeStack.getElements().get(this.classNodeStack.getElements().size() - 1)).getType();
        this.classNodeStack.pop();
    }

    private final void addToCreatorNodeMethod() {
        this.currentCreatorNode.setFields(this.fields);
        this.currentCreatorNode.setMethodsFromMap(this.creatorMethodMap);
        this.creatorMethodMap = new LinkedHashMap();
        if (this.classNodeStack.peek() != null) {
            Object object = this.classNodeStack.peek();
            Intrinsics.checkNotNull((Object)object);
            this.currentType = ((CodeDataStruct)object).getType();
        }
    }

    private final void addToParentClassMethodInner() {
        String currentNodeMethodName = this.getMethodMapName(this.currentFunction);
        CodeFunction method = this.methodMap.get(currentNodeMethodName);
        if (method != null) {
            method.setInnerStructures((CodeDataStruct[])ArraysKt.plus((Object[])method.getInnerStructures(), (Object)this.currentCreatorNode));
            this.methodMap.put(currentNodeMethodName, method);
        }
    }

    private final void buildCreatedCall(String createdName, JavaParser.CreatorContext ctx) {
        CodeFunction codeFunction = this.methodMap.get(this.getMethodMapName(this.currentFunction));
        if (codeFunction == null) {
            return;
        }
        CodeFunction codeFunction2 = codeFunction;
        JavaTargetType fullType = this.warpTargetFullType(createdName);
        CodePosition codePosition = this.buildPosition(ctx);
        String string = this.removeTarget(fullType.getTargetType());
        String string2 = createdName;
        Intrinsics.checkNotNull((Object)string2);
        CodeCall codeCall = new CodeCall(string, CallType.CREATOR, string2, null, null, codePosition, 24, null);
        codeFunction2.setFunctionCalls((CodeCall[])ArraysKt.plus((Object[])codeFunction2.getFunctionCalls(), (Object)codeCall));
        Map<String, CodeFunction> map = this.methodMap;
        String string3 = this.getMethodMapName(this.currentFunction);
        map.put(string3, codeFunction2);
    }

    @NotNull
    public final CodeContainer getNodeInfo() {
        this.codeContainer.setDataStructures(this.classNodes);
        return this.codeContainer;
    }
}

