/*
 * Decompiled with CFR 0.152.
 */
package chapi.ast.kotlinast;

import chapi.ast.antlr.KotlinParser;
import chapi.ast.kotlinast.KotlinBasicIdentListener;
import chapi.domain.core.CallType;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeField;
import chapi.domain.core.CodeImport;
import chapi.domain.core.CodePosition;
import chapi.domain.core.CodeProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\f\u0010 \u001a\u00020\u0012*\u00020\u0012H\u0002J\u0016\u0010!\u001a\u0004\u0018\u00010\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0016\u0010\"\u001a\u0004\u0018\u00010\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020#H\u0002J\u0016\u0010$\u001a\u0004\u0018\u00010\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020%H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lchapi/ast/kotlinast/KotlinFullIdentListener;", "Lchapi/ast/kotlinast/KotlinBasicIdentListener;", "fileName", "", "(Ljava/lang/String;)V", "VARIABLE_POOL", "", "VAR_IN_STRING", "Lkotlin/text/Regex;", "postClassHandler", "", "Lkotlin/Function1;", "Lchapi/domain/core/CodeDataStruct;", "", "buildClass", "ctx", "Lchapi/ast/antlr/KotlinParser$ClassDeclarationContext;", "buildFunctionCall", "Lchapi/domain/core/CodeCall;", "it", "Lchapi/ast/antlr/KotlinParser$StatementContext;", "enterPostfixUnaryExpression", "Lchapi/ast/antlr/KotlinParser$PostfixUnaryExpressionContext;", "enterPropertyDeclaration", "Lchapi/ast/antlr/KotlinParser$PropertyDeclarationContext;", "parseParameter", "Lchapi/domain/core/CodeProperty;", "text", "textFromPrimaryExpr", "child", "Lchapi/ast/antlr/KotlinParser$PrimaryExpressionContext;", "typeFromText", "refineIfExistsCreator", "refineWithClass", "refineWithField", "Lchapi/domain/core/CodeField;", "refineWithImport", "Lchapi/domain/core/CodeImport;", "chapi-ast-kotlin"})
public class KotlinFullIdentListener
extends KotlinBasicIdentListener {
    @NotNull
    private final List<Function1<CodeDataStruct, Unit>> postClassHandler;
    @NotNull
    private Map<String, String> VARIABLE_POOL;
    @NotNull
    private final Regex VAR_IN_STRING;

    public KotlinFullIdentListener(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        super(fileName);
        this.postClassHandler = new ArrayList();
        this.VARIABLE_POOL = new LinkedHashMap();
        this.VAR_IN_STRING = new Regex("(\\$[a-zA-Z_]+)");
    }

    private final CodeCall buildFunctionCall(KotlinParser.StatementContext it) {
        Regex regex = new Regex("(\\w+\\.?)+\\((.*)\\)");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult result = matchResult;
        String matchedExpression = result.getValue();
        String functionName = (String)result.getGroupValues().get(1);
        CodeProperty[] codePropertyArray = new CodeProperty[]{this.parseParameter((String)result.getGroupValues().get(2))};
        CodeProperty[] parameters = codePropertyArray;
        MatchGroup matchGroup = result.getGroups().get(0);
        Intrinsics.checkNotNull((Object)matchGroup);
        int matchedStart = matchGroup.getRange().getFirst();
        MatchGroup matchGroup2 = result.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup2);
        int functionStart = matchGroup2.getRange().getFirst();
        String string2 = matchedExpression.substring(0, Math.max(functionStart - matchedStart - 1, 0));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String nodeName = string2;
        return this.refineIfExistsCreator(new CodeCall(null, Character.isUpperCase(functionName.charAt(0)) ? CallType.CREATOR : CallType.FUNCTION, nodeName, functionName, parameters, this.getPosition(it), 1, null));
    }

    @Override
    public void enterPropertyDeclaration(@Nullable KotlinParser.PropertyDeclarationContext ctx) {
        KotlinParser.PropertyDeclarationContext propertyDeclarationContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)propertyDeclarationContext));
        if (propertyDeclarationContext.variableDeclaration() != null) {
            Object object;
            KotlinParser.VariableDeclarationContext varDecl = ctx.variableDeclaration();
            String key = varDecl.simpleIdentifier().getText();
            if (ctx.ASSIGNMENT() != null) {
                String string;
                if (ctx.propertyDelegate() != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    string = ctx.propertyDelegate().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.propertyDelegate().text");
                    this.VARIABLE_POOL.put(key, string);
                }
                if (ctx.expression() != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    string = ctx.expression().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.expression().text");
                    this.VARIABLE_POOL.put(key, string);
                }
            }
            String varType = "";
            if (varDecl.type() != null) {
                object = varDecl.type().getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"varDecl.type().text");
                varType = object;
            }
            object = this.getCurrentFunction();
            Object[] objectArray = object.getLocalVariables();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            object.setLocalVariables((CodeProperty[])ArraysKt.plus((Object[])objectArray, (Object)new CodeProperty(null, null, key, varType, null, null, null, null, 243, null)));
        }
    }

    private final String typeFromText(String text) {
        CharSequence charSequence = text;
        String typeType = new Regex("\".*\"").matches(charSequence) ? this.getTypeFullName("String") : (new Regex("\\d+").matches(charSequence = (CharSequence)text) ? this.getTypeFullName("Number") : "");
        return typeType;
    }

    private final CodeProperty parseParameter(String text) {
        String typeType = this.typeFromText(text);
        String value = null;
        value = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)text, (CharSequence)"\""), (CharSequence)"\"");
        if (Intrinsics.areEqual((Object)typeType, (Object)"") && this.VARIABLE_POOL.get(value) != null) {
            MatchResult matches;
            value = String.valueOf(this.VARIABLE_POOL.get(value));
            MatchResult matchResult = matches = Regex.find$default((Regex)this.VAR_IN_STRING, (CharSequence)value, (int)0, (int)2, null);
            if (matchResult != null) {
                MatchGroupCollection matchGroupCollection = matchResult.getGroups();
                if (matchGroupCollection != null) {
                    Iterable $this$forEach$iv = (Iterable)matchGroupCollection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String variable;
                        String withoutVariable;
                        String pool;
                        MatchGroup it = (MatchGroup)element$iv;
                        boolean bl = false;
                        MatchGroup matchGroup = it;
                        if ((matchGroup == null ? null : matchGroup.getValue()) == null || (pool = this.VARIABLE_POOL.get(withoutVariable = StringsKt.removePrefix((String)(variable = it.getValue()), (CharSequence)"$"))) == null) continue;
                        String poolText = pool;
                        if (StringsKt.startsWith$default((String)poolText, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)poolText, (String)"\"", (boolean)false, (int)2, null)) {
                            poolText = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)poolText, (CharSequence)"\""), (CharSequence)"\"");
                        }
                        value = StringsKt.replace$default((String)value, (String)variable, (String)poolText, (boolean)false, (int)4, null);
                    }
                }
            }
            typeType = this.typeFromText(value);
        }
        return new CodeProperty(null, null, value, typeType, null, null, null, null, 243, null);
    }

    private final CodeCall refineIfExistsCreator(CodeCall $this$refineIfExistsCreator) {
        for (CodeDataStruct clazz : this.getClasses()) {
            if (this.refineWithClass($this$refineIfExistsCreator, clazz) != null) continue;
            return $this$refineIfExistsCreator;
        }
        for (CodeImport codeImport : this.getImports()) {
            if (this.refineWithImport($this$refineIfExistsCreator, codeImport) != null) continue;
            return $this$refineIfExistsCreator;
        }
        for (CodeField field : this.getCurrentNode().getFields()) {
            if (this.refineWithField($this$refineIfExistsCreator, field) != null) continue;
            return $this$refineIfExistsCreator;
        }
        this.postClassHandler.add(new Function1<CodeDataStruct, Unit>(this, $this$refineIfExistsCreator){
            final /* synthetic */ KotlinFullIdentListener this$0;
            final /* synthetic */ CodeCall $this_refineIfExistsCreator;
            {
                this.this$0 = $receiver;
                this.$this_refineIfExistsCreator = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull CodeDataStruct it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KotlinFullIdentListener.access$refineWithClass(this.this$0, this.$this_refineIfExistsCreator, it);
            }
        });
        return $this$refineIfExistsCreator;
    }

    private final CodeCall refineWithClass(CodeCall $this$refineWithClass, CodeDataStruct it) {
        if (Intrinsics.areEqual((Object)it.getNodeName(), (Object)$this$refineWithClass.getFunctionName())) {
            $this$refineWithClass.setType(CallType.CREATOR);
            $this$refineWithClass.setPackage(it.getPackage());
            return null;
        }
        return $this$refineWithClass;
    }

    private final CodeCall refineWithImport(CodeCall $this$refineWithImport, CodeImport it) {
        if (Intrinsics.areEqual((Object)it.getAsName(), (Object)$this$refineWithImport.getNodeName())) {
            $this$refineWithImport.setPackage(StringsKt.substringBeforeLast$default((String)it.getSource(), (char)'.', null, (int)2, null));
            return null;
        }
        if (Intrinsics.areEqual((Object)it.getAsName(), (Object)$this$refineWithImport.getFunctionName()) && Character.isUpperCase($this$refineWithImport.getFunctionName().charAt(0))) {
            $this$refineWithImport.setPackage(it.getSource());
            $this$refineWithImport.setNodeName($this$refineWithImport.getFunctionName());
            return null;
        }
        if (Intrinsics.areEqual((Object)it.getAsName(), (Object)$this$refineWithImport.getFunctionName())) {
            String fullNodeName = StringsKt.substringBeforeLast$default((String)it.getSource(), (char)'.', null, (int)2, null);
            $this$refineWithImport.setPackage(StringsKt.substringBeforeLast$default((String)fullNodeName, (char)'.', null, (int)2, null));
            $this$refineWithImport.setNodeName(StringsKt.substringAfterLast$default((String)fullNodeName, (char)'.', null, (int)2, null));
            return null;
        }
        return $this$refineWithImport;
    }

    private final CodeCall refineWithField(CodeCall $this$refineWithField, CodeField it) {
        if (Intrinsics.areEqual((Object)it.getTypeKey(), (Object)$this$refineWithField.getNodeName())) {
            String fullNodeName = it.getTypeType();
            $this$refineWithField.setPackage(StringsKt.substringBeforeLast$default((String)fullNodeName, (char)'.', null, (int)2, null));
            $this$refineWithField.setNodeName(StringsKt.substringAfterLast$default((String)fullNodeName, (char)'.', null, (int)2, null));
            return null;
        }
        return $this$refineWithField;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enterPostfixUnaryExpression(@Nullable KotlinParser.PostfixUnaryExpressionContext ctx) {
        Object[] calls = null;
        calls = new CodeCall[]{};
        String lastIdentifier = null;
        lastIdentifier = "";
        String lastPackage = null;
        lastPackage = "";
        String lastFunctionName = null;
        lastFunctionName = "";
        String lastNodeName = null;
        lastNodeName = "";
        String lastPostfixChildType = null;
        lastPostfixChildType = "";
        KotlinParser.PostfixUnaryExpressionContext postfixUnaryExpressionContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)postfixUnaryExpressionContext));
        List list = postfixUnaryExpressionContext.children;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx!!.children");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeCall call;
            Object[] objectArray;
            Object[] parameters;
            ParseTree child = (ParseTree)element$iv;
            boolean bl = false;
            ParseTree parseTree = child;
            if (parseTree instanceof KotlinParser.PrimaryExpressionContext) {
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                lastIdentifier = this.textFromPrimaryExpr((KotlinParser.PrimaryExpressionContext)child);
                continue;
            }
            if (!(parseTree instanceof KotlinParser.PostfixUnarySuffixContext)) continue;
            ParseTree postfix = (ParseTree)((KotlinParser.PostfixUnarySuffixContext)child).children.get(0);
            if (postfix instanceof KotlinParser.CallSuffixContext) {
                Collection thisCollection$iv;
                Collection $this$toTypedArray$iv;
                boolean $i$f$toTypedArray;
                KotlinParser.ValueArgumentsContext valueArguments = ((KotlinParser.CallSuffixContext)postfix).valueArguments();
                parameters = new CodeProperty[]{};
                if (valueArguments != null) {
                    void $this$mapTo$iv$iv;
                    List<KotlinParser.ValueArgumentContext> list2 = valueArguments.valueArgument();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"valueArguments.valueArgument()");
                    Object $this$map$iv = (Object[])list2;
                    boolean $i$f$map = false;
                    objectArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KotlinParser.ValueArgumentContext valueArgumentContext = (KotlinParser.ValueArgumentContext)((Object)item$iv$iv);
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        String string = it.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                        collection.add(this.parseParameter(string));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    CodeProperty[] codePropertyArray = thisCollection$iv.toArray(new CodeProperty[0]);
                    if (codePropertyArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    parameters = codePropertyArray;
                }
                if (Intrinsics.areEqual((Object)lastPostfixChildType, (Object)"NavigationSuffixContext")) {
                    $this$toTypedArray$iv = ArraysKt.dropLast((Object[])calls, (int)1);
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    CodeCall[] codeCallArray = thisCollection$iv.toArray(new CodeCall[0]);
                    if (codeCallArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    calls = codeCallArray;
                    lastIdentifier = lastFunctionName;
                }
                call = this.refineIfExistsCreator(new CodeCall(null, null, lastNodeName, lastIdentifier, (CodeProperty[])parameters, this.getPosition(ctx), 3, null));
                calls = ArraysKt.plus((Object[])calls, (Object)call);
                lastPostfixChildType = "CallSuffixContext";
                continue;
            }
            if (postfix instanceof KotlinParser.NavigationSuffixContext) {
                if (((KotlinParser.NavigationSuffixContext)postfix).simpleIdentifier() != null) {
                    String navigationName = ((KotlinParser.NavigationSuffixContext)postfix).simpleIdentifier().getText();
                    parameters = new CodeProperty[]{};
                    if (((KotlinParser.NavigationSuffixContext)postfix).parenthesizedExpression() != null) {
                        String param = ((KotlinParser.NavigationSuffixContext)postfix).parenthesizedExpression().expression().getText();
                        Intrinsics.checkNotNullExpressionValue((Object)param, (String)"param");
                        parameters = (CodeProperty[])ArraysKt.plus((Object[])parameters, (Object)this.parseParameter(param));
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)navigationName, (String)"navigationName");
                    lastFunctionName = navigationName;
                    String string = lastIdentifier;
                    objectArray = parameters;
                    String string2 = lastPackage;
                    CodePosition codePosition = this.getPosition(ctx);
                    call = this.refineIfExistsCreator(new CodeCall(string2, null, string, navigationName, (CodeProperty[])objectArray, codePosition, 2, null));
                    lastPackage = call.getPackage();
                    lastNodeName = call.getNodeName();
                    calls = ArraysKt.plus((Object[])calls, (Object)call);
                }
                lastPostfixChildType = "NavigationSuffixContext";
                continue;
            }
            String string = ((KotlinParser.PostfixUnarySuffixContext)child).children.get(0).getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"child.children[0].javaClass.simpleName");
            lastPostfixChildType = string;
        }
        if (!(((Object[])calls).length == 0)) {
            if (this.isEnteredIndividualFunction()) {
                list = this.getCurrentIndividualFunction();
                list.setFunctionCalls((CodeCall[])ArraysKt.plus((Object[])list.getFunctionCalls(), (Object[])calls));
            } else {
                list = this.getCurrentFunction();
                list.setFunctionCalls((CodeCall[])ArraysKt.plus((Object[])list.getFunctionCalls(), (Object[])calls));
            }
        }
    }

    private final String textFromPrimaryExpr(KotlinParser.PrimaryExpressionContext child) {
        String string;
        if (child.simpleIdentifier() != null) {
            String string2 = child.simpleIdentifier().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                child.\u2026fier().text\n            }");
            string = string2;
        } else if (child.stringLiteral() != null) {
            String string3 = child.stringLiteral().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n                child.\u2026eral().text\n            }");
            string = string3;
        } else {
            String string4 = child.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n                child.text\n            }");
            string = string4;
        }
        return string;
    }

    @Override
    @NotNull
    public CodeDataStruct buildClass(@NotNull KotlinParser.ClassDeclarationContext ctx) {
        CodeDataStruct codeDataStruct;
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        CodeDataStruct it = codeDataStruct = super.buildClass(ctx);
        boolean bl = false;
        Iterable $this$forEach$iv = this.postClassHandler;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 callback = (Function1)element$iv;
            boolean bl2 = false;
            callback.invoke((Object)it);
        }
        return codeDataStruct;
    }

    public static final /* synthetic */ CodeCall access$refineWithClass(KotlinFullIdentListener $this, CodeCall $receiver, CodeDataStruct it) {
        return $this.refineWithClass($receiver, it);
    }
}

