/*
 * Decompiled with CFR 0.152.
 */
package chapi.ast.antlr;

import java.util.Stack;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;

public abstract class PythonLexerBase
extends Lexer {
    public static int TabSize = 8;
    private int _opened;
    private Stack<Integer> _indents = new Stack();
    private int _firstTokensInd;
    private int _lastTokenInd;
    private Token[] _buffer = new Token[32];
    private Token _lastToken;

    protected PythonLexerBase(CharStream input) {
        super(input);
    }

    public void emit(Token token) {
        super.setToken(token);
        if (this._buffer[this._firstTokensInd] != null) {
            this._lastTokenInd = this.IncTokenInd(this._lastTokenInd);
            if (this._lastTokenInd == this._firstTokensInd) {
                Token[] newArray = new Token[this._buffer.length * 2];
                int destInd = newArray.length - (this._buffer.length - this._firstTokensInd);
                System.arraycopy(this._buffer, 0, newArray, 0, this._firstTokensInd);
                System.arraycopy(this._buffer, this._firstTokensInd, newArray, destInd, this._buffer.length - this._firstTokensInd);
                this._firstTokensInd = destInd;
                this._buffer = newArray;
            }
        }
        this._buffer[this._lastTokenInd] = token;
        this._lastToken = token;
    }

    public Token nextToken() {
        if (this._input.LA(1) == -1 && this._indents.size() > 0) {
            if (this._buffer[this._lastTokenInd] == null || this._buffer[this._lastTokenInd].getType() != 3) {
                this.emit(3);
            }
            while (this._indents.size() != 0) {
                this.emit(2);
                this._indents.pop();
            }
        }
        Token next = super.nextToken();
        if (this._buffer[this._firstTokensInd] == null) {
            return next;
        }
        Token result = this._buffer[this._firstTokensInd];
        this._buffer[this._firstTokensInd] = null;
        if (this._firstTokensInd != this._lastTokenInd) {
            this._firstTokensInd = this.IncTokenInd(this._firstTokensInd);
        }
        return result;
    }

    protected void HandleNewLine() {
        this.emit(98, 1, this.getText());
        char next = (char)this._input.LA(1);
        if (next != ' ' && next != '\t' && this.IsNotNewLineOrComment(next)) {
            this.ProcessNewLine(0);
        }
    }

    protected void HandleSpaces() {
        char next = (char)this._input.LA(1);
        if ((this._lastToken == null || this._lastToken.getType() == 98) && this.IsNotNewLineOrComment(next)) {
            int indent = 0;
            String text = this.getText();
            for (int i = 0; i < text.length(); ++i) {
                indent += text.charAt(i) == '\t' ? TabSize - indent % TabSize : 1;
            }
            this.ProcessNewLine(indent);
        }
        this.emit(99, 1, this.getText());
    }

    protected void IncIndentLevel() {
        ++this._opened;
    }

    protected void DecIndentLevel() {
        if (this._opened > 0) {
            --this._opened;
        }
    }

    private boolean IsNotNewLineOrComment(char next) {
        return this._opened == 0 && next != '\r' && next != '\n' && next != '\f' && next != '#';
    }

    private void ProcessNewLine(int indent) {
        int previous;
        this.emit(3);
        int n = previous = this._indents.size() == 0 ? 0 : this._indents.peek();
        if (indent > previous) {
            this._indents.push(indent);
            this.emit(1);
        } else {
            while (this._indents.size() != 0 && this._indents.peek() > indent) {
                this.emit(2);
                this._indents.pop();
            }
        }
    }

    private int IncTokenInd(int ind) {
        return (ind + 1) % this._buffer.length;
    }

    private void emit(int tokenType) {
        this.emit(tokenType, 0, "");
    }

    private void emit(int tokenType, int channel, String text) {
        int charIndex = this.getCharIndex();
        CommonToken token = new CommonToken(this._tokenFactorySourcePair, tokenType, channel, charIndex - text.length(), charIndex);
        token.setLine(this.getLine());
        token.setCharPositionInLine(this.getCharPositionInLine());
        token.setText(text);
        this.emit((Token)token);
    }
}

