/*
 * Decompiled with CFR 0.152.
 */
package chapi.ast.scalaast;

import chapi.ast.antlr.ScalaParser;
import chapi.ast.scalaast.ScalaAstBaseListener;
import chapi.domain.core.CodeContainer;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.DataStructType;
import chapi.infra.Stack;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0006J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lchapi/ast/scalaast/ScalaFullIdentListener;", "Lchapi/ast/scalaast/ScalaAstBaseListener;", "fileName", "", "(Ljava/lang/String;)V", "codeContainer", "Lchapi/domain/core/CodeContainer;", "currentDataStruct", "Lchapi/domain/core/CodeDataStruct;", "getFileName", "()Ljava/lang/String;", "setFileName", "structStack", "Lchapi/infra/Stack;", "enterClassDef", "", "ctx", "Lchapi/ast/antlr/ScalaParser$ClassDefContext;", "enterObjectDef", "Lchapi/ast/antlr/ScalaParser$ObjectDefContext;", "enterPackageDecl", "Lchapi/ast/antlr/ScalaParser$PackageDeclContext;", "enterTraitDef", "Lchapi/ast/antlr/ScalaParser$TraitDefContext;", "getNodeInfo", "updateStruct", "codeDataStruct", "chapi-ast-scala"})
public final class ScalaFullIdentListener
extends ScalaAstBaseListener {
    @NotNull
    private String fileName;
    @NotNull
    private final Stack<CodeDataStruct> structStack;
    @NotNull
    private CodeDataStruct currentDataStruct;
    @NotNull
    private CodeContainer codeContainer;

    public ScalaFullIdentListener(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fileName = fileName;
        this.structStack = new Stack();
        this.currentDataStruct = new CodeDataStruct(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 262143, null);
        this.codeContainer = new CodeContainer(this.fileName, null, null, null, null, null, null, 126, null);
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fileName = string;
    }

    @Override
    public void enterObjectDef(@Nullable ScalaParser.ObjectDefContext ctx) {
        ScalaParser.ObjectDefContext objectDefContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)objectDefContext));
        String objectName = objectDefContext.Id().getText();
        Intrinsics.checkNotNullExpressionValue((Object)objectName, (String)"objectName");
        CodeDataStruct codeDataStruct = new CodeDataStruct(objectName, null, DataStructType.OBJECT, null, this.codeContainer.getFullName(), null, null, null, null, null, null, null, null, null, null, null, null, null, 262122, null);
        this.updateStruct(codeDataStruct);
    }

    private final void updateStruct(CodeDataStruct codeDataStruct) {
        this.currentDataStruct = codeDataStruct;
        if (this.structStack.getElements().size() > 0) {
            CodeDataStruct lastStruct = (CodeDataStruct)CollectionsKt.last((List)this.structStack.getElements());
            lastStruct.setInnerStructures(CollectionsKt.plus((Collection)lastStruct.getInnerStructures(), (Object)this.currentDataStruct));
        } else {
            CodeContainer codeContainer = this.codeContainer;
            codeContainer.setDataStructures(CollectionsKt.plus((Collection)codeContainer.getDataStructures(), (Object)this.currentDataStruct));
        }
        this.structStack.push((Object)this.currentDataStruct);
    }

    @Override
    public void enterClassDef(@Nullable ScalaParser.ClassDefContext ctx) {
        ScalaParser.ClassDefContext classDefContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)classDefContext));
        String className = classDefContext.Id().getText();
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"className");
        CodeDataStruct codeDataStruct = new CodeDataStruct(className, null, DataStructType.CLASS, null, this.codeContainer.getFullName(), null, null, null, null, null, null, null, null, null, null, null, null, null, 262122, null);
        codeDataStruct.setParameters(this.buildParameters(ctx.classParamClauses()));
        if (ctx.classTemplateOpt() != null && ctx.classTemplateOpt().classTemplate() != null) {
            String extend = ctx.classTemplateOpt().classTemplate().classParents().constr().annotType().getText();
            Intrinsics.checkNotNullExpressionValue((Object)extend, (String)"extend");
            codeDataStruct.setExtend(extend);
        }
        this.updateStruct(codeDataStruct);
    }

    @Override
    public void enterTraitDef(@Nullable ScalaParser.TraitDefContext ctx) {
        ScalaParser.TraitDefContext traitDefContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)traitDefContext));
        String className = traitDefContext.Id().getText();
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"className");
        CodeDataStruct codeDataStruct = new CodeDataStruct(className, null, DataStructType.TRAIT, null, this.codeContainer.getFullName(), null, null, null, null, null, null, null, null, null, null, null, null, null, 262122, null);
        this.updateStruct(codeDataStruct);
    }

    @Override
    public void enterPackageDecl(@Nullable ScalaParser.PackageDeclContext ctx) {
        ScalaParser.PackageDeclContext packageDeclContext = ctx;
        Intrinsics.checkNotNull((Object)((Object)packageDeclContext));
        String packageName = packageDeclContext.qualId().getText();
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        this.codeContainer.setPackageName(packageName);
    }

    @NotNull
    public final CodeContainer getNodeInfo() {
        return this.codeContainer;
    }
}

