/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.data;

import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.sun.codemodel.JCodeModel;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;
import org.raml.model.ParamType;
import org.raml.parser.utils.Inflector;

public class ApiBodyMetadata {
    private String name;
    private String schema;
    private JCodeModel codeModel;
    private boolean array = false;

    public ApiBodyMetadata(String name, String schema, JCodeModel codeModel) {
        int nextQuoteIdxIdx;
        int quoteIdx;
        this.schema = schema;
        this.name = name;
        this.codeModel = codeModel;
        int typeIdx = schema.indexOf("type");
        if (typeIdx != -1 && (quoteIdx = schema.indexOf("\"", typeIdx + 6)) != -1 && (nextQuoteIdxIdx = schema.indexOf("\"", quoteIdx + 1)) != -1) {
            String possibleType = schema.substring(quoteIdx + 1, nextQuoteIdxIdx);
            if ("array".equals(possibleType.toLowerCase())) {
                this.array = true;
                this.name = Inflector.singularize((String)this.name);
            }
            if (codeModel.countArtifacts() == 0 && !"object".equals(possibleType.toLowerCase())) {
                try {
                    this.name = SchemaHelper.mapSimpleType(ParamType.valueOf((String)possibleType.toUpperCase())).getSimpleName();
                }
                catch (Exception ex) {
                    this.name = String.class.getSimpleName();
                }
                this.codeModel = null;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public boolean isArray() {
        return this.array;
    }

    public JCodeModel getCodeModel(String basePackage, GenerationConfig config, Annotator annotator) {
        return SchemaHelper.buildBodyJCodeModel(basePackage, this.name, this.schema, config, annotator);
    }
}

